
<?php $__env->startSection('title', 'Why Choose Us'); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span>Why Choose Us Items</span>
            <a href="<?php echo e(route('admin.why-choose-us.create')); ?>" class="btn btn-primary btn-sm"><i
                    class="fas fa-plus me-1"></i> Add New</a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Image</th>
                            <th>Title</th>
                            <th>Status</th>
                            <th>Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php if($item->image): ?><img src="<?php echo e(asset($item->image)); ?>" alt=""
                                style="width: 50px; height: 50px; object-fit: cover; border-radius: 5px;"><?php else: ?><span
                                        class="text-muted">-</span><?php endif; ?></td>
                                <td><strong><?php echo e($item->title); ?></strong><br><small
                                        class="text-muted"><?php echo e(Str::limit($item->description, 50)); ?></small></td>
                                <td><?php if($item->is_active): ?><span class="badge bg-success">Active</span><?php else: ?><span
                                class="badge bg-secondary">Inactive</span><?php endif; ?></td>
                                <td><?php echo e($item->sort_order); ?></td>
                                <td>
                                    <a href="<?php echo e(route('admin.why-choose-us.edit', $item)); ?>"
                                        class="btn btn-sm btn-outline-primary"><i class="fas fa-edit"></i></a>
                                    <form action="<?php echo e(route('admin.why-choose-us.destroy', $item)); ?>" method="POST"
                                        class="d-inline" onsubmit="return confirm('Are you sure?')"><?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?><button type="submit" class="btn btn-sm btn-outline-danger"><i
                                                class="fas fa-trash"></i></button></form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center py-4 text-muted">No items found</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo e($items->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\landingpagecms\laravel-app\resources\views/admin/why-choose-us/index.blade.php ENDPATH**/ ?>