
<?php $__env->startSection('title', 'FAQs'); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span>FAQs</span>
            <a href="<?php echo e(route('admin.faqs.create')); ?>" class="btn btn-primary btn-sm"><i class="fas fa-plus me-1"></i> Add
                New</a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Question</th>
                            <th>Status</th>
                            <th>Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e(Str::limit($faq->question, 60)); ?></td>
                                <td><?php if($faq->is_active): ?><span class="badge bg-success">Active</span><?php else: ?><span
                                class="badge bg-secondary">Inactive</span><?php endif; ?></td>
                                <td><?php echo e($faq->sort_order); ?></td>
                                <td>
                                    <a href="<?php echo e(route('admin.faqs.edit', $faq)); ?>" class="btn btn-sm btn-outline-primary"><i
                                            class="fas fa-edit"></i></a>
                                    <form action="<?php echo e(route('admin.faqs.destroy', $faq)); ?>" method="POST" class="d-inline"
                                        onsubmit="return confirm('Are you sure?')"><?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?><button type="submit"
                                            class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button></form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="4" class="text-center py-4 text-muted">No FAQs found</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo e($faqs->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\landingpagecms\laravel-app\resources\views/admin/faqs/index.blade.php ENDPATH**/ ?>