

<?php $__env->startSection('title', 'Packages'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span>All Packages</span>
            <a href="<?php echo e(route('admin.packages.create')); ?>" class="btn btn-primary btn-sm">
                <i class="fas fa-plus me-1"></i> Add New
            </a>
        </div>
        <div class="card-body">
            <div class="mb-3">
                <form action="" method="GET" class="d-flex gap-2">
                    <select name="category" class="form-select form-select-sm" style="width: 200px;">
                        <option value="">All Categories</option>
                        <option value="best_kashmir" <?php echo e(request('category') == 'best_kashmir' ? 'selected' : ''); ?>>Best
                            Kashmir</option>
                        <option value="honeymoon" <?php echo e(request('category') == 'honeymoon' ? 'selected' : ''); ?>>Honeymoon
                        </option>
                        <option value="adventure" <?php echo e(request('category') == 'adventure' ? 'selected' : ''); ?>>Adventure
                        </option>
                        <option value="cultural" <?php echo e(request('category') == 'cultural' ? 'selected' : ''); ?>>Cultural</option>
                    </select>
                    <button type="submit" class="btn btn-sm btn-secondary">Filter</button>
                </form>
            </div>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Image</th>
                            <th>Title</th>
                            <th>Category</th>
                            <th>Duration</th>
                            <th>Price</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <?php if($package->image): ?>
                                        <img src="<?php echo e(asset($package->image)); ?>" alt=""
                                            style="width: 60px; height: 40px; object-fit: cover; border-radius: 5px;">
                                    <?php else: ?>
                                        <span class="text-muted">No image</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($package->title); ?></td>
                                <td><span class="badge bg-info"><?php echo e(ucfirst(str_replace('_', ' ', $package->category))); ?></span>
                                </td>
                                <td><?php echo e($package->duration_days); ?>D / <?php echo e($package->duration_nights); ?>N</td>
                                <td>₹<?php echo e(number_format($package->price)); ?></td>
                                <td>
                                    <?php if($package->is_active): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.packages.edit', $package)); ?>"
                                        class="btn btn-sm btn-outline-primary"><i class="fas fa-edit"></i></a>
                                    <form action="<?php echo e(route('admin.packages.destroy', $package)); ?>" method="POST"
                                        class="d-inline" onsubmit="return confirm('Are you sure?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-outline-danger"><i
                                                class="fas fa-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-4 text-muted">No packages found</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo e($packages->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\landingpagecms\laravel-app\resources\views/admin/packages/index.blade.php ENDPATH**/ ?>