

<?php $__env->startSection('title', 'Tracking Codes'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <i class="fas fa-code me-2"></i>Tracking Codes Settings
        </div>
        <div class="card-body">
            <p class="text-muted mb-4">Add your analytics and tracking codes here. These will be automatically added to the
                &lt;head&gt; section of your website.</p>

            <form action="<?php echo e(route('admin.tracking-codes.update')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">
                                <i class="fab fa-google me-1"></i>Google Analytics ID
                            </label>
                            <input type="text" name="google_analytics_id" class="form-control"
                                value="<?php echo e(old('google_analytics_id', $settings->google_analytics_id)); ?>"
                                placeholder="G-XXXXXXXXXX or UA-XXXXXXXXX-X">
                            <div class="form-text">Enter your Google Analytics 4 Measurement ID (starts with G-) or
                                Universal Analytics ID (starts with UA-)</div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">
                                <i class="fab fa-facebook me-1"></i>Facebook Pixel ID
                            </label>
                            <input type="text" name="facebook_pixel_id" class="form-control"
                                value="<?php echo e(old('facebook_pixel_id', $settings->facebook_pixel_id)); ?>"
                                placeholder="XXXXXXXXXXXXXXXX">
                            <div class="form-text">Enter your 15-16 digit Facebook Pixel ID</div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label class="form-label">
                                <i class="fas fa-tags me-1"></i>Google Tag Manager ID
                            </label>
                            <input type="text" name="google_tag_manager_id" class="form-control"
                                value="<?php echo e(old('google_tag_manager_id', $settings->google_tag_manager_id)); ?>"
                                placeholder="GTM-XXXXXXX">
                            <div class="form-text">Enter your GTM Container ID (starts with GTM-)</div>
                        </div>
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label">
                        <i class="fas fa-code me-1"></i>Custom Head Scripts
                    </label>
                    <textarea name="custom_head_scripts" class="form-control" rows="8"
                        placeholder="<!-- Paste any custom tracking scripts here -->"><?php echo e(old('custom_head_scripts', $settings->custom_head_scripts)); ?></textarea>
                    <div class="form-text">Add any additional tracking scripts or meta tags. These will be injected directly
                        into the &lt;head&gt; section.</div>
                </div>

                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>
                    <strong>Note:</strong> Changes will take effect immediately on the frontend after saving.
                </div>

                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>Save Tracking Codes
                </button>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/slipinho/public_html/tour.slipinholidays.com/resources/views/admin/tracking-codes/edit.blade.php ENDPATH**/ ?>