
<?php $__env->startSection('title', 'Enquiries'); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span>Customer Enquiries</span>
            <div>
                <a href="<?php echo e(route('admin.enquiries.index')); ?>"
                    class="btn btn-sm <?php echo e(!request('status') ? 'btn-primary' : 'btn-outline-secondary'); ?>">All</a>
                <a href="<?php echo e(route('admin.enquiries.index', ['status' => 'unread'])); ?>"
                    class="btn btn-sm <?php echo e(request('status') == 'unread' ? 'btn-primary' : 'btn-outline-secondary'); ?>">Unread</a>
                <a href="<?php echo e(route('admin.enquiries.index', ['status' => 'read'])); ?>"
                    class="btn btn-sm <?php echo e(request('status') == 'read' ? 'btn-primary' : 'btn-outline-secondary'); ?>">Read</a>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Package</th>
                            <th>Contact</th>
                            <th>Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $enquiries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enquiry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="<?php echo e(!$enquiry->is_read ? 'table-warning' : ''); ?>">
                                <td><strong><?php echo e($enquiry->name); ?></strong></td>
                                <td><?php echo e($enquiry->package_name ?? '-'); ?></td>
                                <td><?php echo e($enquiry->mobile); ?><br><small class="text-muted"><?php echo e($enquiry->email); ?></small></td>
                                <td><?php echo e($enquiry->created_at->format('M d, Y')); ?><br><small
                                        class="text-muted"><?php echo e($enquiry->created_at->format('h:i A')); ?></small></td>
                                <td><?php if($enquiry->is_read): ?><span class="badge bg-success">Read</span><?php else: ?><span
                                class="badge bg-warning">Unread</span><?php endif; ?></td>
                                <td>
                                    <a href="<?php echo e(route('admin.enquiries.show', $enquiry)); ?>"
                                        class="btn btn-sm btn-outline-info"><i class="fas fa-eye"></i></a>
                                    <form action="<?php echo e(route('admin.enquiries.destroy', $enquiry)); ?>" method="POST"
                                        class="d-inline" onsubmit="return confirm('Are you sure?')"><?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?><button type="submit" class="btn btn-sm btn-outline-danger"><i
                                                class="fas fa-trash"></i></button></form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center py-4 text-muted">No enquiries found</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo e($enquiries->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\landingpagecms\laravel-app\resources\views/admin/enquiries/index.blade.php ENDPATH**/ ?>