<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'Admin Panel'); ?> - Travel CMS</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        :root {
            --sidebar-width: 250px;
            --primary-color: #667eea;
            --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f4f6f9;
        }

        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            width: var(--sidebar-width);
            height: 100vh;
            background: var(--primary-gradient);
            padding: 20px 0;
            z-index: 1000;
            overflow-y: auto;
        }

        .sidebar-brand {
            color: white;
            text-align: center;
            padding: 20px;
            font-size: 1.4rem;
            font-weight: bold;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            margin-bottom: 20px;
        }

        .sidebar-nav {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .sidebar-nav li a {
            display: flex;
            align-items: center;
            padding: 12px 25px;
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            transition: all 0.3s;
        }

        .sidebar-nav li a:hover,
        .sidebar-nav li a.active {
            background: rgba(255, 255, 255, 0.15);
            color: white;
            border-left: 4px solid white;
        }

        .sidebar-nav li a i {
            margin-right: 12px;
            width: 20px;
            text-align: center;
        }

        .main-content {
            margin-left: var(--sidebar-width);
            padding: 20px 30px;
            min-height: 100vh;
        }

        .top-bar {
            background: white;
            padding: 15px 25px;
            margin: -20px -30px 25px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .top-bar h4 {
            margin: 0;
            color: #333;
        }

        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 2px 15px rgba(0, 0, 0, 0.05);
        }

        .card-header {
            background: white;
            border-bottom: 1px solid #eee;
            font-weight: 600;
            padding: 15px 20px;
        }

        .btn-primary {
            background: var(--primary-gradient);
            border: none;
        }

        .btn-primary:hover {
            opacity: 0.9;
            background: var(--primary-gradient);
        }

        .table th {
            font-weight: 600;
            color: #555;
            border-bottom-width: 1px;
        }

        .badge-unread {
            background: #dc3545;
            color: white;
            border-radius: 50%;
            padding: 2px 6px;
            font-size: 0.7rem;
            margin-left: 5px;
        }

        /* Mobile Toggle Button */
        .sidebar-toggle {
            display: none;
            position: fixed;
            top: 15px;
            left: 15px;
            z-index: 1100;
            background: var(--primary-gradient);
            border: none;
            color: white;
            width: 45px;
            height: 45px;
            border-radius: 10px;
            font-size: 1.2rem;
            cursor: pointer;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
            transition: all 0.3s ease;
        }

        .sidebar-toggle:hover {
            transform: scale(1.05);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
        }

        /* Overlay for mobile */
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 999;
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .sidebar-overlay.active {
            opacity: 1;
        }

        /* Close button inside sidebar for mobile */
        .sidebar-close {
            display: none;
            position: absolute;
            top: 15px;
            right: 15px;
            background: rgba(255, 255, 255, 0.2);
            border: none;
            color: white;
            width: 35px;
            height: 35px;
            border-radius: 50%;
            font-size: 1rem;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .sidebar-close:hover {
            background: rgba(255, 255, 255, 0.3);
        }

        /* Mobile Responsive Styles */
        @media (max-width: 991.98px) {
            .sidebar-toggle {
                display: flex;
                align-items: center;
                justify-content: center;
            }

            .sidebar-overlay {
                display: block;
                pointer-events: none;
            }

            .sidebar-overlay.active {
                pointer-events: auto;
            }

            .sidebar-close {
                display: flex;
                align-items: center;
                justify-content: center;
            }

            .sidebar {
                transform: translateX(-100%);
                transition: transform 0.3s ease;
            }

            .sidebar.active {
                transform: translateX(0);
            }

            .main-content {
                margin-left: 0;
                padding: 20px 15px;
            }

            .top-bar {
                margin: -20px -15px 25px;
                padding: 15px 60px 15px 70px;
            }

            .top-bar h4 {
                font-size: 1.1rem;
            }
        }

        @media (max-width: 575.98px) {
            .top-bar {
                flex-direction: column;
                align-items: flex-start;
                gap: 10px;
                padding: 15px 15px 15px 70px;
            }

            .top-bar h4 {
                font-size: 1rem;
            }
        }

        /* Pagination Styles */
        .pagination {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 5px;
            padding: 0;
            margin: 20px 0 0;
            list-style: none;
        }

        .pagination li {
            display: inline-block;
        }

        .pagination li a,
        .pagination li span {
            display: flex;
            align-items: center;
            justify-content: center;
            min-width: 36px;
            height: 36px;
            padding: 0 12px;
            font-size: 14px;
            font-weight: 500;
            color: #667eea;
            background-color: #fff;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            text-decoration: none;
            transition: all 0.2s ease;
        }

        .pagination li a:hover {
            background: var(--primary-gradient);
            color: white;
            border-color: #667eea;
        }

        .pagination li.active span {
            background: var(--primary-gradient);
            color: white;
            border-color: #667eea;
        }

        .pagination li.disabled span {
            color: #adb5bd;
            background-color: #f8f9fa;
            border-color: #dee2e6;
            cursor: not-allowed;
        }

        /* Laravel's default pagination wrapper */
        nav[role="navigation"] {
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        nav[role="navigation"]>div {
            display: flex;
            flex-direction: column;
            align-items: center;
            width: 100%;
        }

        nav[role="navigation"] .flex.justify-between {
            display: flex;
            justify-content: space-between;
            width: 100%;
            margin-top: 10px;
        }

        nav[role="navigation"] p.text-sm {
            font-size: 14px;
            color: #6c757d;
            margin: 0;
        }

        /* Tailwind pagination (if using) */
        nav[role="navigation"] span[aria-current="page"] span {
            background: var(--primary-gradient) !important;
            color: white !important;
            border-color: #667eea !important;
        }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body>
    <!-- Mobile Toggle Button -->
    <button class="sidebar-toggle" id="sidebarToggle" aria-label="Toggle Sidebar">
        <i class="fas fa-bars"></i>
    </button>

    <!-- Overlay for mobile -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <div class="sidebar" id="sidebar">
        <!-- Close button for mobile -->
        <button class="sidebar-close" id="sidebarClose" aria-label="Close Sidebar">
            <i class="fas fa-times"></i>
        </button>
        <div class="sidebar-brand">
            <i class="fas fa-plane-departure"></i> ElySpace
        </div>
        <ul class="sidebar-nav">
            <li><a href="<?php echo e(route('admin.dashboard')); ?>"
                    class="<?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>"><i
                        class="fas fa-tachometer-alt"></i> Dashboard</a></li>
            <li><a href="<?php echo e(route('admin.packages.index')); ?>"
                    class="<?php echo e(request()->routeIs('admin.packages.*') ? 'active' : ''); ?>"><i class="fas fa-box"></i>
                    Packages</a></li>
            <li><a href="<?php echo e(route('admin.banners.index')); ?>"
                    class="<?php echo e(request()->routeIs('admin.banners.*') ? 'active' : ''); ?>"><i class="fas fa-images"></i>
                    Banners</a></li>
            <li><a href="<?php echo e(route('admin.destinations.index')); ?>"
                    class="<?php echo e(request()->routeIs('admin.destinations.*') ? 'active' : ''); ?>"><i
                        class="fas fa-map-marker-alt"></i> Destinations</a></li>
            <li><a href="<?php echo e(route('admin.faqs.index')); ?>"
                    class="<?php echo e(request()->routeIs('admin.faqs.*') ? 'active' : ''); ?>"><i
                        class="fas fa-question-circle"></i> FAQs</a></li>
            <li><a href="<?php echo e(route('admin.why-choose-us.index')); ?>"
                    class="<?php echo e(request()->routeIs('admin.why-choose-us.*') ? 'active' : ''); ?>"><i
                        class="fas fa-star"></i> Why Choose Us</a></li>
            <li><a href="<?php echo e(route('admin.static-pages.index')); ?>"
                    class="<?php echo e(request()->routeIs('admin.static-pages.*') ? 'active' : ''); ?>"><i
                        class="fas fa-file-alt"></i> Static Pages</a></li>
            <li>
                <a href="<?php echo e(route('admin.enquiries.index')); ?>"
                    class="<?php echo e(request()->routeIs('admin.enquiries.*') ? 'active' : ''); ?>">
                    <i class="fas fa-envelope"></i> Enquiries
                    <?php $unreadCount = \App\Models\Enquiry::unread()->count(); ?>
                    <?php if($unreadCount > 0): ?>
                        <span class="badge-unread"><?php echo e($unreadCount); ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li><a href="<?php echo e(route('admin.footer.edit')); ?>"
                    class="<?php echo e(request()->routeIs('admin.footer.*') ? 'active' : ''); ?>"><i class="fas fa-cog"></i> Footer
                    Settings</a></li>
            <li><a href="<?php echo e(route('admin.tracking-codes.edit')); ?>"
                    class="<?php echo e(request()->routeIs('admin.tracking-codes.*') ? 'active' : ''); ?>"><i
                        class="fas fa-code"></i> Tracking
                    Codes</a></li>
            <li><a href="<?php echo e(route('admin.seo-settings.edit')); ?>"
                    class="<?php echo e(request()->routeIs('admin.seo-settings.*') ? 'active' : ''); ?>"><i
                        class="fas fa-search"></i> SEO
                    Settings</a></li>
            <li><a href="<?php echo e(route('admin.profile.edit')); ?>"
                    class="<?php echo e(request()->routeIs('admin.profile.*') ? 'active' : ''); ?>"><i class="fas fa-user-cog"></i>
                    My Profile</a></li>
            <li style="margin-top: 30px; border-top: 1px solid rgba(255,255,255,0.1); padding-top: 15px;">
                <a href="<?php echo e(route('admin.logout')); ?>"><i class="fas fa-sign-out-alt"></i> Logout</a>
            </li>
        </ul>
    </div>

    <div class="main-content">
        <div class="top-bar">
            <h4><?php echo $__env->yieldContent('title', 'Dashboard'); ?></h4>
            <div>
                <span class="text-muted">Welcome,</span> <strong><?php echo e(session('admin_name', 'Admin')); ?></strong>
            </div>
        </div>

        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show">
                <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show">
                <?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php echo $__env->yieldContent('content'); ?>

        <div class="bottom-bar" style="margin-top: 51px;">
            <div>
                <span class="text-muted">Copyright <?php echo date("Y");?> © <a
                        href="https://elyspace.com">ElySpace.</a></span>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Mobile Sidebar Toggle
        document.addEventListener('DOMContentLoaded', function () {
            const sidebar = document.getElementById('sidebar');
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebarClose = document.getElementById('sidebarClose');
            const sidebarOverlay = document.getElementById('sidebarOverlay');

            function openSidebar() {
                sidebar.classList.add('active');
                sidebarOverlay.classList.add('active');
                document.body.style.overflow = 'hidden';
            }

            function closeSidebar() {
                sidebar.classList.remove('active');
                sidebarOverlay.classList.remove('active');
                document.body.style.overflow = '';
            }

            // Toggle button click
            sidebarToggle.addEventListener('click', openSidebar);

            // Close button click
            sidebarClose.addEventListener('click', closeSidebar);

            // Overlay click
            sidebarOverlay.addEventListener('click', closeSidebar);

            // Close sidebar when clicking a nav link (on mobile)
            const navLinks = sidebar.querySelectorAll('.sidebar-nav a');
            navLinks.forEach(link => {
                link.addEventListener('click', function () {
                    if (window.innerWidth < 992) {
                        closeSidebar();
                    }
                });
            });

            // Close sidebar on escape key
            document.addEventListener('keydown', function (e) {
                if (e.key === 'Escape' && sidebar.classList.contains('active')) {
                    closeSidebar();
                }
            });

            // Handle window resize
            window.addEventListener('resize', function () {
                if (window.innerWidth >= 992) {
                    closeSidebar();
                }
            });
        });
    </script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html><?php /**PATH C:\xampp\htdocs\landingpagecms\laravel-app\resources\views/admin/layouts/app.blade.php ENDPATH**/ ?>