

<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body text-center">
                    <i class="fas fa-box fa-2x text-primary mb-3"></i>
                    <h3><?php echo e($stats['total_packages']); ?></h3>
                    <p class="text-muted mb-0">Total Packages</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body text-center">
                    <i class="fas fa-images fa-2x text-success mb-3"></i>
                    <h3><?php echo e($stats['total_banners']); ?></h3>
                    <p class="text-muted mb-0">Total Banners</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body text-center">
                    <i class="fas fa-envelope fa-2x text-info mb-3"></i>
                    <h3><?php echo e($stats['total_enquiries']); ?></h3>
                    <p class="text-muted mb-0">Total Enquiries</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body text-center">
                    <i class="fas fa-envelope-open fa-2x text-warning mb-3"></i>
                    <h3><?php echo e($stats['unread_enquiries']); ?></h3>
                    <p class="text-muted mb-0">Unread Enquiries</p>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>Recent Enquiries</span>
                    <a href="<?php echo e(route('admin.enquiries.index')); ?>" class="btn btn-sm btn-primary">View All</a>
                </div>
                <div class="card-body">
                    <?php if($recentEnquiries->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Package</th>
                                        <th>Mobile</th>
                                        <th>Date</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $recentEnquiries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enquiry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($enquiry->name); ?></td>
                                            <td><?php echo e($enquiry->package_name ?? 'N/A'); ?></td>
                                            <td><?php echo e($enquiry->mobile); ?></td>
                                            <td><?php echo e($enquiry->created_at->format('M d, Y')); ?></td>
                                            <td>
                                                <?php if($enquiry->is_read): ?>
                                                    <span class="badge bg-success">Read</span>
                                                <?php else: ?>
                                                    <span class="badge bg-warning">Unread</span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <p class="text-muted text-center py-4">No enquiries yet</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">Quick Actions</div>
                <div class="card-body">
                    <a href="<?php echo e(route('admin.packages.create')); ?>" class="btn btn-outline-primary w-100 mb-2">
                        <i class="fas fa-plus me-2"></i> Add New Package
                    </a>
                    <a href="<?php echo e(route('admin.banners.create')); ?>" class="btn btn-outline-success w-100 mb-2">
                        <i class="fas fa-plus me-2"></i> Add New Banner
                    </a>
                    <a href="<?php echo e(route('admin.destinations.create')); ?>" class="btn btn-outline-info w-100 mb-2">
                        <i class="fas fa-plus me-2"></i> Add New Destination
                    </a>
                    <a href="<?php echo e(route('admin.faqs.create')); ?>" class="btn btn-outline-warning w-100">
                        <i class="fas fa-plus me-2"></i> Add New FAQ
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/slipinho/public_html/tour.slipinholidays.com/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>