

<?php $__env->startSection('title', 'Edit Package'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">Edit Package: <?php echo e($package->title); ?></div>
        <div class="card-body">
            <form action="<?php echo e(route('admin.packages.update', $package)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="row">
                    <div class="col-md-8">
                        <div class="mb-3">
                            <label class="form-label">Title *</label>
                            <input type="text" name="title" class="form-control" value="<?php echo e(old('title', $package->title)); ?>"
                                required>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Category *</label>
                                    <select name="category" class="form-select" required>
                                        <option value="best_kashmir" <?php echo e($package->category == 'best_kashmir' ? 'selected' : ''); ?>>Best Kashmir</option>
                                        <option value="honeymoon" <?php echo e($package->category == 'honeymoon' ? 'selected' : ''); ?>>
                                            Honeymoon</option>
                                        <option value="adventure" <?php echo e($package->category == 'adventure' ? 'selected' : ''); ?>>
                                            Adventure</option>
                                        <option value="cultural" <?php echo e($package->category == 'cultural' ? 'selected' : ''); ?>>
                                            Cultural</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">Days *</label>
                                    <input type="number" name="duration_days" class="form-control"
                                        value="<?php echo e(old('duration_days', $package->duration_days)); ?>" min="1" required>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">Nights *</label>
                                    <input type="number" name="duration_nights" class="form-control"
                                        value="<?php echo e(old('duration_nights', $package->duration_nights)); ?>" min="0" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">Flights</label>
                                    <input type="number" name="flights" class="form-control"
                                        value="<?php echo e(old('flights', $package->flights)); ?>" min="0">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">Hotels</label>
                                    <input type="number" name="hotels" class="form-control"
                                        value="<?php echo e(old('hotels', $package->hotels)); ?>" min="0">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">Activities</label>
                                    <input type="number" name="activities" class="form-control"
                                        value="<?php echo e(old('activities', $package->activities)); ?>" min="0">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">Transfers</label>
                                    <input type="number" name="transfers" class="form-control"
                                        value="<?php echo e(old('transfers', $package->transfers)); ?>" min="0">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Price (₹)</label>
                                    <input type="number" name="price" class="form-control"
                                        value="<?php echo e(old('price', $package->price)); ?>" step="0.01">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Original Price (₹) (Per Person)</label>
                                    <input type="number" name="original_price" class="form-control"
                                        value="<?php echo e(old('original_price', $package->original_price)); ?>" step="0.01">
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Location (comma separated)</label>
                            <textarea name="inclusions" class="form-control" rows="2"
                                placeholder="Flights, 3 Star Hotels, Breakfast, Cab"><?php echo e(old('inclusions', $package->inclusions ?? '')); ?></textarea>
                            <small class="text-muted">Items that are included in the package</small>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Itinerary (one per line & comma separated)</label>
                            <textarea name="highlights" class="form-control" rows="2"
                                placeholder="Dal Lake Visit, Shikara Ride, Gulmarg Gondola"><?php echo e(old('highlights', $package->highlights ?? '')); ?></textarea>
                            <small class="text-muted">Key highlights of the package</small>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label bg-danger p-2 text-white rounded">Image: Use 600 x 600 Px Size For
                                Image</label>
                            <?php if($package->image): ?>
                                <div class="mb-2">
                                    <img src="<?php echo e(asset($package->image)); ?>" alt="" class="img-thumbnail"
                                        style="max-width: 200px;">
                                </div>
                            <?php endif; ?>
                            <input type="file" name="image" class="form-control" accept="image/*">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Sort Order</label>
                            <input type="number" name="sort_order" class="form-control"
                                value="<?php echo e(old('sort_order', $package->sort_order)); ?>">
                        </div>
                        <div class="mb-3">
                            <div class="form-check">
                                <input type="checkbox" name="is_active" class="form-check-input" value="1" <?php echo e($package->is_active ? 'checked' : ''); ?>>
                                <label class="form-check-label">Active</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="mt-4">
                    <button type="submit" class="btn btn-primary"><i class="fas fa-save me-1"></i> Update Package</button>
                    <a href="<?php echo e(route('admin.packages.index')); ?>" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\landingpagecms\laravel-app\resources\views/admin/packages/edit.blade.php ENDPATH**/ ?>