
<?php $__env->startSection('title'); ?>
<title><?php echo e($seo_setting->seo_title); ?></title>
<meta name="title" content="<?php echo e($seo_setting->seo_title); ?>">
<meta name="description" content="<?php echo strip_tags(clean($seo_setting->seo_description)); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('front-content'); ?>

<?php echo $__env->make('breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Privacy Policy Section -->
<section class="privacy-policy-section">
    <div class="td_height_100 td_height_lg_50"></div>
    <div class="container">
        <div class="row td_gap_y_50">
            <div class="col-lg-12">

                <!-- Policy Card -->
                <div class="policy-card">
                    <!-- Policy Header -->
                    <div class="policy-header">
                        <div class="policy-icon">
                            <i class="fa-solid fa-shield-halved"></i>
                        </div>
                        <h1 class="policy-title"><?php echo e($seo_setting->seo_title); ?></h1>
                        <p class="policy-updated">Last Updated: <?php echo e(now()->format('F d, Y')); ?></p>
                    </div>

                    <!-- Policy Content -->
                    <div class="policy-content">
                        <div class="td_blog_details">
                            <?php echo clean($privacy_policy->description); ?>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <div class="td_height_100 td_height_lg_50"></div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('style_section'); ?>
<style>
/* ========================================
   Privacy Policy Page - Modern Design
   ======================================== */

/* Variables */
:root {
    --pp-primary: #2563eb;
    --pp-primary-light: #dbeafe;
    --pp-primary-dark: #1d4ed8;
    --pp-secondary: #0ea5e9;
    --pp-accent: #8b5cf6;
    --pp-text: #1e293b;
    --pp-text-light: #64748b;
    --pp-text-muted: #94a3b8;
    --pp-border: #e2e8f0;
    --pp-bg: #f8fafc;
    --pp-white: #ffffff;
    --pp-shadow: 0 1px 3px rgba(0, 0, 0, 0.08);
    --pp-shadow-md: 0 4px 20px rgba(0, 0, 0, 0.08);
    --pp-shadow-lg: 0 10px 40px rgba(0, 0, 0, 0.12);
    --pp-radius: 20px;
    --pp-radius-sm: 12px;
}

/* Page Section */
.privacy-policy-section {
    background: linear-gradient(180deg, var(--pp-bg) 0%, var(--pp-white) 50%);
    min-height: 60vh;
}

/* Policy Card */
.policy-card {
    background: var(--pp-white);
    border-radius: var(--pp-radius);
    box-shadow: var(--pp-shadow-lg);
    overflow: hidden;
    animation: fadeInUp 0.6s ease-out;
}

/* Policy Header */
.policy-header {
    text-align: center;
    padding: 50px 40px 40px;
    background: linear-gradient(135deg, var(--pp-primary) 0%, var(--pp-primary-dark) 100%);
    position: relative;
    overflow: hidden;
}

.policy-header::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -20%;
    width: 400px;
    height: 400px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 50%;
}

.policy-header::after {
    content: '';
    position: absolute;
    bottom: -30%;
    left: -10%;
    width: 300px;
    height: 300px;
    background: rgba(255, 255, 255, 0.05);
    border-radius: 50%;
}

.policy-icon {
    width: 80px;
    height: 80px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 20px;
    position: relative;
    z-index: 1;
}

.policy-icon i {
    font-size: 36px;
    color: var(--pp-white);
}

.policy-title {
    font-size: 32px;
    font-weight: 700;
    color: var(--pp-white);
    margin: 0 0 12px 0;
    position: relative;
    z-index: 1;
}

.policy-updated {
    font-size: 14px;
    color: rgba(255, 255, 255, 0.8);
    margin: 0;
    position: relative;
    z-index: 1;
}

/* Policy Content */
.policy-content {
    padding: 50px 60px 60px;
}

/* Blog Details Styling */
.policy-content .td_blog_details {
    color: var(--pp-text);
    font-size: 16px;
    line-height: 1.85;
}

/* Typography */
.policy-content h1,
.policy-content h2,
.policy-content h3,
.policy-content h4,
.policy-content h5,
.policy-content h6 {
    color: var(--pp-text);
    font-weight: 600;
    margin-top: 36px;
    margin-bottom: 16px;
    line-height: 1.4;
}

.policy-content h1:first-child,
.policy-content h2:first-child,
.policy-content h3:first-child {
    margin-top: 0;
}

.policy-content h2 {
    font-size: 26px;
    padding-bottom: 14px;
    border-bottom: 2px solid var(--pp-primary-light);
    display: flex;
    align-items: center;
    gap: 12px;
}

.policy-content h2::before {
    content: '';
    width: 4px;
    height: 28px;
    background: var(--pp-primary);
    border-radius: 2px;
}

.policy-content h3 {
    font-size: 20px;
    color: var(--pp-primary-dark);
}

.policy-content h4 {
    font-size: 18px;
}

.policy-content p {
    margin-bottom: 18px;
    color: var(--pp-text);
}

.policy-content p:last-child {
    margin-bottom: 0;
}

/* Strong/Bold Text */
.policy-content strong,
.policy-content b {
    color: var(--pp-text);
    font-weight: 600;
}

/* Links */
.policy-content a {
    color: var(--pp-primary);
    text-decoration: none;
    font-weight: 500;
    transition: all 0.2s ease;
    border-bottom: 1px dashed var(--pp-primary);
}

.policy-content a:hover {
    color: var(--pp-secondary);
    border-bottom-style: solid;
}

/* Lists */
.policy-content ul,
.policy-content ol {
    margin: 24px 0;
    padding-left: 0;
    list-style: none;
}

.policy-content ul li,
.policy-content ol li {
    position: relative;
    padding: 12px 0 12px 36px;
    border-bottom: 1px solid var(--pp-border);
}

.policy-content ul li:last-child,
.policy-content ol li:last-child {
    border-bottom: none;
}

.policy-content ul li::before {
    content: '';
    position: absolute;
    left: 8px;
    top: 20px;
    width: 8px;
    height: 8px;
    background: var(--pp-primary);
    border-radius: 50%;
}

.policy-content ol {
    counter-reset: policy-item;
}

.policy-content ol li {
    padding-left: 44px;
}

.policy-content ol li::before {
    content: counter(policy-item);
    counter-increment: policy-item;
    position: absolute;
    left: 0;
    top: 10px;
    width: 28px;
    height: 28px;
    background: linear-gradient(135deg, var(--pp-primary) 0%, var(--pp-primary-dark) 100%);
    color: var(--pp-white);
    border-radius: 50%;
    font-size: 13px;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
}

/* Nested Lists */
.policy-content ul ul,
.policy-content ol ol,
.policy-content ul ol,
.policy-content ol ul {
    margin: 12px 0;
    padding-left: 20px;
}

/* Blockquote */
.policy-content blockquote {
    margin: 32px 0;
    padding: 24px 32px;
    background: linear-gradient(135deg, var(--pp-primary-light) 0%, var(--pp-white) 100%);
    border-left: 4px solid var(--pp-primary);
    border-radius: 0 var(--pp-radius-sm) var(--pp-radius-sm) 0;
    font-style: italic;
    color: var(--pp-text);
}

.policy-content blockquote p {
    margin: 0;
}

/* Tables */
.policy-content table {
    width: 100%;
    margin: 28px 0;
    border-collapse: collapse;
    border-radius: var(--pp-radius-sm);
    overflow: hidden;
    box-shadow: var(--pp-shadow);
}

.policy-content table thead {
    background: linear-gradient(135deg, var(--pp-primary) 0%, var(--pp-primary-dark) 100%);
    color: var(--pp-white);
}

.policy-content table th {
    padding: 16px 20px;
    text-align: left;
    font-weight: 600;
    font-size: 14px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.policy-content table td {
    padding: 16px 20px;
    border-bottom: 1px solid var(--pp-border);
}

.policy-content table tbody tr:nth-child(even) {
    background: var(--pp-bg);
}

.policy-content table tbody tr:hover {
    background: var(--pp-primary-light);
}

/* Highlighted Sections */
.policy-content .highlight,
.policy-content .important,
.policy-content .note {
    padding: 20px 24px;
    border-radius: var(--pp-radius-sm);
    margin: 24px 0;
}

/* Horizontal Rule */
.policy-content hr {
    border: none;
    height: 2px;
    background: linear-gradient(90deg, transparent, var(--pp-border), transparent);
    margin: 40px 0;
}

/* Animation */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Responsive Styles */
@media (max-width: 992px) {
    .policy-header {
        padding: 40px 30px 35px;
    }

    .policy-title {
        font-size: 28px;
    }

    .policy-icon {
        width: 70px;
        height: 70px;
    }

    .policy-icon i {
        font-size: 30px;
    }

    .policy-content {
        padding: 40px 40px 50px;
    }
}

@media (max-width: 768px) {
    .policy-header {
        padding: 35px 24px 30px;
    }

    .policy-title {
        font-size: 24px;
    }

    .policy-icon {
        width: 60px;
        height: 60px;
    }

    .policy-icon i {
        font-size: 26px;
    }

    .policy-updated {
        font-size: 13px;
    }

    .policy-content {
        padding: 32px 28px 40px;
    }

    .policy-content .td_blog_details {
        font-size: 15px;
    }

    .policy-content h2 {
        font-size: 22px;
    }

    .policy-content h2::before {
        height: 24px;
    }

    .policy-content h3 {
        font-size: 18px;
    }

    .policy-content blockquote {
        padding: 20px 24px;
    }
}

@media (max-width: 480px) {
    .policy-card {
        border-radius: var(--pp-radius-sm);
    }

    .policy-header {
        padding: 30px 20px 25px;
    }

    .policy-title {
        font-size: 20px;
    }

    .policy-icon {
        width: 56px;
        height: 56px;
    }

    .policy-icon i {
        font-size: 24px;
    }

    .policy-content {
        padding: 28px 20px 36px;
    }

    .policy-content .td_blog_details {
        font-size: 14px;
        line-height: 1.75;
    }

    .policy-content h2 {
        font-size: 18px;
        padding-bottom: 10px;
    }

    .policy-content h2::before {
        width: 3px;
        height: 20px;
    }

    .policy-content ul li,
    .policy-content ol li {
        padding-left: 30px;
    }

    .policy-content ol li {
        padding-left: 38px;
    }

    .policy-content ol li::before {
        width: 24px;
        height: 24px;
        font-size: 11px;
    }

    .policy-content table th,
    .policy-content table td {
        padding: 12px 14px;
        font-size: 13px;
    }
}

/* Print Styles */
@media print {
    .privacy-policy-section {
        background: white;
    }

    .policy-card {
        box-shadow: none;
        border: 1px solid #ddd;
    }

    .policy-header {
        background: #f5f5f5;
        color: #333;
    }

    .policy-icon,
    .policy-header::before,
    .policy-header::after {
        display: none;
    }

    .policy-title {
        color: #333;
    }

    .policy-updated {
        color: #666;
    }
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layout_inner_page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/slipinho/public_html/resources/views/privacy_policy.blade.php ENDPATH**/ ?>