<style>
    .dark-footer {
        background-color: #0b1120;
        color: #e2e8f0;
        padding-top: 80px;
        font-family: 'Inter', sans-serif;
    }

    .footer-container {
        max-width: 1400px;
        margin: 0 auto;
        padding: 0 20px;
    }

    .footer-widget-title {
        color: #fff;
        font-size: 20px;
        font-weight: 700;
        margin-bottom: 25px;
        position: relative;
        display: inline-block;
        padding-bottom: 10px;
    }

    .footer-widget-title::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 100%;
        height: 2px;
        background-color: #31b8e6;
        /* Teal accent */
    }

    .footer-logo img {
        max-height: 50px;
        margin-bottom: 20px;
    }

    .footer-text {
        color: #94a3b8;
        line-height: 1.6;
        margin-bottom: 25px;
        font-size: 15px;
    }

    /* Form Styles */
    .newsletter-form {
        position: relative;
        margin-bottom: 25px;
    }

    .newsletter-input {
        width: 100%;
        padding: 12px 15px;
        background-color: rgba(255, 255, 255, 0.05);
        border: 1px solid #1e293b;
        border-radius: 6px;
        color: #fff;
        outline: none;
        transition: border-color 0.3s;
    }

    .newsletter-input:focus {
        border-color: #31b8e6;
    }

    .newsletter-btn {
        position: absolute;
        right: 5px;
        top: 5px;
        background-color: #31b8e6;
        border: none;
        width: 38px;
        height: 38px;
        border-radius: 4px;
        color: #0f172a;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: background 0.3s;
    }

    .newsletter-btn:hover {
        background-color: #14b8a6;
    }

    /* Social Icons */
    .social-links {
        display: flex;
        gap: 15px;
    }

    .social-icon {
        width: 36px;
        height: 36px;
        background-color: rgba(255, 255, 255, 0.1);
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 6px;
        color: #fff;
        transition: all 0.3s;
        text-decoration: none;
    }

    .social-icon:hover {
        background-color: #31b8e6;
        color: #0f172a;
        transform: translateY(-3px);
    }

    /* Links */
    .footer-menu ul {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .footer-menu li {
        margin-bottom: 12px;
    }

    .footer-menu a {
        color: #cbd5e1;
        text-decoration: none;
        transition: color 0.3s;
        display: block;
        font-size: 15px;
    }

    .footer-menu a:hover {
        color: #31b8e6;
        padding-left: 5px;
    }

    /* Contact Info */
    .contact-item {
        display: flex;
        gap: 15px;
        margin-bottom: 20px;
        color: #cbd5e1;
    }

    .contact-icon {
        color: #31b8e6;
        margin-top: 5px;
        flex-shrink: 0;
    }

    .contact-item a {
        color: #cbd5e1;
        text-decoration: none;
        transition: color 0.3s;
    }

    .contact-item a:hover {
        color: #31b8e6;
    }

    /* Footer Bottom */
    .footer-bottom {
        border-top: 1px solid #1e293b;
        padding: 30px 0;
        text-align: center;
        margin-top: 60px;
        background-color: #0f172a;
    }

    .copyright-text {
        font-size: 14px;
        color: #64748b;
    }

    .copyright-highlight {
        color: #31b8e6;
    }
</style>

<footer class="dark-footer">
    <div class="footer-container">
        <div class="row">
            <!-- Col 1: Logo, About, social -->
            <div class="col-lg-3 col-md-6 mb-5">
                <div class="footer-widget">
                    <div class="footer-logo">
                        <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset($general_setting->footer_logo)); ?>"
                                alt="Logo"></a>
                    </div>
                    <p class="footer-text"><?php echo e(Str::limit($footer->about_us, 150)); ?></p>

                    <div class="newsletter-form d-none">
                        <form action="<?php echo e(route('store-newsletter')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="email" class="newsletter-input" placeholder="Enter your mail" name="email">
                            <button class="newsletter-btn" type="submit">
                                <i class="fa-solid fa-paper-plane"></i>
                            </button>
                        </form>
                    </div>

                    <div class="social-links">
                        <?php if($footer->facebook): ?>
                        <a href="<?php echo e($footer->facebook); ?>" class="social-icon"><i
                                class="fa-brands fa-facebook-f"></i></a>
                        <?php endif; ?>
                        <?php if($footer->twitter): ?>
                        <a href="<?php echo e($footer->twitter); ?>" class="social-icon"><i class="fa-brands fa-twitter"></i></a>
                        <?php endif; ?>
                        <?php if($footer->instagram): ?>
                        <a href="<?php echo e($footer->instagram); ?>" class="social-icon"><i
                                class="fa-brands fa-instagram"></i></a>
                        <?php endif; ?>
                        <?php if($footer->linkedin): ?>
                        <a href="<?php echo e($footer->linkedin); ?>" class="social-icon"><i
                                class="fa-brands fa-linkedin-in"></i></a>
                        <?php endif; ?>
                        <?php if($footer->youtube): ?>
                        <a href="<?php echo e($footer->youtube); ?>" class="social-icon"><i class="fa-brands fa-youtube"></i></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Col 2: Services (Menu 1) -->
            <div class="col-lg-3 col-md-6 mb-5">
                <div class="footer-widget ml-lg-5">
                    <h3 class="footer-widget-title"><?php echo e(__('translate.Quick Links')); ?></h3>
                    <div class="footer-menu">
                        <?php echo wp_nav_menu([
                        'theme_location' => 'footer_menu_1',
                        'menu_class' => '',
                        'container' => false,
                        'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                        ]); ?>

                    </div>
                </div>
            </div>

            <!-- Col 3: Specialties (Menu 2) -->
            <div class="col-lg-3 col-md-6 mb-5">
                <div class="footer-widget">
                    <h3 class="footer-widget-title"><?php echo e(__('translate.Utility Pages')); ?></h3>
                    <div class="footer-menu">
                        <?php echo wp_nav_menu([
                        'theme_location' => 'footer_menu_2',
                        'menu_class' => '',
                        'container' => false,
                        'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                        ]); ?>

                    </div>
                </div>
            </div>

            <!-- Col 4: Contact Info -->
            <div class="col-lg-3 col-md-6 mb-5">
                <div class="footer-widget">
                    <h3 class="footer-widget-title"><?php echo e(__('translate.Information')); ?></h3>

                    <div class="contact-info">
                        <?php if($footer->address || $footer->address_url): ?>
                        <div class="contact-item">
                            <div class="contact-icon">
                                <i class="fa-solid fa-location-dot"></i>
                            </div>
                            <div>
                                <a href="<?php echo e($footer->address_url); ?>"><?php echo e($footer->address); ?></a>
                            </div>
                        </div>
                        <?php endif; ?>

                        <?php if($footer->phone): ?>
                        <div class="contact-item">
                            <div class="contact-icon">
                                <i class="fa-solid fa-phone"></i>
                            </div>
                            <div>
                                <a href="tel:<?php echo e($footer->phone); ?>"><?php echo e($footer->phone); ?></a>
                            </div>
                        </div>
                        <?php endif; ?>

                        <?php if($footer->working_days): ?>
                        <div class="contact-item">
                            <div class="contact-icon">
                                <i class="fa-solid fa-clock"></i>
                            </div>
                            <div>
                                <?php echo e($footer->working_days); ?>

                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="footer-bottom">
        <div class="container">
            <p class="copyright-text">
                <?php echo e($footer->copyright); ?> Developed By <a href="https://elyspace.com/web-design" class="elyspace">ElySpace</a>
                | <span class="copyright-highlight">Professional • Trusted • Travel</span>
            </p>
        </div>
    </div>
</footer><?php /**PATH /home/slipinho/public_html/Cms/themes/theme1/views/components/footer.blade.php ENDPATH**/ ?>