
<?php $__env->startSection('title'); ?>
<title><?php echo e($custom_page->page_name); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('front-content'); ?>

<?php echo $__env->make('breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Custom Page Content Section -->
<section class="custom-page-section">
    <div class="td_height_100 td_height_lg_50"></div>
    <div class="container">
        <div class="row td_gap_y_50">
            <div class="col-lg-12">
                <div class="custom-page-wrapper">
                    <!-- Page Header -->
                    <div class="custom-page-header">
                        <h1 class="custom-page-title"><?php echo e($custom_page->page_name); ?></h1>
                        <div class="title-decoration">
                            <span class="decoration-line"></span>
                            <span class="decoration-dot"></span>
                            <span class="decoration-line"></span>
                        </div>
                    </div>

                    <!-- Page Content -->
                    <div class="custom-page-content">
                        <article class="td_blog_details">
                            <?php echo clean($custom_page->description); ?>

                        </article>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="td_height_100 td_height_lg_50"></div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('style_section'); ?>
<style>
/* ========================================
   Custom Page - Modern Clean Design
   ======================================== */

/* Variables */
:root {
    --cp-primary: #2563eb;
    --cp-primary-light: #dbeafe;
    --cp-secondary: #0ea5e9;
    --cp-text: #1e293b;
    --cp-text-light: #64748b;
    --cp-text-muted: #94a3b8;
    --cp-border: #e2e8f0;
    --cp-bg: #f8fafc;
    --cp-white: #ffffff;
    --cp-shadow: 0 1px 3px rgba(0, 0, 0, 0.08);
    --cp-shadow-md: 0 4px 20px rgba(0, 0, 0, 0.08);
    --cp-shadow-lg: 0 10px 40px rgba(0, 0, 0, 0.1);
    --cp-radius: 16px;
    --cp-radius-sm: 8px;
}

/* Page Section */
.custom-page-section {
    background: linear-gradient(180deg, var(--cp-bg) 0%, var(--cp-white) 100%);
    min-height: 60vh;
}

/* Page Wrapper */
.custom-page-wrapper {
    background: var(--cp-white);
    border-radius: var(--cp-radius);
    box-shadow: var(--cp-shadow-md);
    overflow: hidden;
}

/* Page Header */
.custom-page-header {
    text-align: center;
    padding: 48px 40px 32px;
    background: linear-gradient(135deg, var(--cp-primary-light) 0%, var(--cp-white) 100%);
    border-bottom: 1px solid var(--cp-border);
}

.custom-page-title {
    font-size: 36px;
    font-weight: 700;
    color: var(--cp-text);
    margin: 0 0 20px 0;
    line-height: 1.3;
    letter-spacing: -0.5px;
}

/* Title Decoration */
.title-decoration {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 12px;
}

.decoration-line {
    width: 60px;
    height: 3px;
    background: linear-gradient(90deg, transparent, var(--cp-primary));
    border-radius: 2px;
}

.decoration-line:last-child {
    background: linear-gradient(90deg, var(--cp-primary), transparent);
}

.decoration-dot {
    width: 10px;
    height: 10px;
    background: var(--cp-primary);
    border-radius: 50%;
    box-shadow: 0 0 0 4px var(--cp-primary-light);
}

/* Page Content */
.custom-page-content {
    padding: 48px 60px 60px;
}

/* Article Styles */
.custom-page-content .td_blog_details {
    color: var(--cp-text);
    font-size: 17px;
    line-height: 1.85;
}

/* Typography Enhancements */
.custom-page-content h1,
.custom-page-content h2,
.custom-page-content h3,
.custom-page-content h4,
.custom-page-content h5,
.custom-page-content h6 {
    color: var(--cp-text);
    font-weight: 600;
    margin-top: 32px;
    margin-bottom: 16px;
    line-height: 1.4;
}

.custom-page-content h2 {
    font-size: 28px;
    padding-bottom: 12px;
    border-bottom: 2px solid var(--cp-border);
}

.custom-page-content h3 {
    font-size: 22px;
}

.custom-page-content h4 {
    font-size: 18px;
}

.custom-page-content p {
    margin-bottom: 20px;
    color: var(--cp-text);
}

.custom-page-content p:last-child {
    margin-bottom: 0;
}

/* Links */
.custom-page-content a {
    color: var(--cp-primary);
    text-decoration: none;
    font-weight: 500;
    transition: all 0.2s ease;
    border-bottom: 1px solid transparent;
}

.custom-page-content a:hover {
    color: var(--cp-secondary);
    border-bottom-color: var(--cp-secondary);
}

/* Lists */
.custom-page-content ul,
.custom-page-content ol {
    margin: 20px 0;
    padding-left: 0;
    list-style: none;
}

.custom-page-content ul li,
.custom-page-content ol li {
    position: relative;
    padding: 10px 0 10px 32px;
    border-bottom: 1px solid var(--cp-border);
}

.custom-page-content ul li:last-child,
.custom-page-content ol li:last-child {
    border-bottom: none;
}

.custom-page-content ul li::before {
    content: '';
    position: absolute;
    left: 0;
    top: 18px;
    width: 8px;
    height: 8px;
    background: var(--cp-primary);
    border-radius: 50%;
}

.custom-page-content ol {
    counter-reset: item;
}

.custom-page-content ol li::before {
    content: counter(item);
    counter-increment: item;
    position: absolute;
    left: 0;
    top: 8px;
    width: 24px;
    height: 24px;
    background: var(--cp-primary);
    color: var(--cp-white);
    border-radius: 50%;
    font-size: 12px;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
}

/* Blockquote */
.custom-page-content blockquote {
    margin: 32px 0;
    padding: 24px 32px;
    background: linear-gradient(135deg, var(--cp-primary-light) 0%, var(--cp-white) 100%);
    border-left: 4px solid var(--cp-primary);
    border-radius: 0 var(--cp-radius-sm) var(--cp-radius-sm) 0;
    font-style: italic;
    color: var(--cp-text);
}

.custom-page-content blockquote p {
    margin: 0;
}

/* Images */
.custom-page-content img {
    max-width: 100%;
    height: auto;
    border-radius: var(--cp-radius-sm);
    box-shadow: var(--cp-shadow-md);
    margin: 24px 0;
}

/* Tables */
.custom-page-content table {
    width: 100%;
    margin: 24px 0;
    border-collapse: collapse;
    border-radius: var(--cp-radius-sm);
    overflow: hidden;
    box-shadow: var(--cp-shadow);
}

.custom-page-content table thead {
    background: var(--cp-primary);
    color: var(--cp-white);
}

.custom-page-content table th {
    padding: 14px 18px;
    text-align: left;
    font-weight: 600;
    font-size: 14px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.custom-page-content table td {
    padding: 14px 18px;
    border-bottom: 1px solid var(--cp-border);
}

.custom-page-content table tbody tr:nth-child(even) {
    background: var(--cp-bg);
}

.custom-page-content table tbody tr:hover {
    background: var(--cp-primary-light);
}

/* Code blocks */
.custom-page-content code {
    background: var(--cp-bg);
    padding: 3px 8px;
    border-radius: 4px;
    font-size: 14px;
    color: var(--cp-primary);
    font-family: 'Monaco', 'Consolas', monospace;
}

.custom-page-content pre {
    background: var(--cp-text);
    color: var(--cp-white);
    padding: 24px;
    border-radius: var(--cp-radius-sm);
    overflow-x: auto;
    margin: 24px 0;
}

.custom-page-content pre code {
    background: transparent;
    color: inherit;
    padding: 0;
}

/* Horizontal Rule */
.custom-page-content hr {
    border: none;
    height: 2px;
    background: linear-gradient(90deg, transparent, var(--cp-border), transparent);
    margin: 40px 0;
}

/* Responsive Styles */
@media (max-width: 992px) {
    .custom-page-header {
        padding: 40px 30px 28px;
    }

    .custom-page-title {
        font-size: 30px;
    }

    .custom-page-content {
        padding: 36px 40px 48px;
    }

    .custom-page-content .td_blog_details {
        font-size: 16px;
    }
}

@media (max-width: 768px) {
    .custom-page-header {
        padding: 32px 24px 24px;
    }

    .custom-page-title {
        font-size: 26px;
    }

    .decoration-line {
        width: 40px;
    }

    .custom-page-content {
        padding: 28px 24px 36px;
    }

    .custom-page-content h2 {
        font-size: 24px;
    }

    .custom-page-content h3 {
        font-size: 20px;
    }

    .custom-page-content blockquote {
        padding: 20px 24px;
        margin: 24px 0;
    }
}

@media (max-width: 480px) {
    .custom-page-wrapper {
        border-radius: var(--cp-radius-sm);
    }

    .custom-page-header {
        padding: 24px 20px 20px;
    }

    .custom-page-title {
        font-size: 22px;
    }

    .decoration-line {
        width: 30px;
    }

    .decoration-dot {
        width: 8px;
        height: 8px;
    }

    .custom-page-content {
        padding: 24px 20px 32px;
    }

    .custom-page-content .td_blog_details {
        font-size: 15px;
        line-height: 1.75;
    }

    .custom-page-content ul li,
    .custom-page-content ol li {
        padding-left: 28px;
    }

    .custom-page-content table th,
    .custom-page-content table td {
        padding: 10px 12px;
        font-size: 14px;
    }
}

/* Animation on Load */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.custom-page-wrapper {
    animation: fadeInUp 0.5s ease-out;
}

/* Print Styles */
@media print {
    .custom-page-section {
        background: white;
    }

    .custom-page-wrapper {
        box-shadow: none;
        border: 1px solid #ddd;
    }

    .custom-page-header {
        background: white;
    }
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layout_inner_page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/slipinho/public_html/resources/views/custom_page.blade.php ENDPATH**/ ?>