<?php
    $theme1_destination = getContent('theme1_destination.content', true);
    $destination_items = popularDestinations();
?>

<!-- tg-location-area-start -->
<div class="tg-location-area p-relative pb-40 tg-grey-bg pt-140">
    <img class="tg-location-shape d-none d-lg-block" src="<?php echo e(asset('frontend/assets/img/shape/tower.png')); ?>"
        alt="shape">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="tg-location-section-title text-center mb-30">
                    <h5 class="tg-section-subtitle mb-15 wow fadeInUp" data-wow-delay=".4s" data-wow-duration=".9s">
                        <?php echo e(getTranslatedValue($theme1_destination, 'sub_title')); ?>

                    </h5>
                    <h2 class="mb-15 text-capitalize wow fadeInUp" data-wow-delay=".5s" data-wow-duration=".9s">
                        <?php echo strip_tags(clean(getTranslatedValue($theme1_destination, 'title')), '<br>'); ?>

                    </h2>
                    <p class="text-capitalize wow fadeInUp" data-wow-delay=".6s" data-wow-duration=".9s">
                        <?php echo strip_tags(clean(getTranslatedValue($theme1_destination, 'description')), '<br>'); ?>

                    </p>
                </div>
            </div>
            <?php if($destination_items->count() > 0): ?>
                <?php $__currentLoopData = $destination_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $destination_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-3 col-md-6 col-sm-6 wow fadeInUp" data-wow-delay=".3s" data-wow-duration=".9s">
                        <div class="bg-white tg-round-25 p-relative z-index-1">
                            <div class="tg-location-wrap p-relative mb-30">
                                <div class="tg-location-thumb">
                                    <img class="w-100"
                                        src="<?php echo e(asset($destination_item->image)); ?>"
                                        alt="<?php echo e($destination_item->country); ?>">
                                </div>
                                <div class="tg-location-content text-center">
                                    <span class="tg-location-time">
                                        <?php echo e($destination_item->services_count); ?>

                                        <?php echo e($destination_item->services_count > 1 ? __('translate.Tours') : __('translate.Tour')); ?></span>
                                    <h3 class="tg-location-title mb-0">
                                        <a
                                            href="<?php echo e(route('front.tourbooking.services', ['destination_id' => $destination_item->id, 'destination' => $destination_item->name])); ?>">
                                            <?php echo e($destination_item->country); ?>

                                        </a>
                                    </h3>
                                </div>
                                <div class="tg-location-border one"></div>
                                <div class="tg-location-border two"></div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </div>
    </div>
</div>
<!-- tg-location-area-end -->

<?php $__env->startPush('style_section'); ?>
    <style>
        .tg-location-thumb img {
            min-height: 245px;
            max-height: 245px;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\themedox\tourex\Cms/themes/theme1/views/components/destination.blade.php ENDPATH**/ ?>