<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('translate.Booking Details')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-header'); ?>
    <h3 class="crancy-header__title m-0"><?php echo e(__('translate.Booking Details')); ?></h3>
    <p class="crancy-header__text"><?php echo e(__('translate.Dashboard')); ?> >> <?php echo e(__('translate.Booking Details')); ?></p>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-content'); ?>
    <!-- crancy Dashboard -->
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <!-- Dashboard Inner -->
                        <div class="crancy-dsinner">

                            <div class="row justify-content-center">
                                <div class="col-10 mg-top-30">
                                    <div class="ed-invoice-page-wrapper">
                                        <div class="ed-invoice-main-wrapper">

                                            <div class="ed-invoice-page">
                                                <div class="ed-inv-logo-area">
                                                    <div class="ed-main-logo">
                                                        <img src="<?php echo e(asset($general_setting->logo)); ?>" alt="logo"
                                                            class="ed-logo">
                                                    </div>
                                                    <div>
                                                        <a href="<?php echo e(route('admin.tourbooking.bookings.index')); ?>"
                                                            class="crancy-btn"><i class="fa fa-arrow-left"></i>
                                                            <?php echo e(__('translate.Back')); ?></a>
                                                        <?php if($booking->booking_status == 'pending' || $booking->booking_status == 'success'): ?>
                                                            <a href="#" class="crancy-btn crancy-btn__success"
                                                                data-bs-toggle="modal" data-bs-target="#confirmModal">
                                                                <i class="fa fa-check"></i>
                                                                <?php echo e(__('translate.Confirm Booking')); ?>

                                                            </a>
                                                            <a href="#" class="crancy-btn crancy-btn__danger"
                                                                data-bs-toggle="modal" data-bs-target="#cancelModal">
                                                                <i class="fa fa-times"></i>
                                                                <?php echo e(__('translate.Cancel Booking')); ?>

                                                            </a>
                                                        <?php endif; ?>
                                                        <a href="<?php echo e(route('admin.tourbooking.bookings.invoice', $booking->id)); ?>"
                                                            class="crancy-btn" target="_blank">
                                                            <i class="fa fa-file-invoice"></i>
                                                            <?php echo e(__('translate.View Invoice')); ?>

                                                        </a>
                                                    </div>
                                                </div>

                                                <div class="ed-inv-billing-info">
                                                    <div class="ed-inv-info">
                                                        <p class="ed-inv-info-title"><?php echo e(__('translate.Billed To')); ?>

                                                        </p>
                                                        <table>
                                                            <tr>
                                                                <td><?php echo e(__('translate.Name')); ?>:</td>
                                                                <td> <?php echo e($booking->customer_name ?? 'NA'); ?></td>
                                                            </tr>
                                                            <tr>
                                                                <td><?php echo e(__('translate.Phone')); ?>:</td>
                                                                <td><?php echo e($booking?->customer_email); ?></td>
                                                            </tr>
                                                            <tr>
                                                                <td><?php echo e(__('translate.Email')); ?>:</td>
                                                                <td><?php echo e($booking?->customer_phone); ?></td>
                                                            </tr>
                                                            <tr>
                                                                <td><?php echo e(__('translate.Address')); ?> : </td>
                                                                <td> <?php echo e($booking?->customer_address); ?></td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>

                                                <div class="ed-inv-billing-info">
                                                    <div class="ed-inv-info">
                                                        <p class="ed-inv-info-title">
                                                            <?php echo e(__('translate.Booking Information')); ?>

                                                        </p>
                                                        <table>
                                                            <tr>
                                                                <td><?php echo e(__('translate.Invoice No')); ?>:</td>
                                                                <td>#<?php echo e($booking->booking_code); ?></td>
                                                            </tr>
                                                            <tr>
                                                                <td><?php echo e(__('translate.Booking Status')); ?>:</td>
                                                                <td>
                                                                    <span
                                                                        class="badge bg-<?php echo e($booking->booking_status == 'confirmed' ? 'success' : ($booking->booking_status == 'pending' ? 'warning' : ($booking->booking_status == 'cancelled' ? 'danger' : 'info'))); ?>">
                                                                        <?php echo e(ucfirst($booking->booking_status)); ?>

                                                                    </span>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td><?php echo e(__('translate.Payment Status')); ?> : </td>
                                                                <td>
                                                                    <span
                                                                        class="badge bg-<?php echo e($booking->payment_status == 'completed' ? 'success' : 'warning'); ?>">
                                                                        <?php echo e(ucfirst($booking->payment_status)); ?>

                                                                    </span>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td><?php echo e(__('translate.Payment Method')); ?> : </td>
                                                                <td>
                                                                    <?php echo e(ucfirst($booking->payment_method)); ?>

                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td><?php echo e(__('translate.Total Amount')); ?> : </td>
                                                                <td>
                                                                    <?php echo e(currency($booking->total)); ?>

                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td><?php echo e(__('translate.Paid Amount')); ?> : </td>
                                                                <td>
                                                                    <?php echo e(currency($booking->paid_amount)); ?>

                                                                </td>
                                                            </tr>
                                                            <?php if($booking->due_amount > 0): ?>
                                                                <tr>
                                                                    <td><?php echo e(__('translate.Due Amount')); ?> : </td>
                                                                    <td>
                                                                        <?php echo e(currency($booking->due_amount)); ?>

                                                                    </td>
                                                                </tr>
                                                            <?php endif; ?>
                                                        </table>

                                                    </div>
                                                    <div class="ed-inv-info">
                                                        <p class="ed-inv-info-title">
                                                            <?php echo e(__('translate.Service Information')); ?>

                                                        </p>
                                                        <table>
                                                            <tr>
                                                                <td><?php echo e(__('translate.Title')); ?>:</td>
                                                                <td> <?php echo e($booking->service->title ?? 'NA'); ?></td>
                                                            </tr>
                                                            <tr>
                                                                <td><?php echo e(__('translate.Location')); ?> : </td>
                                                                <td><?php echo e($booking?->service?->location); ?></td>
                                                            </tr>
                                                            <tr>
                                                                <td><?php echo e(__('translate.Check in Date')); ?>:</td>
                                                                <td><?php echo e(date('d M Y', strtotime($booking->check_in_date))); ?>

                                                                </td>
                                                            </tr>
                                                            <?php if($booking->check_out_date): ?>
                                                                <tr>
                                                                    <td><?php echo e(__('translate.Check out Date')); ?>:</td>
                                                                    <td><?php echo e(date('d M Y', strtotime($booking->check_out_date))); ?>

                                                                    </td>
                                                                </tr>
                                                            <?php endif; ?>

                                                            <?php if($booking->check_in_time): ?>
                                                                <tr>
                                                                    <td><?php echo e(__('translate.Check in Time')); ?>:</td>
                                                                    <td><?php echo e(\Carbon\Carbon::parse($booking->check_in_time)->format('h:i A')); ?>

                                                                    </td>
                                                                </tr>
                                                            <?php endif; ?>

                                                            <?php if($booking->check_out_time): ?>
                                                                <tr>
                                                                    <td><?php echo e(__('translate.Check out Time')); ?>:</td>
                                                                    <td><?php echo e(\Carbon\Carbon::parse($booking->check_out_time)->format('h:i A')); ?>

                                                                    </td>
                                                                </tr>
                                                            <?php endif; ?>

                                                            <tr>
                                                                <td><?php echo e(__('translate.Adults')); ?> : </td>
                                                                <td> <?php echo e($booking?->adults); ?></td>
                                                            </tr>

                                                            <tr>
                                                                <td><?php echo e(__('translate.Children')); ?> : </td>
                                                                <td> <?php echo e($booking?->children); ?></td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>

                                                <div class="row mt-4">
                                                    <div class="col-md-12">
                                                        <div class="card">
                                                            <div class="card-header">
                                                                <h5 class="mb-0">
                                                                    <?php echo e(__('translate.Price Details')); ?></h5>
                                                            </div>
                                                            <div class="card-body">
                                                                <table class="table">
                                                                    <thead>
                                                                        <tr>
                                                                            <th><?php echo e(__('translate.Description')); ?></th>
                                                                            <th class="text-right">
                                                                                <?php echo e(__('translate.Amount')); ?></th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>

                                                                        <?php if($booking->is_per_person == 1): ?>
                                                                            <tr>
                                                                                <td><?php echo e(__('translate.Adult Price')); ?>

                                                                                    (<?php echo e($booking->adult_price); ?> X
                                                                                    <?php echo e($booking->adults); ?>

                                                                                    <?php echo e(__('translate.Adults')); ?>)</td>
                                                                                <td class="text-right">
                                                                                    <?php echo e(currency($booking->adult_price * $booking->adults)); ?>

                                                                                </td>
                                                                            </tr>

                                                                            <tr>
                                                                                <td><?php echo e(__('translate.Child Price')); ?>

                                                                                    (<?php echo e($booking->child_price); ?> X
                                                                                    <?php echo e($booking->children); ?>

                                                                                    <?php echo e(__('translate.Child')); ?>)</td>
                                                                                <td class="text-right">
                                                                                    <?php echo e(currency($booking->child_price * $booking->children)); ?>

                                                                                </td>
                                                                            </tr>

                                                                            <tr>
                                                                                <td><?php echo e(__('translate.Extra charges')); ?>

                                                                                </td>
                                                                                <td class="text-right">
                                                                                    <?php echo e(currency($booking->extra_charges)); ?>

                                                                                </td>
                                                                            </tr>
                                                                        <?php else: ?>
                                                                            <tr>
                                                                                <td><?php echo e(__('translate.Service Price')); ?>

                                                                                </td>
                                                                                <td class="text-right">
                                                                                    <?php echo e(currency($booking->service_price)); ?>

                                                                                </td>
                                                                            </tr>
                                                                        <?php endif; ?>

                                                                        <?php if($booking->infants > 0 && $booking->service->infant_price > 0): ?>
                                                                            <tr>
                                                                                <td><?php echo e(__('translate.Infant Price')); ?> x
                                                                                    <?php echo e($booking->infants); ?>

                                                                                    <?php echo e(__('translate.Infants')); ?></td>
                                                                                <td class="text-right">
                                                                                    <?php echo e(currency($booking->service->infant_price * $booking->infants)); ?>

                                                                                </td>
                                                                            </tr>
                                                                        <?php endif; ?>

                                                                        <?php if($booking->tax > 0): ?>
                                                                            <tr>
                                                                                <td><?php echo e(__('translate.Tax')); ?>

                                                                                    (<?php echo e($booking->tax_percentage); ?>%)</td>
                                                                                <td class="text-right">
                                                                                    <?php echo e(currency($booking->tax)); ?>

                                                                                </td>
                                                                            </tr>
                                                                        <?php endif; ?>
                                                                    </tbody>
                                                                    <tfoot>
                                                                        <tr>
                                                                            <th><?php echo e(__('translate.Total')); ?></th>
                                                                            <th class="text-right">
                                                                                <?php echo e(currency($booking->total)); ?>

                                                                            </th>
                                                                        </tr>
                                                                    </tfoot>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <?php if($extra_services->count() > 0): ?>
                                                    <div class="ed-inv-billing-info mt-5">
                                                        <div class="ed-inv-info">
                                                            <p class="ed-inv-info-title">
                                                                <?php echo e(__('translate.Extra Services List')); ?>

                                                            </p>
                                                            <table>
                                                                <?php $__currentLoopData = $extra_services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $extra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <tr>
                                                                        <td class="text-capitalize mr-2">
                                                                            <?php echo e($extra->name); ?>

                                                                            (<?php echo e(Str::title(str_replace('_', ' ', $extra->price_type))); ?>)
                                                                            -- <?php echo e(currency($extra->price)); ?>

                                                                        </td>
                                                                    </tr>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </table>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End Dashboard Inner -->
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End crancy Dashboard -->

    <!-- Confirm Booking Modal -->
    <div class="modal fade" id="confirmModal" tabindex="-1" aria-labelledby="confirmModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="confirmModalLabel"><?php echo e(__('translate.Confirm Booking')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="<?php echo e(route('admin.tourbooking.bookings.confirm', ['id' => $booking->id])); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <p><?php echo e(__('translate.Are you sure you want to confirm this booking?')); ?></p>
                        <div class="form-group">
                            <label><?php echo e(__('translate.Confirmation Message')); ?> (<?php echo e(__('translate.Optional')); ?>)</label>
                            <textarea class="form-control" name="confirmation_message" rows="3"
                                placeholder="<?php echo e(__('translate.Enter message to send to customer')); ?>"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="crancy-btn crancy-btn__default"
                            data-bs-dismiss="modal"><?php echo e(__('translate.Cancel')); ?></button>
                        <button type="submit"
                            class="crancy-btn crancy-btn__success"><?php echo e(__('translate.Confirm Booking')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Cancel Booking Modal -->
    <div class="modal fade" id="cancelModal" tabindex="-1" aria-labelledby="cancelModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="cancelModalLabel"><?php echo e(__('translate.Cancel Booking')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="<?php echo e(route('admin.tourbooking.bookings.cancel', ['id' => $booking->id])); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <p><?php echo e(__('translate.Are you sure you want to cancel this booking?')); ?></p>
                        <div class="form-group">
                            <label><?php echo e(__('translate.Cancellation Reason')); ?> *</label>
                            <textarea class="form-control" name="cancellation_reason" rows="3" required
                                placeholder="<?php echo e(__('translate.Enter reason for cancellation')); ?>"></textarea>
                        </div>
                        <div class="form-group mt-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="refund" id="refundCheck">
                                <label class="form-check-label" for="refundCheck">
                                    <?php echo e(__('translate.Process Refund')); ?>

                                </label>
                            </div>
                        </div>
                        <div class="form-group mt-3 refund-amount-container d-none">
                            <label><?php echo e(__('translate.Refund Amount')); ?></label>
                            <input type="number" class="form-control" name="refund_amount" step="0.01"
                                min="0" max="<?php echo e($booking->paid_amount); ?>" value="<?php echo e($booking->paid_amount); ?>">
                            <small class="text-muted"><?php echo e(__('translate.Maximum refund amount is')); ?>

                                <?php echo e(currency($booking->paid_amount)); ?></small>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="crancy-btn crancy-btn__default"
                            data-bs-dismiss="modal"><?php echo e(__('translate.Close')); ?></button>
                        <button type="submit"
                            class="crancy-btn crancy-btn__danger"><?php echo e(__('translate.Cancel Booking')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Add Note Modal -->
    <div class="modal fade" id="addNoteModal" tabindex="-1" aria-labelledby="addNoteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addNoteModalLabel"><?php echo e(__('translate.Add Admin Note')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="<?php echo e(route('admin.tourbooking.bookings.add-note', $booking->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <label><?php echo e(__('translate.Note')); ?> *</label>
                            <textarea class="form-control" name="note" rows="3" required
                                placeholder="<?php echo e(__('translate.Enter your note')); ?>"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="crancy-btn crancy-btn__default"
                            data-bs-dismiss="modal"><?php echo e(__('translate.Cancel')); ?></button>
                        <button type="submit" class="crancy-btn"><?php echo e(__('translate.Add Note')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('js_section'); ?>
    <script>
        (function($) {
            "use strict"
            $(document).ready(function() {
                // Show/hide refund amount based on checkbox
                $('#refundCheck').on('change', function() {
                    if ($(this).is(':checked')) {
                        $('.refund-amount-container').removeClass('d-none');
                    } else {
                        $('.refund-amount-container').addClass('d-none');
                    }
                });
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\themedox\tourex\Modules/TourBooking\resources/views/admin/bookings/details.blade.php ENDPATH**/ ?>