

<?php $__env->startSection('title'); ?>
<title><?php echo e($seo_setting->seo_title); ?></title>
<meta name="title" content="<?php echo e($seo_setting->seo_title); ?>">
<meta name="description" content="<?php echo strip_tags(clean($seo_setting->seo_description)); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('front-content'); ?>
<?php echo $__env->make('breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Contact Area -->
<div class="contact-section pt-100 pb-100">
    <div class="container">
        <div class="row g-4">
            <!-- Left: Info Card -->
            <div class="col-lg-4">
                <div class="contact-info-card h-100">
                    <h3 class="contact-card-title " style="margin-bottom:20px;"><?php echo e(__('Information')); ?></h3>
     

                    <div class="contact-details-list">
                        <!-- Phone -->
                        <div class="contact-item">
                            <div class="icon-box">
                                <i class="fa-solid fa-phone"></i>
                            </div>
                            <div class="content">
                                <span class="label"><?php echo e(__('translate.Phone')); ?></span>
                                <a href="tel:<?php echo e($contact_us->phone); ?>" class="value"><?php echo e($contact_us->phone); ?></a>
                            </div>
                        </div>

                        <!-- Website -->
                        <div class="contact-item">
                            <div class="icon-box">
                                <i class="fa-solid fa-globe"></i>
                            </div>
                            <div class="content">
                                <span class="label"><?php echo e(__('translate.Website')); ?></span>
                                <a target="__blank" href="<?php echo e(getLink($contact_us->website)); ?>" class="value">
                                    <?php echo e($contact_us->website); ?>

                                </a>
                            </div>
                        </div>

                        <!-- Email -->
                        <div class="contact-item">
                            <div class="icon-box">
                                <i class="fa-solid fa-envelope"></i>
                            </div>
                            <div class="content">
                                <span class="label"><?php echo e(__('translate.E-mail')); ?></span>
                                <a href="mailto:<?php echo e($contact_us->email); ?>" class="value"><?php echo e($contact_us->email); ?></a>
                            </div>
                        </div>

                        <!-- Address -->
                        <div class="contact-item">
                            <div class="icon-box">
                                <i class="fa-solid fa-location-dot"></i>
                            </div>
                            <div class="content">
                                <span class="label"><?php echo e(__('translate.Address')); ?></span>
                                <span class="value"><?php echo e($contact_us->address); ?></span>
                            </div>
                        </div>
                    </div>

                    <!-- Map -->
                    <div class="map-wrapper mt-40">
                        <iframe id="map" src="<?php echo e(html_decode($contact_us->map_code)); ?>" allowfullscreen=""></iframe>
                    </div>
                </div>
            </div>

            <!-- Right: Form Card -->
            <div class="col-lg-8">
                <div class="contact-form-card h-100">
                    <div class="form-header mb-30">
                        <h3 class="contact-title">
                            <?php echo e(__("translate.Let's connect and get to know")); ?> <br>
                            <span class="text-primary"><?php echo e(__('translate.each other')); ?></span>
                        </h3>
                        <p class="text-muted">
                            <?php echo e(__('Brendan Fraser, renowned actor of the silver screen, has taken on a new')); ?>

                        </p>
                    </div>

                    <form id="contact-form" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="instructor_id" value="0">
                        <div class="row g-3">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('translate.Full Name')); ?></label>
                                    <input class="modern-input" type="text" name="name" placeholder="Ex: John Doe"
                                        value="<?php echo e(html_decode(old('name'))); ?>">
                                    <span class="text-danger error-name"></span>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('translate.Email')); ?></label>
                                    <input class="modern-input" type="email" name="email"
                                        placeholder="example@gmail.com" value="<?php echo e(html_decode(old('email'))); ?>">
                                    <span class="text-danger error-email"></span>
                                </div>
                            </div>
             <div class="col-lg-6">
    <div class="form-group">
        <label class="form-label"><?php echo e(__('translate.Phone Number')); ?></label>
        <input 
            class="modern-input" 
            type="tel" 
            name="phone"
            placeholder="+91 98765 43210"
        >
        <span class="text-danger error-phone"></span>
    </div>
</div>

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('translate.Subject')); ?></label>
                                    <input class="modern-input" type="text" name="subject"
                                        placeholder="How can we help?" value="<?php echo e(html_decode(old('subject'))); ?>">
                                    <span class="text-danger error-subject"></span>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('translate.Message')); ?></label>
                                    <textarea class="modern-textarea" rows="5" placeholder="Write your message here..."
                                        name="message"><?php echo e(html_decode(old('message'))); ?></textarea>
                                    <span class="text-danger error-message"></span>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="checkbox-wrapper mb-30">
                                    <input name="checkbox" class="custom-check" type="checkbox" id="save_info">
                                    <label for="save_info" class="custom-label">
                                        <?php echo e(__('Save my name, email, and website in this browser for the next
                                        time I comment.')); ?>

                                    </label>
                                </div>

                                <?php if($general_setting->recaptcha_status == 1): ?>
                                <div class="recaptcha-wrapper mb-30">
                                    <div class="g-recaptcha" data-sitekey="<?php echo e($general_setting->recaptcha_site_key); ?>">
                                    </div>
                                </div>
                                <?php endif; ?>

                                <button type="submit" class="submit-btn tg-btn">
                                    <span class="loader-text d-none"><?php echo e(__('translate.Please wait')); ?></span>
                                    <span class="button-text"><?php echo e(__('translate.Send Message')); ?></span>
                                    <i class="fa-solid fa-paper-plane ml-5"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style_section'); ?>
<style>
    /* =========================================
       MODERN CONTACT SECTION STYLES
       ========================================= */
    .contact-section {
        background-color: #f8fafc;
    }

    /* Cards Common */
    .contact-info-card,
    .contact-form-card {
        background: #fff;
        border-radius: 20px;
        padding: 40px;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.03);
        border: 1px solid #f1f5f9;
    }

    .contact-info-card {
        background: #fff;
        /* Keep white or enable secondary color */
        display: flex;
        flex-direction: column;
    }

    .contact-card-title {
        font-size: 20px;
        font-weight: 700;
        margin-bottom: 10px;
        color: #1e293b;
    }

    /* Info Items */
    .contact-item {
        display: flex;
        align-items: flex-start;
        gap: 15px;
        margin-bottom: 25px;
    }

    .icon-box {
        width: 45px;
        height: 45px;
        background: rgba(59, 130, 246, 0.1);
        /* Primary light */
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: var(--tg-theme-primary, #3b82f6);
        font-size: 18px;
        flex-shrink: 0;
    }

    .content .label {
        display: block;
        font-size: 12px;
        text-transform: uppercase;
        color: #94a3b8;
        font-weight: 600;
        margin-bottom: 2px;
    }

    .content .value {
        font-size: 15px;
        font-weight: 600;
        color: #334155;
        text-decoration: none;
        transition: color 0.3s;
    }

    .content .value:hover {
        color: var(--tg-theme-primary, #3b82f6);
    }

    /* Map */
    .map-wrapper {
        border-radius: 16px;
        overflow: hidden;
        flex: 1;
        min-height: 200px;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.05);
    }

    .map-wrapper iframe {
        width: 100%;
        height: 100%;
        border: none;
    }

    /* Form Card */
    .contact-title {
        font-size: 32px;
        font-weight: 800;
        line-height: 1.2;
        color: #0f172a;
    }

    .form-group {
        margin-bottom: 5px;
    }

    .form-label {
        display: block;
        font-size: 14px;
        font-weight: 600;
        color: #475569;
        margin-bottom: 8px;
    }

    .modern-input,
    .modern-textarea {
        width: 100%;
        background: #f8fafc;
        border: 1px solid #e2e8f0;
        border-radius: 10px;
        padding: 12px 18px;
        font-size: 15px;
        height:100px !important;
        color: #1e293b;
        transition: all 0.3s;
    }

    .modern-input:focus,
    .modern-textarea:focus {
        background: #fff;
        border-color: var(--tg-theme-primary, #3b82f6);
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
        outline: none;
    }

    .modern-input {
        height: 50px;
    }

    /* Checkbox */
    .checkbox-wrapper {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .custom-check {
        width: 18px;
        height: 18px;
        cursor: pointer;
        opacity: 0.7;
    }

    .custom-label {
        font-size: 14px;
        color: #64748b;
        cursor: pointer;
        user-select: none;
    }

    /* Submit Button */
    .submit-btn {
        background: var(--tg-theme-primary, #3b82f6);
        color: #fff;
        border: none;
        padding: 15px 35px;
        border-radius: 50px;
        font-size: 16px;
        font-weight: 700;
        cursor: pointer;
        transition: all 0.3s;
        box-shadow: 0 4px 15px rgba(59, 130, 246, 0.3);
        display: inline-flex;
        align-items: center;
    }

    .submit-btn:hover {
        background: #1d4ed8;
        transform: translateY(-2px);
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js_section'); ?>
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>

<script>
    $(document).ready(function () {
        $('#contact-form').on('submit', function (e) {
            e.preventDefault();

            let form = $(this)[0];
            let formData = new FormData(form);

            // Clear previous errors
            $('.text-danger').text('');
            $('.tg-btn').attr('disabled', 'disabled');
            $('.tg-btn .button-text').addClass('d-none');
            $('.tg-btn .loader-text').removeClass('d-none');

            axios.post("<?php echo e(route('store-contact-message')); ?>", formData)
                .then(function (response) {
                    if (response.data.alert_type == 'success') {
                        toastr.success(response.data.message);
                        form.reset(); // Reset form
                    }
                })
                .catch(function (error) {
                    if (error.response && error.response.data && error.response.data.errors) {
                        let errors = error.response.data.errors;
                        $.each(errors, function (field, messages) {
                            $('.error-' + field).text(messages[0]);
                        });
                    } else {
                        $('.ajax-response').html(
                            '<span style="color:red;">An error occurred. Please try again.</span>'
                        );
                    }
                }).finally(function () {
                    $('.tg-btn').removeAttr('disabled');
                    $('.tg-btn .button-text').removeClass('d-none');
                    $('.tg-btn .loader-text').addClass('d-none');
                });
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layout_inner_page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/slipinho/public_html/resources/views/contact_us.blade.php ENDPATH**/ ?>