<?php if($products->hasPages()): ?>
    <div class="tg-pagenation-wrap text-center pt-35 mb-30">
        <nav class="navigation pagination center" aria-label="Posts">
            <ul class="nav-links">
                <li>
                    <?php if($products->onFirstPage()): ?>
                        <span class="p-btn next page-numbers disabled">
                            Previous Page
                        </span>
                    <?php else: ?>
                        <a class="p-btn next page-numbers" href="<?php echo e($products->previousPageUrl()); ?>">
                            Previous Page
                        </a>
                    <?php endif; ?>
                </li>

                <?php
                    $start = max($products->currentPage() - 2, 1);
                    $end = min($start + 4, $products->lastPage());
                    $start = max(min($start, $products->lastPage() - 4), 1);
                ?>

                <?php if($start > 1): ?>
                    <li>
                        <a class="page-numbers" href="<?php echo e($products->url(1)); ?>">1</a>
                        <?php if($start > 2): ?>
                            <span class="page-numbers dots">...</span>
                        <?php endif; ?>
                    </li>
                <?php endif; ?>

                <?php for($i = $start; $i <= $end; $i++): ?>
                    <li>
                        <?php if($i == $products->currentPage()): ?>
                            <span aria-current="page" class="page-numbers active"><?php echo e($i); ?></span>
                        <?php else: ?>
                            <a class="page-numbers" href="<?php echo e($products->url($i)); ?>"><?php echo e($i); ?></a>
                        <?php endif; ?>
                    </li>
                <?php endfor; ?>

                <?php if($end < $products->lastPage()): ?>
                    <li>
                        <?php if($end < $products->lastPage() - 1): ?>
                            <span class="page-numbers dots">...</span>
                        <?php endif; ?>
                        <a class="page-numbers"
                            href="<?php echo e($products->url($products->lastPage())); ?>"><?php echo e($products->lastPage()); ?></a>
                    </li>
                <?php endif; ?>

                <li>
                    <?php if($products->hasMorePages()): ?>
                        <a class="p-btn next page-numbers" href="<?php echo e($products->nextPageUrl()); ?>">
                            Next Page
                        </a>
                    <?php else: ?>
                        <span class="p-btn next page-numbers disabled">
                            Next Page
                        </span>
                    <?php endif; ?>
                </li>
            </ul>
        </nav>
    </div>
<?php endif; ?>
<?php /**PATH /home/slipinho/public_html/Modules/Ecommerce/Resources/views/frontend/partials/product_pagination.blade.php ENDPATH**/ ?>