<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('translate.Edit Blog')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-header'); ?>
    <h3 class="crancy-header__title m-0"><?php echo e(__('translate.Edit Blog')); ?></h3>
    <p class="crancy-header__text"><?php echo e(__('translate.Manage Blog')); ?> >> <?php echo e(__('translate.Edit Blog')); ?></p>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-content'); ?>

    <!-- crancy Dashboard -->
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <!-- Dashboard Inner -->
                        <div class="crancy-dsinner">
                            <div class="row">
                                <div class="col-12 mg-top-30">
                                    <!-- Product Card -->
                                    <div class="crancy-product-card translation_main_box">

                                        <div class="crancy-customer-filter">
                                            <div
                                                class="crancy-customer-filter__single crancy-customer-filter__single--csearch">
                                                <div class="crancy-header__form crancy-header__form--customer">
                                                    <h4 class="crancy-product-card__title">
                                                        <?php echo e(__('translate.Switch to language translation')); ?></h4>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="translation_box">
                                            <ul>
                                                <?php $__currentLoopData = $language_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><a
                                                            href="<?php echo e(route('admin.blog.edit', ['blog' => $blog->id, 'lang_code' => $language->lang_code])); ?>">
                                                            <?php if(request()->get('lang_code') == $language->lang_code): ?>
                                                                <i class="fas fa-eye"></i>
                                                            <?php else: ?>
                                                                <i class="fas fa-edit"></i>
                                                            <?php endif; ?>

                                                            <?php echo e($language->lang_name); ?>

                                                        </a></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>

                                            <div class="alert alert-secondary" role="alert">

                                                <?php
                                                    $edited_language = $language_list
                                                        ->where('lang_code', request()->get('lang_code'))
                                                        ->first();
                                                ?>

                                                <p><?php echo e(__('translate.Your editing mode')); ?> :
                                                    <b><?php echo e($edited_language->lang_name); ?></b></p>
                                            </div>
                                        </div>

                                    </div>
                                    <!-- End Product Card -->
                                </div>
                            </div>
                        </div>
                        <!-- End Dashboard Inner -->
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End crancy Dashboard -->

    <!-- crancy Dashboard -->
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <!-- Dashboard Inner -->
                        <div class="crancy-dsinner">
                            <form action="<?php echo e(route('admin.blog.update', $blog->id)); ?>" method="POST"
                                enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>

                                <input type="hidden" name="translate_id" value="<?php echo e($blog_translate->id); ?>">
                                <input type="hidden" name="lang_code" value="<?php echo e($blog_translate->lang_code); ?>">

                                <div class="row">
                                    <div class="col-12">
                                        <!-- Product Card -->
                                        <div class="crancy-product-card">
                                            <div class="create_new_btn_inline_box">
                                                <h4 class="crancy-product-card__title"><?php echo e(__('translate.Edit Blog')); ?></h4>

                                                <a href="<?php echo e(route('admin.blog.index')); ?>" class="crancy-btn "><i
                                                        class="fa fa-list"></i> <?php echo e(__('translate.Blog List')); ?></a>
                                            </div>


                                            <div class="row">

                                                <?php if(admin_lang() == request()->get('lang_code')): ?>
                                                    <div class="col-12">
                                                        <div class="row">
                                                            <div class="col-md-3">
                                                                <div class="crancy__item-form--group w-100 h-100">
                                                                    <label
                                                                        class="crancy__item-label"><?php echo e(__('translate.Image')); ?>

                                                                    </label>
                                                                    <div
                                                                        class="crancy-product-card__upload crancy-product-card__upload--border">
                                                                        <input type="file" class="btn-check"
                                                                            name="image" id="input-img1"
                                                                            autocomplete="off"
                                                                            onchange="previewImage(event)">
                                                                        <label class="crancy-image-video-upload__label"
                                                                            for="input-img1">
                                                                            <img id="view_img"
                                                                                src="<?php echo e(asset($blog->image)); ?>">
                                                                            <h4 class="crancy-image-video-upload__title">
                                                                                <?php echo e(__('translate.Click here to')); ?> <span
                                                                                    class="crancy-primary-color"><?php echo e(__('translate.Choose File')); ?></span>
                                                                                <?php echo e(__('translate.and upload')); ?> </h4>
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>
                                                <?php endif; ?>

                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label"><?php echo e(__('translate.Title')); ?> *
                                                        </label>
                                                        <input class="crancy__item-input" type="text" name="title"
                                                            id="title" value="<?php echo e($blog_translate->title); ?>">
                                                    </div>
                                                </div>

                                                <?php if(admin_lang() == request()->get('lang_code')): ?>
                                                    <div class="col-12">
                                                        <div class="crancy__item-form--group mg-top-form-20">
                                                            <label class="crancy__item-label"><?php echo e(__('translate.Slug')); ?> *
                                                            </label>
                                                            <input class="crancy__item-input" type="text" name="slug"
                                                                id="slug" value="<?php echo e($blog->slug); ?>">
                                                        </div>
                                                    </div>

                                                    <div class="col-12">
                                                        <div class="crancy__item-form--group mg-top-form-20">
                                                            <label
                                                                class="crancy__item-label"><?php echo e(__('translate.Category')); ?> *
                                                            </label>
                                                            <select class="form-select crancy__item-input" name="category">
                                                                <option value="">
                                                                    <?php echo e(__('translate.Select Category')); ?></option>
                                                                <?php $__currentLoopData = $blog_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option
                                                                        <?php echo e($blog_category->id == $blog->blog_category_id ? 'selected' : ''); ?>

                                                                        value="<?php echo e($blog_category->id); ?>">
                                                                        <?php echo e($blog_category->translate->name); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                            </select>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>

                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label"><?php echo e(__('translate.Reading time')); ?></label>
                                                        <input class="crancy__item-input" type="text" name="reading_time"
                                                            id="reading_time" value="<?php echo e($blog_translate->reading_time); ?>">
                                                    </div>
                                                </div>


                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label
                                                            class="crancy__item-label"><?php echo e(__('translate.Short Description')); ?>

                                                            *</label>

                                                        <textarea class="crancy__item-input crancy__item-textarea seo_description_box" name="short_description"
                                                            id="short_description"><?php echo e($blog_translate->short_description); ?></textarea>
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label
                                                            class="crancy__item-label"><?php echo e(__('translate.Description')); ?> *
                                                        </label>

                                                        <textarea class="crancy__item-input crancy__item-textarea summernote" name="description" id="description"><?php echo clean($blog_translate->description); ?></textarea>

                                                    </div>
                                                </div>

                                                <?php if(admin_lang() == request()->get('lang_code')): ?>
                                                    <div class="col-12">
                                                        <div class="crancy__item-form--group mg-top-form-20">
                                                            <label
                                                                class="crancy__item-label"><?php echo e(__('translate.Visibility Status')); ?>

                                                            </label>
                                                            <div
                                                                class="crancy-ptabs__notify-switch  crancy-ptabs__notify-switch--two">
                                                                <label class="crancy__item-switch">
                                                                    <input <?php echo e($blog->status == 1 ? 'checked' : ''); ?>

                                                                        name="status" type="checkbox">
                                                                    <span
                                                                        class="crancy__item-switch--slide crancy__item-switch--round"></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-12">
                                                        <div class="crancy__item-form--group mg-top-form-20">
                                                            <label class="crancy__item-label"><?php echo e(__('translate.Tags')); ?>

                                                            </label>
                                                            <input class="crancy__item-input tags" type="text"
                                                                name="tags" value="<?php echo e($blog->tags); ?>">
                                                        </div>
                                                    </div>
                                                <?php endif; ?>

                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label"><?php echo e(__('translate.SEO Title')); ?>

                                                        </label>
                                                        <input class="crancy__item-input" type="text" name="seo_title"
                                                            id="seo_title" value="<?php echo e($blog_translate->seo_title); ?>">
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label
                                                            class="crancy__item-label"><?php echo e(__('translate.SEO Description')); ?>

                                                        </label>

                                                        <textarea class="crancy__item-input crancy__item-textarea seo_description_box" name="seo_description"
                                                            id="seo_description"><?php echo e($blog_translate->seo_description); ?></textarea>
                                                    </div>
                                                </div>

                                            </div>

                                            <button class="crancy-btn mg-top-25"
                                                type="submit"><?php echo e(__('translate.Update')); ?></button>

                                        </div>
                                        <!-- End Product Card -->
                                    </div>
                                </div>
                            </form>
                        </div>
                        <!-- End Dashboard Inner -->
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End crancy Dashboard -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style_section'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('global/tagify/tagify.css')); ?>">

    <style>
        .tox .tox-promotion,
        .tox-statusbar__branding {
            display: none !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js_section'); ?>
    <script src="<?php echo e(asset('global/tinymce/js/tinymce/tinymce.min.js')); ?>"></script>
    <script src="<?php echo e(asset('global/tagify/tagify.js')); ?>"></script>

    <script>
        (function($) {
            "use strict"
            $(document).ready(function() {
                $("#title").on("keyup", function(e) {
                    let inputValue = $(this).val();
                    let slug = inputValue.toLowerCase().replace(/[^\w ]+/g, '').replace(/ +/g, '-');
                    $("#slug").val(slug);
                })

                tinymce.init({
                    selector: '.summernote',
                    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
                    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table mergetags | addcomment showcomments | spellcheckdialog a11ycheck typography | align lineheight | checklist numlist bullist indent outdent | emoticons charmap | removeformat',
                    tinycomments_mode: 'embedded',
                    tinycomments_author: 'Author name',
                    mergetags_list: [{
                            value: 'First.Name',
                            title: 'First Name'
                        },
                        {
                            value: 'Email',
                            title: 'Email'
                        },
                    ]
                });

                $('.tags').tagify();

            });
        })(jQuery);

        function previewImage(event) {
            var reader = new FileReader();
            reader.onload = function() {
                var output = document.getElementById('view_img');
                output.src = reader.result;
            }

            reader.readAsDataURL(event.target.files[0]);
        };
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/slipinho/public_html/Modules/Blog/Resources/views/blog_edit.blade.php ENDPATH**/ ?>