<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('translate.Forget Password')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('front-content'); ?>
    <?php echo $__env->make('breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- forget-password-area-start -->
    <div class="tg-login-area pt-130 pb-130">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-8 col-md-10">
                    <div class="tg-login-wrapper">
                        <div class="tg-login-top text-center mb-30">
                            <h2><?php echo e(__('translate.Forget Password')); ?></h2>
                        </div>
                        <div class="tg-login-form">
                            <div class="tg-tour-about-review-form">
                                <form method="POST" action="<?php echo e(route('user.send-forget-password')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-lg-12 mb-25">
                                            <input class="input" type="email" name="email" required type="email"
                                                placeholder="<?php echo e(__('translate.Email')); ?>">
                                        </div>
                                        <?php if($general_setting->recaptcha_status == 1): ?>
                                            <div class="td_mb_10">
                                                <div class="g-recaptcha"
                                                    data-sitekey="<?php echo e($general_setting->recaptcha_site_key); ?>"></div>
                                            </div>
                                        <?php endif; ?>
                                        <div class="col-lg-12">
                                            <?php if($general_setting->recaptcha_status == 1): ?>
                                                <div class="mb-25">
                                                    <div class="g-recaptcha"
                                                        data-sitekey="<?php echo e($general_setting->recaptcha_site_key); ?>">
                                                    </div>
                                                </div>
                                            <?php endif; ?>

                                            <button type="submit"
                                                class="tg-btn w-100"><?php echo e(__('translate.Send Reset Link')); ?></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- forget-password-area-end -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js_section'); ?>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout_inner_page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/slipinho/public_html/resources/views/auth/forget_password.blade.php ENDPATH**/ ?>