

<?php $__env->startSection('title'); ?>
<title><?php echo e($seo_setting->seo_title); ?></title>
<meta name="title" content="<?php echo e($seo_setting->seo_title); ?>">
<meta name="description" content="<?php echo strip_tags(clean($seo_setting->seo_description)); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('front-content'); ?>
<?php echo $__env->make('breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Modern About Section -->
<div class="modern-about-section pt-120 pb-120 p-relative z-index-1">
    <div class="container">
        <div class="row align-items-center g-5">
            <!-- Left: Image Composition -->
            <div class="col-lg-6">
                <div class="about-composition">
                    <!-- Main Image -->
                    <div class="comp-img-main">
                        <img src="<?php echo e(asset(getSingleImage($about_us, 'about_image_one'))); ?>" alt="About Main">
                    </div>
                    <!-- Secondary Border Image -->
                    <div class="comp-img-secondary">
                        <img src="<?php echo e(asset(getSingleImage($about_us, 'about_image_two'))); ?>" alt="About Secondary">
                    </div>
                    <!-- Small Floating Detail -->
                    <div class="comp-img-small">
                        <img src="<?php echo e(asset(getSingleImage($about_us, 'about_image_three'))); ?>" alt="About Detail">
                    </div>
                    <!-- Decorative Circle -->
                    <div class="comp-shape-circle"></div>
                </div>
            </div>

            <!-- Right: Content -->
            <div class="col-lg-6">
                <div class="about-content pl-40">
                    <div class="section-badge mb-15">
                        <?php echo e(getTranslatedValue($about_us, 'section_subtitle')); ?>

                    </div>
                    <h2 class="section-title mb-20">
                        <?php echo strip_tags(getTranslatedValue($about_us, 'section_title')); ?>

                    </h2>
                    <p class="section-desc mb-35">
                        <?php echo strip_tags(getTranslatedValue($about_us, 'section_description')); ?>

                    </p>

                    <a href="<?php echo e(getTranslatedValue($about_us, 'section_button_link')); ?>" class="modern-btn-primary">
                        <span class="btn-text"><?php echo e(getTranslatedValue($about_us, 'section_button_text')); ?></span>
                        <i class="fa-solid fa-arrow-right-long ml-5"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modern Features Section (Why Choose Us) -->
<div class="modern-features-section pt-100 pb-100 bg-light-gray">
    <div class="container">
        <!-- Header -->
        <div class="row justify-content-center mb-60">
            <div class="col-lg-7 text-center">
                <div class="section-header">
                    <span class="section-badge mb-10"><?php echo e(getTranslatedValue($what_we_do, 'section_subtitle')); ?></span>
                    <h2 class="section-title"><?php echo strip_tags(getTranslatedValue($what_we_do, 'section_title')); ?></h2>
                    <p class="section-desc mt-15"><?php echo strip_tags(getTranslatedValue($what_we_do, 'section_description')); ?></p>
                </div>
            </div>
        </div>

        <?php if($what_we_do?->data_values['slides'] && count($what_we_do->data_values['slides']) > 0): ?>
        <div class="row g-4">
            <?php $__currentLoopData = $what_we_do?->data_values['slides']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $slide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-4 col-md-6">
                <div class="feature-card h-100">
                    <div class="feature-icon-wrapper">
                        <?php if(!isset($slide['image'])): ?>
                        <!-- Preserved SVG Logic (Simplified Container) -->
                        <div class="default-svg-icon">
                            <svg width="40" height="40" viewBox="0 0 36 26" fill="currentColor">
                                <path
                                    d="M28.4378 11.0439H26.3551C26.008 11.0439 25.724 11.3279 25.724 11.675C25.724 12.0221 26.008 12.3061 26.3551 12.3061H28.4378C28.7218 12.3061 28.9553 12.5396 28.9553 12.8236V21.8864C28.9553 22.1704 28.7218 22.4039 28.4378 22.4039H26.3551C26.008 22.4039 25.724 22.6879 25.724 23.035C25.724 23.3821 26.008 23.6661 26.3551 23.6661H28.4378C29.416 23.6661 30.2175 22.8709 30.2175 21.8864V12.8236C30.2175 11.8454 29.4223 11.0439 28.4378 11.0439Z" />
                                <path
                                    d="M4.42403 12.3061H6.50669C6.8538 12.3061 7.1378 12.0221 7.1378 11.675C7.1378 11.3279 6.8538 11.0439 6.50669 11.0439H4.42403C3.44581 11.0439 2.6443 11.8391 2.6443 12.8236V21.8864C2.6443 22.8646 3.4395 23.6661 4.42403 23.6661H6.50669C6.8538 23.6661 7.1378 23.3821 7.1378 23.035C7.1378 22.6879 6.8538 22.4039 6.50669 22.4039H4.42403C4.14003 22.4039 3.90652 22.1704 3.90652 21.8864V12.8236C3.90652 12.5396 4.14003 12.3061 4.42403 12.3061Z" />
                                <path
                                    d="M17.0589 12.1294V11.6624C17.0589 11.3153 16.7749 11.0313 16.4277 11.0313C16.0806 11.0313 15.7966 11.3153 15.7966 11.6624V12.161C14.1431 12.445 12.9061 13.6252 12.9061 15.0325C12.9061 16.4399 14.1368 17.6075 15.7966 17.8915V21.2742C14.7301 21.1038 13.9096 20.4285 13.9096 19.6396C13.9096 19.2925 13.6256 19.0085 13.2785 19.0085C12.9314 19.0085 12.6474 19.2925 12.6474 19.6396C12.6474 21.1227 14.0232 22.3471 15.7966 22.5427V23.0098C15.7966 23.3569 16.0806 23.6409 16.4277 23.6409C16.7749 23.6409 17.0589 23.3569 17.0589 23.0098V22.5112C18.7124 22.2272 19.9556 21.047 19.9556 19.6396C19.9556 18.2323 18.7376 17.0584 17.0589 16.7807V13.398C18.1254 13.562 18.9459 14.2436 18.9459 15.0325C18.9459 15.3796 19.2299 15.6636 19.577 15.6636C19.9241 15.6636 20.2081 15.3796 20.2081 15.0325C20.2081 13.5494 18.8323 12.3251 17.0589 12.1294ZM14.1684 15.0325C14.1684 14.3131 14.8626 13.682 15.7966 13.4548V16.6103C14.8563 16.3831 14.1684 15.752 14.1684 15.0325ZM18.6934 19.6459C18.6934 20.3654 17.9992 20.9902 17.0589 21.2237V18.0682C18.0055 18.2954 18.6934 18.9265 18.6934 19.6523V19.6459Z" />
                            </svg>
                        </div>
                        <?php else: ?>
                        <img src="<?php echo e(asset($slide['image'])); ?>" alt="Icon" class="feature-img-icon">
                        <?php endif; ?>
                    </div>
                    <h4 class="feature-title"><?php echo e($slide['title']); ?></h4>
                    <p class="feature-text"><?php echo e($slide['description']); ?></p>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Modern CTA Banner -->
<div class="modern-cta-section pt-100 pb-100"
    style="background-image: url('<?php echo e(asset(getSingleImage($about_cta, 'section_bg_image'))); ?>');">
    <div class="cta-overlay"></div>
    <div class="container p-relative z-index-1">
        <div class="row justify-content-center">
            <div class="col-lg-10 text-center">
                <span class="cta-subtitle wow fadeInUp"><?php echo e(getTranslatedValue($about_cta, 'section_subtitle')); ?></span>
                <h2 class="cta-title wow fadeInUp" data-wow-delay="0.2s">
                    <?php echo strip_tags(getTranslatedValue($about_cta, 'section_title')); ?>

                </h2>

                <div class="mt-40 wow fadeInUp" data-wow-delay="0.4s">
                    <a href="<?php echo e(getTranslatedValue($about_cta, 'section_button_link')); ?>" class="modern-btn-outline">
                        <?php echo e(getTranslatedValue($about_cta, 'section_button_text')); ?>

                        <i class="fa-solid fa-arrow-right ml-10"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Big Watermark Title if needed (kept from original logic) -->
        <h2 class="cta-big-text wow fadeInUp" data-wow-delay="0.5s">
            <?php echo e(getTranslatedValue($about_cta, 'section_big_title')); ?>

        </h2>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style_section'); ?>
<style>
    /* =========================================
       MODERN ABOUT & FEATURES STYLES
       ========================================= */
    :root {
        --tg-theme-primary: #3b82f6;
        /* Fallback */
    }

    /* --- About Composition --- */
    .about-composition {
        position: relative;
        height: 600px;
        /* Adjust as needed */
    }

    .comp-img-main {
        position: absolute;
        top: 0;
        left: 0;
        width: 75%;
        border-radius: 20px;
        overflow: hidden;
        z-index: 1;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
    }

    .comp-img-main img {
        width: 100%;
        border-radius: 20px;
    }

    .comp-img-secondary {
        position: absolute;
        bottom: 50px;
        right: 20px;
        width: 50%;
        border: 10px solid #fff;
        border-radius: 20px;
        overflow: hidden;
        z-index: 2;
        box-shadow: 0 15px 40px rgba(0, 0, 0, 0.15);
    }

    .comp-img-secondary img {
        width: 100%;
        border-radius: 10px;
    }

    .comp-img-small {
        position: absolute;
        top: 40px;
        right: 0;
        width: 120px;
        height: 120px;
        border-radius: 50%;
        border: 5px solid #fff;
        overflow: hidden;
        z-index: 3;
        box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
        animation: float 4s ease-in-out infinite;
    }

    .comp-img-small img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }



    @keyframes float {

        0%,
        100% {
            transform: translateY(0);
        }

        50% {
            transform: translateY(-15px);
        }
    }

    /* --- Typography --- */
    .section-badge {
        display: inline-block;
        font-size: 14px;
        font-weight: 700;
        text-transform: uppercase;
        color: var(--tg-theme-primary);
        letter-spacing: 1px;
    }

    .section-title {
        font-size: 42px;
        font-weight: 800;
        color: #0f172a;
        line-height: 1.2;
    }

    .section-desc {
        color: #64748b;
        font-size: 16px;
        line-height: 1.7;
    }

    .bg-light-gray {
        background-color: #f8fafc;
    }

    /* --- Buttons --- */
    .modern-btn-primary {
        display: inline-flex;
        align-items: center;
        background: var(--tg-theme-primary);
        color: #fff;
        padding: 15px 35px;
        border-radius: 50px;
        font-weight: 700;
        text-transform: uppercase;
        font-size: 14px;
        transition: all 0.3s;
        box-shadow: 0 4px 15px rgba(59, 130, 246, 0.4);
    }

    .modern-btn-primary:hover {
        background: #1d4ed8;
        color: #fff;
        transform: translateY(-3px);
    }

    .modern-btn-outline {
        display: inline-flex;
        align-items: center;
        background: transparent;
        color: #fff;
        border: 2px solid #fff;
        padding: 14px 40px;
        border-radius: 50px;
        font-weight: 700;
        font-size: 15px;
        transition: all 0.3s;
    }

    .modern-btn-outline:hover {
        background: #fff;
        color: #0f172a;
    }

    /* --- Feature Cards --- */
    .feature-card {
        background: #fff;
        padding: 40px 30px;
        border-radius: 24px;
        text-align: center;
        transition: all 0.3s;
        border: 1px solid #f1f5f9;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.03);
    }

    .feature-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.08);
        border-color: #fff;
    }

    .feature-icon-wrapper {
        width: 80px;
        height: 80px;
        margin: 0 auto 25px;
        background: rgba(59, 130, 246, 0.05);
        /* Very light primary */
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: var(--tg-theme-primary);
        transition: all 0.3s;
    }

    .feature-card:hover .feature-icon-wrapper {
        background: var(--tg-theme-primary);
        color: #fff;
    }

    .default-svg-icon svg {
        width: 36px;
        height: 36px;
    }

    .feature-img-icon {
        width: 40px;
        height: 40px;
        object-fit: contain;
    }

    .feature-title {
        font-size: 20px;
        font-weight: 700;
        margin-bottom: 15px;
        color: #1e293b;
    }

    .feature-text {
        font-size: 15px;
        color: #64748b;
        line-height: 1.6;
    }

    /* --- CTA Banner --- */
    .modern-cta-section {
        background-position: center;
        background-size: cover;
        position: relative;
        overflow: hidden;
    }

    .cta-overlay {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.6);
        /* Dark Overlay */
        z-index: 0;
    }

    .cta-subtitle {
        display: block;
        color: var(--tg-theme-primary);
        font-weight: 700;
        text-transform: uppercase;
        margin-bottom: 15px;
        letter-spacing: 2px;
    }

    .cta-title {
        font-size: 48px;
        color: #fff;
        font-weight: 800;
        line-height: 1.2;
    }

    .cta-big-text {
        position: absolute;
        bottom: -20px;
        left: 50%;
        transform: translateX(-50%);
        font-size: 150px;
        font-weight: 900;
        color: rgba(255, 255, 255, 0.05);
        white-space: nowrap;
        pointer-events: none;
        user-select: none;
    }

    /* Responsive Adjustments */
    @media (max-width: 991px) {
        .about-composition {
            height: 450px;
            margin-bottom: 50px;
        }

        .comp-img-secondary {
            width: 60%;
        }

        .cta-title {
            font-size: 36px;
        }

        .cta-big-text {
            font-size: 80px;
        }
    }
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layout_inner_page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/slipinho/public_html/resources/views/about_us.blade.php ENDPATH**/ ?>