<?php $__env->startSection('title'); ?>
    <title><?php echo e($seo_setting->seo_title); ?></title>
    <meta name="title" content="<?php echo e($seo_setting->seo_title); ?>">
    <meta name="description" content="<?php echo strip_tags(clean($seo_setting->seo_description)); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('front-content'); ?>
    <?php echo $__env->make('breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- tg-faq-area-start -->
    <div class="tg-pricing-area pb-120 pt-125 p-relative">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="tg-faq-content-wrap">
                        <div class="tg-faq-section-title text-center mb-40">
                            <h5 class="tg-section-subtitle mb-15 wow fadeInUp" data-wow-delay=".3s" data-wow-duration=".9s">
                                <?php echo e(getTranslatedValue($faq, 'section_subtitle')); ?>

                            </h5>
                            <h2 class="mb-15 text-capitalize wow fadeInUp" data-wow-delay=".4s" data-wow-duration=".9s">
                                <?php echo e(getTranslatedValue($faq, 'section_title')); ?>

                            </h2>
                        </div>
                        <?php if(!empty($faq?->data_values['slides']) && count($faq->data_values['slides']) > 0): ?>
                            <div class="tg-faq-content">
                                <div class="accordion tg-custom-accordion" id="accordionExample">
                                    <?php $__currentLoopData = $faq->data_values['slides']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $slide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                            'accordion-item mb-10 wow fadeInUp',
                                            'tg-faq-active' => $key == 0,
                                        ]); ?>" data-wow-delay=".3s" data-wow-duration=".9s">
                                            <h2 class="accordion-header">
                                                <button class="accordion-button <?php echo e($key != 0 ? 'collapsed' : ''); ?>"
                                                    type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapse_<?php echo e($key); ?>"
                                                    aria-expanded="<?php echo e($key == 0 ? 'true' : 'false'); ?>"
                                                    aria-controls="collapse_<?php echo e($key); ?>">
                                                    <?php echo e($slide['title'] ?? 'No question provided'); ?>

                                                </button>
                                            </h2>
                                            <div id="collapse_<?php echo e($key); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['accordion-collapse collapse', 'show' => $key == 0]); ?>"
                                                data-bs-parent="#accordionExample">
                                                <div class="accordion-body">
                                                    <p class="mb-0">
                                                        <?php echo strip_tags(clean($slide['description'] ?? 'No answer provided')); ?>

                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- tg-faq-area-end -->

    <!-- tg-cta-area-start -->
    <div class="tg-cta-area-area tg-cta-space pt-125 z-index-9 p-relative">
        <img class="tg-cta-price-shape d-none d-xl-block" src="<?php echo e(asset('frontend/assets/img/shape/hill.png')); ?>" alt="">
        <img class="tg-cta-price-shape-2 d-none d-xl-block" src="<?php echo e(asset('frontend/assets/img/shape/tree.png')); ?>" alt="">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="tg-cta-wrap include-bg"
                        data-background="<?php echo e(asset('frontend/assets/img/shape/cta-banner.jpg')); ?>">
                        <div class="row align-items-end">
                            <div class="col-lg-3 d-none d-lg-block">
                                <div class="tg-cta-thumb pt-50 ml-60">
                                    <img src="<?php echo e(asset(getSingleImage($footer_cta, 'image'))); ?>" alt="">
                                </div>
                            </div>
                            <div class="col-lg-5 col-md-6">
                                <div class="tg-cta-content">
                                    <h5 class="tg-section-subtitle text-white mb-10">
                                        <?php echo e(getTranslatedValue($footer_cta, 'subtitle')); ?></h5>
                                    <h2 class="mb-15 tg-cta-title text-white text-capitalize">
                                        <?php echo strip_tags(clean(getTranslatedValue($footer_cta, 'title'))); ?>

                                    </h2>
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-6">
                                <div class="tg-cta-apps">
                                    <a class="mb-20 d-inline-block mr-5"
                                        href="<?php echo e(getTranslatedValue($footer_cta, 'apple_store_link')); ?>">
                                        <img src="<?php echo e(asset('frontend/assets/img/shape/google.png')); ?>" alt="">
                                    </a>
                                    <a class="mb-20 d-inline-block"
                                        href="<?php echo e(getTranslatedValue($footer_cta, 'google_play_link')); ?>">
                                        <img src="<?php echo e(asset('frontend/assets/img/shape/app.png')); ?>" alt="">
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- tg-cta-area-end -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout_inner_page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/slipinho/public_html/resources/views/faq.blade.php ENDPATH**/ ?>