<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('translate.My Profile')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body-header'); ?>
    <h3 class="crancy-header__title m-0"><?php echo e(__('translate.Edit Profile')); ?></h3>
    <p class="crancy-header__text"><?php echo e(__('translate.Dashboard')); ?> >> <?php echo e(__('translate.Edit Profile')); ?></p>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body-content'); ?>
    <!-- crancy Dashboard -->
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <!-- Dashboard Inner -->
                        <div class="crancy-dsinner">
                            <form action="<?php echo e(route('admin.profile-update')); ?>" enctype="multipart/form-data" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <div class="row">
                                    <div class="col-12 mg-top-30">
                                        <!-- Product Card -->
                                        <div class="crancy-product-card">
                                            <h4 class="crancy-product-card__title"><?php echo e(__('translate.Basic Information')); ?></h4>
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <div class="crancy__item-form--group mg-top-25 w-100">
                                                        <div class="crancy-product-card__upload crancy-product-card__upload--border">
                                                            <input type="file" class="btn-check" name="image" id="input-img1" autocomplete="off" onchange="reviewImage(event)">
                                                            <label class="crancy-image-video-upload__label" for="input-img1">
                                                                <?php if($admin->image): ?>
                                                                <img id="view_img" src="<?php echo e(asset($admin->image)); ?>">
                                                                <?php else: ?>
                                                                <img id="view_img" src="<?php echo e(asset($general_setting->placeholder_image)); ?>">
                                                                <?php endif; ?>
                                                                <h4 class="crancy-image-video-upload__title"><?php echo e(__('translate.Click here to')); ?> <span class="crancy-primary-color"><?php echo e(__('translate.Choose File')); ?></span> <?php echo e(__('translate.and upload')); ?> </h4>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="crancy__item-form--group mg-top-25">
                                                <label class="crancy__item-label crancy__item-label-product"><?php echo e(__('translate.Name')); ?></label>
                                                <input class="crancy__item-input" type="text" name="name" value="<?php echo e($admin->name); ?>">
                                            </div>

                                            <div class="crancy__item-form--group mg-top-25">
                                                <label class="crancy__item-label crancy__item-label-product"><?php echo e(__('translate.Designation')); ?></label>
                                                <input class="crancy__item-input" type="text" name="designation" value="<?php echo e($admin->designation); ?>">
                                            </div>

                                            <div class="crancy__item-form--group mg-top-25">
                                                <label class="crancy__item-label crancy__item-label-product"><?php echo e(__('translate.Email')); ?></label>
                                                <input class="crancy__item-input" type="email" name="email" value="<?php echo e($admin->email); ?>">
                                            </div>

                                            <div class="crancy__item-form--group mg-top-25">
                                                <label class="crancy__item-label crancy__item-label-product"><?php echo e(__('translate.Facebook')); ?></label>
                                                <input class="crancy__item-input" type="text" name="facebook" value="<?php echo e($admin->facebook); ?>">
                                            </div>

                                            <div class="crancy__item-form--group mg-top-25">
                                                <label class="crancy__item-label crancy__item-label-product"><?php echo e(__('translate.Linkedin')); ?></label>
                                                <input class="crancy__item-input" type="text" name="linkedin" value="<?php echo e($admin->linkedin); ?>">
                                            </div>

                                            <div class="crancy__item-form--group mg-top-25">
                                                <label class="crancy__item-label crancy__item-label-product"><?php echo e(__('translate.Twitter')); ?></label>
                                                <input class="crancy__item-input" type="text" name="twitter" value="<?php echo e($admin->twitter); ?>">
                                            </div>

                                            <div class="crancy__item-form--group mg-top-25">
                                                <label class="crancy__item-label crancy__item-label-product"><?php echo e(__('translate.Instagram')); ?></label>
                                                <input class="crancy__item-input" type="text" name="instagram" value="<?php echo e($admin->instagram); ?>">
                                            </div>

                                            <div class="crancy__item-form--group mg-top-25">
                                                <label class="crancy__item-label crancy__item-label-product"><?php echo e(__('translate.About Me')); ?></label>

                                                <textarea class="crancy__item-input crancy__item-textarea seo_description_box"  name="about_me" id="about_me"><?php echo e($admin->about_me); ?></textarea>

                                            </div>


                                            <button class="crancy-btn mg-top-25" type="submit"><?php echo e(__('translate.Update')); ?></button>

                                        </div>
                                        <!-- End Product Card -->
                                    </div>
                                </div>
                            </form>
                        </div>
                        <!-- End Dashboard Inner -->
                    </div>
                </div>

                <div class="col-12">
                    <div class="crancy-body">
                        <!-- Dashboard Inner -->
                        <div class="crancy-dsinner">
                            <form action="<?php echo e(route('admin.update-password')); ?>" enctype="multipart/form-data" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <div class="row">
                                    <div class="col-12 mg-top-30">
                                        <!-- Product Card -->
                                        <div class="crancy-product-card">
                                            <h4 class="crancy-product-card__title"><?php echo e(__('translate.Change Password')); ?></h4>

                                            <div class="crancy__item-form--group mg-top-25">
                                                <label class="crancy__item-label crancy__item-label-product"><?php echo e(__('translate.Current Password')); ?> </label>
                                                <input class="crancy__item-input" type="password" name="current_password">
                                            </div>

                                            <div class="crancy__item-form--group mg-top-25">
                                                <label class="crancy__item-label crancy__item-label-product"><?php echo e(__('translate.New Password')); ?> </label>
                                                <input class="crancy__item-input" type="password" name="password">
                                            </div>

                                            <div class="crancy__item-form--group mg-top-25">
                                                <label class="crancy__item-label crancy__item-label-product"><?php echo e(__('translate.Confirmed Password')); ?> </label>
                                                <input class="crancy__item-input" type="password" name="password_confirmation">
                                            </div>

                                            <button class="crancy-btn mg-top-25" type="submit"><?php echo e(__('translate.Change Password')); ?></button>

                                        </div>
                                        <!-- End Product Card -->
                                    </div>
                                </div>
                            </form>
                        </div>
                        <!-- End Dashboard Inner -->
                    </div>
                </div>


            </div>
        </div>
    </section>
    <!-- End crancy Dashboard -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js_section'); ?>
    <script>
        "use strict";

        function reviewImage(event) {
            console.log(event);
            var reader = new FileReader();
            reader.onload = function(){
                var output = document.getElementById('view_img');
                output.src = reader.result;
            }

            reader.readAsDataURL(event.target.files[0]);
        };
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/slipinho/public_html/resources/views/admin/edit_profile.blade.php ENDPATH**/ ?>