<?php
    $home1_about = getContent('theme1_about_us.content', true);
?>


<?php if(!empty($home1_about)): ?>
    <!-- tg-about-area-start -->
    <div class="tg-about-area pb-100 pt-60">
        <div class="container">
            <div class="row align-items-center">
                <!-- Left Images Column -->
                <div class="col-lg-3 col-md-6">
                    <div class="modern-about-images-left mb-30">
                        <div class="about-image-top wow fadeInLeft" data-wow-delay=".3s" data-wow-duration=".7s">
                            <img class="w-100"
                                src="<?php echo e(asset(getSingleImage($home1_about, 'left_top_image'))); ?>" alt="about">
                        </div>
                        <div class="about-image-bottom wow fadeInLeft" data-wow-delay=".4s" data-wow-duration=".9s">
                            <img class="w-100"
                                src="<?php echo e(asset(getSingleImage($home1_about, 'left_bottom_image'))); ?>" alt="about">
                        </div>
                    </div>
                </div>

                <!-- Center Content Column -->
                <div class="col-lg-6 col-md-12 mb-30">
                    <div class="modern-about-content text-center">
                        <div class="about-logo-wrapper mb-35 wow fadeInUp" data-wow-delay=".3s" data-wow-duration=".5s">
                            <img src="<?php echo e(asset(getSingleImage($home1_about, 'center_image'))); ?>" alt="logo" class="about-center-logo">
                        </div>
                        <div class="about-text-section">
                            <h5 class="about-subtitle wow fadeInUp" data-wow-delay=".4s" data-wow-duration=".6s">
                                <?php echo e(getTranslatedValue($home1_about, 'sub_title')); ?>

                            </h5>
                            <h2 class="about-title wow fadeInUp" data-wow-delay=".5s" data-wow-duration=".7s">
                                <?php echo e(getTranslatedValue($home1_about, 'title')); ?>

                            </h2>
                            <p class="about-description wow fadeInUp" data-wow-delay=".6s" data-wow-duration=".8s">
                                <?php echo strip_tags(clean(getTranslatedValue($home1_about, 'description')), '<br>'); ?>

                            </p>
                        </div>
                        <div class="about-button-wrapper wow fadeInUp" data-wow-delay=".7s" data-wow-duration=".9s">
                            <a href="<?php echo e(getTranslatedValue($home1_about, 'button_url')); ?>"
                                class="modern-about-btn">
                                <span class="btn-content">
                                    <span class="btn-text"><?php echo e(getTranslatedValue($home1_about, 'button_text')); ?></span>
                                    <span class="btn-icon">
                                        <svg width="21" height="16" viewBox="0 0 21 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M1.0017 8.00001H19.9514M19.9514 8.00001L12.9766 1.02515M19.9514 8.00001L12.9766 14.9749"
                                                stroke="currentColor" stroke-width="1.77778" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                        </svg>
                                    </span>
                                </span>
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Right Images Column -->
                <div class="col-lg-3 col-md-6">
                    <div class="modern-about-images-right mb-30">
                        <div class="about-image-top wow fadeInRight" data-wow-delay=".3s" data-wow-duration=".7s">
                            <img class="w-100"
                                src="<?php echo e(asset(getSingleImage($home1_about, 'right_top_image'))); ?>" alt="about">
                        </div>
                        <div class="about-image-bottom wow fadeInRight" data-wow-delay=".4s" data-wow-duration=".9s">
                            <img class="w-100"
                                src="<?php echo e(asset(getSingleImage($home1_about, 'right_bottom_image'))); ?>" alt="about">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- tg-about-area-end -->

    <?php $__env->startPush('style_section'); ?>
        <style>
            /* Modern About Section Styles */
            .tg-about-area {
                background: #ffffff;
                position: relative;
            }

            /* Left and Right Image Columns */
            .modern-about-images-left,
            .modern-about-images-right {
                display: flex;
                flex-direction: column;
                gap: 30px;
            }

            .about-image-top,
            .about-image-bottom {
                border-radius: 25px;
                overflow: hidden;
                box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08);
                transition: all 0.4s ease;
            }

            .about-image-top:hover,
            .about-image-bottom:hover {
                transform: translateY(-5px);
                box-shadow: 0 12px 35px rgba(0, 0, 0, 0.12);
            }

            .about-image-top img,
            .about-image-bottom img {
                width: 100%;
                height: auto;
                object-fit: cover;
                transition: transform 0.5s ease;
            }

            .about-image-top:hover img,
            .about-image-bottom:hover img {
                transform: scale(1.05);
            }

            /* Center Content Section */
            .modern-about-content {
                padding: 20px 30px;
            }

            .about-logo-wrapper {
                display: flex;
                justify-content: center;
                align-items: center;
            }

            .about-center-logo {
                max-width: 180px;
                height: auto;
                transition: transform 0.3s ease;
            }

            .about-center-logo:hover {
                transform: scale(1.05);
            }

            /* Text Styling */
            .about-text-section {
                margin-bottom: 35px;
            }

            .about-subtitle {
                font-size: 16px;
                font-weight: 600;
                text-transform: uppercase;
                letter-spacing: 2px;
                color: #007bff;
                margin-bottom: 15px;
            }

            .about-title {
                font-size: 42px;
                font-weight: 800;
                color: #1a1a1a;
                line-height: 1.2;
                margin-bottom: 20px;
                letter-spacing: -0.5px;
            }

            .about-description {
                font-size: 17px;
                color: #666;
                line-height: 1.8;
                max-width: 650px;
                margin: 0 auto;
            }

            /* Button Styling */
            .about-button-wrapper {
                display: flex;
                justify-content: center;
            }

            .modern-about-btn {
                display: inline-flex;
                align-items: center;
                padding: 15px 35px;
                background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
                color: #ffffff;
                border-radius: 30px;
                text-decoration: none;
                font-weight: 600;
                font-size: 16px;
                transition: all 0.4s ease;
                box-shadow: 0 6px 20px rgba(0, 123, 255, 0.3);
                position: relative;
                overflow: hidden;
            }

            .modern-about-btn::before {
                content: '';
                position: absolute;
                top: 0;
                left: -100%;
                width: 100%;
                height: 100%;
                background: linear-gradient(135deg, #0056b3 0%, #003d82 100%);
                transition: left 0.4s ease;
                z-index: 0;
            }

            .modern-about-btn:hover::before {
                left: 0;
            }

            .modern-about-btn:hover {
                transform: translateY(-3px);
                box-shadow: 0 10px 30px rgba(0, 123, 255, 0.4);
                color: #ffffff;
            }

            .btn-content {
                display: flex;
                align-items: center;
                gap: 10px;
                position: relative;
                z-index: 1;
            }

            .btn-icon {
                display: flex;
                align-items: center;
                transition: transform 0.3s ease;
            }

            .modern-about-btn:hover .btn-icon {
                transform: translateX(5px);
            }

            .btn-icon svg {
                width: 18px;
                height: 18px;
            }

            /* Responsive Design */
            @media (max-width: 1199px) {
                .about-title {
                    font-size: 38px;
                }

                .about-description {
                    font-size: 16px;
                }

                .modern-about-content {
                    padding: 15px 20px;
                }
            }

            @media (max-width: 991px) {
                .about-title {
                    font-size: 34px;
                }

                .about-subtitle {
                    font-size: 15px;
                }

                .about-description {
                    font-size: 15px;
                }

                .modern-about-images-left,
                .modern-about-images-right {
                    gap: 20px;
                }

                .about-image-top,
                .about-image-bottom {
                    border-radius: 20px;
                }

                .col-md-6.col-lg-3 {
                    margin-bottom: 30px;
                }
            }

            @media (max-width: 767px) {
                .about-title {
                    font-size: 30px;
                }

                .about-subtitle {
                    font-size: 14px;
                    letter-spacing: 1.5px;
                }

                .about-description {
                    font-size: 15px;
                    line-height: 1.7;
                }

                .modern-about-content {
                    padding: 10px 15px;
                }

                .about-center-logo {
                    max-width: 150px;
                }

                .modern-about-btn {
                    padding: 13px 30px;
                    font-size: 15px;
                }

                .modern-about-images-left,
                .modern-about-images-right {
                    gap: 15px;
                }

                .about-image-top,
                .about-image-bottom {
                    border-radius: 18px;
                }
            }

            @media (max-width: 575px) {
                .about-title {
                    font-size: 26px;
                }

                .about-subtitle {
                    font-size: 13px;
                }

                .about-description {
                    font-size: 14px;
                }

                .modern-about-btn {
                    padding: 12px 25px;
                    font-size: 14px;
                }

                .about-center-logo {
                    max-width: 130px;
                }

                .about-logo-wrapper {
                    margin-bottom: 25px;
                }

                .about-text-section {
                    margin-bottom: 25px;
                }
            }
        </style>
    <?php $__env->stopPush(); ?>
<?php endif; ?><?php /**PATH /home/slipinho/public_html/Cms/themes/theme1/views/components/about.blade.php ENDPATH**/ ?>