<!DOCTYPE html>
<html class="no-js" lang="zxx">

<head>
    <!-- Meta Tags -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Site Title -->
    <?php echo $__env->yieldContent('title'); ?>

    <!-- Fav Icon -->
    <link rel="icon" href="<?php echo e(asset($general_setting->favicon)); ?>">

    <!--  Stylesheet -->
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('global/datatable/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/slick.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/font-awesome-all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/nice-select.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/reset.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/enrollment.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/overview.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/dev.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('global/toastr/toastr.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/custom.css')); ?>">


    <?php echo $__env->yieldPushContent('style_section'); ?>
</head>

<body id="crancy-dark-light">

    <div class="crancy-body-area ">
        <!-- crancy Admin Menu -->
        <div class="crancy-smenu" id="CrancyMenu">
            <!-- Admin Menu -->
            <div class="admin-menu">

                <!-- Logo -->
                <div class="logo crancy-sidebar-padding pd-right-0">
                    <a class="crancy-logo" href="<?php echo e(route('admin.dashboard')); ?>">
                        <img src="<?php echo e(asset($general_setting->secondary_logo)); ?>" alt="logo">
                    </a>
                    <div id="crancy__sicon" class="crancy__sicon close-icon">
                        <span>
                            <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path d="M5 1L1 6.00489L5 11.0098" stroke="#fff" stroke-width="1.2"
                                    stroke-linecap="round" stroke-linejoin="round" />
                            </svg>

                        </span>
                    </div>
                </div>

                <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


            </div>
            <!-- End Admin Menu -->
        </div>
        <!-- End crancy Admin Menu -->

        <!-- Start Header -->
        <header class="crancy-header">
            <div class="container g-0">
                <div class="row g-0">
                    <div class="col-12">
                        <!-- Dashboard Header -->
                        <div class="crancy-header__inner">
                            <div class="crancy-header__middle">
                                <div id="crancy__sicon" class="crancy__sicon close-icon d-none">
                                    <span>
                                        <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M1 1L5 6.00489L1 11.0098" stroke="#BFCDFF" stroke-width="1.2"
                                                stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>

                                    </span>
                                </div>

                                <div class="crancy-header__heading">
                                    <?php echo $__env->yieldContent('body-header'); ?>

                                </div>


                                <div class="crancy-header__right">
                                    <div class="crancy-header__group">
                                        <div class="crancy-header__group-two">
                                            <div class="crancy-header__right">



                                                <!-- Header Option Group -->
                                                <div class="crancy-header__options">

                                                    <!-- Header Notifications -->
                                                    <div class="crancy-header__single">
                                                        <a target="_blank" class="crancy-header__blink"
                                                            href="<?php echo e(route('home')); ?>">
                                                            <svg width="22" height="22" viewBox="0 0 22 22"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <ellipse cx="11" cy="11" rx="4"
                                                                    ry="10" stroke="currentColor"
                                                                    stroke-width="1.5" />
                                                                <path
                                                                    d="M20.9962 10.7205C19.1938 12.2016 15.3949 13.2222 11 13.2222C6.60511 13.2222 2.80619 12.2016 1.00383 10.7205M20.9962 10.7205C20.8482 5.32691 16.4294 1 11 1C5.57061 1 1.15183 5.32691 1.00383 10.7205M20.9962 10.7205C20.9987 10.8134 21 10.9065 21 11C21 16.5228 16.5228 21 11 21C5.47715 21 1 16.5228 1 11C1 10.9065 1.00128 10.8134 1.00383 10.7205"
                                                                    stroke="currentColor" stroke-width="1.5" />
                                                            </svg>

                                                        </a>

                                                    </div>
                                                    <!-- End Notifications -->

                                                    <!-- Header Message -->
                                                    <div class="crancy-header__single crancy-header__single--messages">
                                                        <a class="crancy-header__blink"
                                                            href="<?php echo e(route('admin.contact-message')); ?>">
                                                            <svg width="22" height="20" viewBox="0 0 22 20"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="M7 8H15M7 12H11M10 1H12C16.9706 1 21 5.02944 21 10C21 14.9706 16.9706 19 12 19H5C2.79086 19 1 17.2091 1 15V10C1 5.02944 5.02944 1 10 1Z"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round" />
                                                            </svg>

                                                        </a>

                                                    </div>
                                                    <!-- End Header Message -->



                                                    <!-- Header Settings -->
                                                    <div class="crancy-header__settings">
                                                        <a class="crancy-header__blink"
                                                            href="<?php echo e(route('admin.general-setting')); ?>">
                                                            <svg width="24" height="24" viewBox="0 0 24 24"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="M15.5 12C15.5 13.933 13.933 15.5 12 15.5C10.067 15.5 8.5 13.933 8.5 12C8.5 10.067 10.067 8.5 12 8.5C13.933 8.5 15.5 10.067 15.5 12Z"
                                                                    stroke="currentColor" stroke-width="1.5" />
                                                                <path
                                                                    d="M22 13.9669V10.0332C19.1433 10.0332 17.2857 6.93041 18.732 4.46691L15.2679 2.5001C13.8038 4.99405 10.1978 4.99395 8.73363 2.5L5.26953 4.46681C6.71586 6.93035 4.85673 10.0332 2 10.0332V13.9669C4.85668 13.9669 6.71425 17.0697 5.26795 19.5332L8.73205 21.5C10.1969 19.0048 13.8046 19.0047 15.2695 21.4999L18.7336 19.5331C17.2874 17.0696 19.1434 13.9669 22 13.9669Z"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round" stroke-linejoin="round" />
                                                            </svg>

                                                        </a>
                                                    </div>
                                                    <!-- Header Nav -->
                                                </div>
                                                <!-- End Header Option Group-->

                                                <?php
                                                    $auth_admin = Auth::guard('admin')->user();
                                                ?>

                                                <!-- Header Author -->
                                                <div class="crancy-header__single">
                                                    <a href="<?php echo e(route('admin.edit-profile')); ?>">
                                                        <div class="crancy-header__author-img">
                                                            <?php if($auth_admin?->image): ?>
                                                                <img src="<?php echo e(asset($auth_admin?->image)); ?>"
                                                                    alt="#">
                                                            <?php else: ?>
                                                                <img src="<?php echo e(asset($general_setting->default_avatar)); ?>"
                                                                    alt="#">
                                                            <?php endif; ?>

                                                        </div>
                                                    </a>
                                                    <!-- crancy Profile Hover -->

                                                    <!-- Dropdown List -->
                                                    <div class="crancy-dropdown crancy-dropdown--acount">
                                                        <div class="crancy-dropdown__hover--inner">
                                                            <ul class="crancy-dmenu">
                                                                <li>
                                                                    <a href="<?php echo e(route('admin.edit-profile')); ?>">
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            width="24" height="24"
                                                                            viewBox="0 0 24 24" fill="none">
                                                                            <path
                                                                                d="M12.1202 12.78C12.0502 12.77 11.9602 12.77 11.8802 12.78C10.1202 12.72 8.72021 11.28 8.72021 9.50998C8.72021 7.69998 10.1802 6.22998 12.0002 6.22998C13.8102 6.22998 15.2802 7.69998 15.2802 9.50998C15.2702 11.28 13.8802 12.72 12.1202 12.78Z"
                                                                                stroke-width="1.5"
                                                                                stroke-linecap="round"
                                                                                stroke-linejoin="round" />
                                                                            <path
                                                                                d="M18.7398 19.3801C16.9598 21.0101 14.5998 22.0001 11.9998 22.0001C9.39977 22.0001 7.03977 21.0101 5.25977 19.3801C5.35977 18.4401 5.95977 17.5201 7.02977 16.8001C9.76977 14.9801 14.2498 14.9801 16.9698 16.8001C18.0398 17.5201 18.6398 18.4401 18.7398 19.3801Z"
                                                                                stroke-width="1.5"
                                                                                stroke-linecap="round"
                                                                                stroke-linejoin="round" />
                                                                            <path
                                                                                d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z"
                                                                                stroke-width="1.5"
                                                                                stroke-linecap="round"
                                                                                stroke-linejoin="round" />
                                                                        </svg>
                                                                        <?php echo e(__('translate.My Profile')); ?>

                                                                    </a>
                                                                </li>


                                                                <li>
                                                                    <a href="<?php echo e(route('admin.logout')); ?>"
                                                                        onclick="event.preventDefault();
                                                                        document.getElementById('admin-logout-form').submit();">
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            width="24" height="24"
                                                                            viewBox="0 0 24 24" fill="none">
                                                                            <path
                                                                                d="M15 10L13.7071 11.2929C13.3166 11.6834 13.3166 12.3166 13.7071 12.7071L15 14M14 12L22 12M6 20C3.79086 20 2 18.2091 2 16V8C2 5.79086 3.79086 4 6 4M6 20C8.20914 20 10 18.2091 10 16V8C10 5.79086 8.20914 4 6 4M6 20H14C16.2091 20 18 18.2091 18 16M6 4H14C16.2091 4 18 5.79086 18 8"
                                                                                stroke-width="1.5"
                                                                                stroke-linecap="round" />
                                                                        </svg>
                                                                        <?php echo e(__('translate.Logout')); ?>

                                                                    </a>

                                                                    <form id="admin-logout-form"
                                                                        action="<?php echo e(route('admin.logout')); ?>"
                                                                        method="POST" class="d-none">
                                                                        <?php echo csrf_field(); ?>
                                                                    </form>
                                                                </li>
                                                            </ul>

                                                        </div>
                                                    </div>
                                                    <!-- End Dropdown List -->
                                                </div>
                                                <!-- End Header Author -->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>
        <!-- End Header -->

        <?php echo $__env->yieldContent('body-content'); ?>

    </div>

    <!--  Scripts -->
    <script src="<?php echo e(asset('global/js/jquery-3.7.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('global/datatable/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('global/datatable/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/jquery-migrate.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/bootstrap.min.js')); ?>"></script>

    <script src="<?php echo e(asset('backend/js/nice-select.min.js')); ?>"></script>

    <script src="<?php echo e(asset('backend/js/main.js')); ?>"></script>
    <script src="<?php echo e(asset('global/toastr/toastr.min.js')); ?>"></script>

    <script>
        (function($) {
            "use strict"
            $(document).ready(function() {


                const session_notify_message = <?php echo json_encode(Session::get('message'), 15, 512) ?>;

                if (session_notify_message != null) {
                    const session_notify_type = <?php echo json_encode(Session::get('alert-type', 'info'), 512) ?>;
                    switch (session_notify_type) {
                        case 'info':
                            toastr.info(session_notify_message);
                            break;
                        case 'success':
                            toastr.success(session_notify_message);
                            break;
                        case 'warning':
                            toastr.warning(session_notify_message);
                            break;
                        case 'error':
                            toastr.error(session_notify_message);
                            break;
                    }
                }

                const validation_errors = <?php echo json_encode($errors->all(), 15, 512) ?>;

                if (validation_errors.length > 0) {
                    validation_errors.forEach(error => toastr.error(error));
                }

                const session_success = `<?php echo e(Session::get('success')); ?>`;
                const session_error = `<?php echo e(Session::get('error')); ?>`;
                if (session_success) {
                    toastr.success(session_success);
                }

                if (session_error) {
                    toastr.error(session_error);
                }

                $('#dataTable').DataTable();
            });
        })(jQuery);
    </script>


    <?php echo $__env->yieldPushContent('js_section'); ?>

</body>

</html>
<?php /**PATH /home/slipinho/public_html/resources/views/admin/master_layout.blade.php ENDPATH**/ ?>