<button class="cart-button" id="cartButton">
    <span>
        <svg width="23" height="23" viewBox="0 0 27 27" fill="none" xmlns="http://www.w3.org/2000/svg">
            <g clip-path="url(#clip0_53_138)">
                <path
                    d="M11.1267 24.5359C11.1275 24.8398 11.0358 25.1371 10.8633 25.3903C10.6907 25.6434 10.4451 25.8411 10.1573 25.9583C9.86959 26.0755 9.55267 26.107 9.24659 26.0487C8.94051 25.9905 8.65899 25.8452 8.4376 25.6312C8.21621 25.4171 8.06486 25.144 8.00268 24.8462C7.9405 24.5484 7.97027 24.2393 8.08823 23.958C8.20619 23.6766 8.40706 23.4357 8.66546 23.2655C8.92385 23.0954 9.2282 23.0037 9.54005 23.002H9.55264C9.97012 23.002 10.3705 23.1636 10.6657 23.4512C10.9609 23.7389 11.1267 24.1291 11.1267 24.5359ZM19.6269 23.002H19.6143C19.1957 23.0036 18.7948 23.167 18.4997 23.4563C18.2046 23.7456 18.0393 24.1372 18.0402 24.5451C18.041 24.953 18.2079 25.344 18.5042 25.6321C18.8005 25.9203 19.202 26.0821 19.6206 26.0821C20.0392 26.0821 20.4407 25.9203 20.7369 25.6321C21.0332 25.344 21.2001 24.953 21.2009 24.5451C21.2018 24.1372 21.0365 23.7456 20.7414 23.4563C20.4463 23.167 20.0455 23.0036 19.6269 23.002ZM25.5266 9.18654L24.2497 16.7532C24.2179 17.3062 24.0702 17.8469 23.8155 18.342C23.5609 18.837 23.2047 19.276 22.7691 19.6316C22.3335 19.9872 21.8276 20.252 21.2828 20.4096C20.738 20.5671 20.1658 20.6141 19.6017 20.5476H9.19249C8.36008 20.5442 7.55653 20.2499 6.9278 19.7183C6.29907 19.1866 5.88685 18.4529 5.766 17.6503L3.86072 4.68407C3.80569 4.31993 3.61877 3.987 3.33376 3.7455C3.04874 3.50399 2.68445 3.36984 2.30677 3.36732H1.9718C1.72132 3.36732 1.48109 3.27035 1.30397 3.09775C1.12685 2.92515 1.02734 2.69105 1.02734 2.44695C1.02734 2.20285 1.12685 1.96875 1.30397 1.79614C1.48109 1.62354 1.72132 1.52657 1.9718 1.52657H2.30677C3.13918 1.53002 3.94272 1.82428 4.57146 2.35592C5.20019 2.88756 5.61241 3.62131 5.73326 4.42391L5.84911 5.20807H22.1202C22.6275 5.208 23.1286 5.31654 23.5881 5.52602C24.0476 5.73549 24.4542 6.04078 24.7793 6.4203C25.1044 6.79981 25.3399 7.24429 25.4692 7.7223C25.5986 8.2003 25.6173 8.70017 25.5266 9.18654ZM23.3279 7.60104C23.1805 7.42831 22.9959 7.2893 22.7872 7.19387C22.5785 7.09843 22.3508 7.04891 22.1202 7.04881H6.1186L7.62973 17.3901C7.68498 17.7557 7.87318 18.0898 8.16003 18.3315C8.44688 18.5732 8.81329 18.7064 9.19249 18.7069H19.6017C21.6165 18.7069 22.1026 17.9706 22.3884 16.4403L23.6654 8.87238C23.7089 8.64933 23.7012 8.41965 23.6429 8.19984C23.5845 7.98002 23.477 7.77552 23.3279 7.60104ZM17.7128 11.9575H12.6756C12.4252 11.9575 12.1849 12.0544 12.0078 12.227C11.8307 12.3997 11.7312 12.6338 11.7312 12.8778C11.7312 13.1219 11.8307 13.356 12.0078 13.5287C12.1849 13.7013 12.4252 13.7982 12.6756 13.7982H17.7128C17.9632 13.7982 18.2035 13.7013 18.3806 13.5287C18.5577 13.356 18.6572 13.1219 18.6572 12.8778C18.6572 12.6338 18.5577 12.3997 18.3806 12.227C18.2035 12.0544 17.9632 11.9575 17.7128 11.9575Z"
                    fill="currentColor" />
            </g>
            <defs>
                <clipPath id="clip0_53_138">
                    <rect width="26" height="26" fill="white" transform="translate(0.304688 0.804352)" />
                </clipPath>
            </defs>
        </svg>
    </span>
    <span class="tg-header-cart-count"><?php echo e($cartCount); ?></span>
</button>
<div class="minicart" id="minicartContent">

</div>

<?php $__env->startPush('js_section'); ?>
    <script>
        function cartList() {
            $('#minicartContent').html('Please wait...');
            $.ajax({
                url: `<?php echo e(route('cart.cart_items')); ?>`,
                method: 'GET',
                success: function(data) {
                    $('#minicartContent').html(data.view);
                },
                error: function() {
                    $('#minicartContent').html('<div class="text-center">Error loading cart items</div>');
                }
            });
        }

        $('#cartButton').on('mouseenter', function() {
            cartList();
        });

        function removeFromCart(cartId) {
            $.ajax({
                url: `<?php echo e(route('cart.remove_item')); ?>`,
                method: 'GET',
                data: {
                    cart_id: cartId,
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function(data) {
                    cartList();
                },
                error: function() {
                    $('#minicartContent').html('Error loading cart items');
                }
            });
        }
    </script>
<?php $__env->stopPush(); ?>


<style>
    .cart-thumb img {
        width: 80px;
        height: 80px;
    }

    .cart-item-wrapper {
        max-height: 300px;
        overflow-y: scroll;
        padding-right: 10px;
    }
</style>
<?php /**PATH D:\themedox\tourex\resources\views/components/cart.blade.php ENDPATH**/ ?>