<?php
    $theme1_tour_package = getContent('theme1_tour_package.content', true);

    $theme1_service = serviceTypeTab();
    $theme1_popular_services = popularServices();

?>

<!-- tg-listing-area-start -->
<div class="tg-listing-area pt-110 pb-110 p-relative z-index-9">
    <img class="tg-listing-shape d-none d-lg-block" src="<?php echo e(asset('frontend/assets/img/shape/air-plane.png')); ?>"
        alt="air-plane">
    <img class="tg-listing-shape-2 d-none d-xl-block" src="<?php echo e(asset('frontend/assets/img/shape/pyramid.png')); ?>"
        alt="pyramid">
  
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="tg-listing-section-title text-center mb-35">
                    <h5 class="tg-section-subtitle wow fadeInUp d-none" data-wow-delay=".3s" data-wow-duration=".5s">
                        <?php echo e(getTranslatedValue($theme1_tour_package, 'sub_title')); ?>

                    </h5>
                    <h2 class="mb-15 wow fadeInUp" data-wow-delay=".4s" data-wow-duration=".6s">
                        <?php echo e(getTranslatedValue($theme1_tour_package, 'title')); ?>

                    </h2>
                          <p class="text-capitalize wow fadeInUp text-left" data-wow-delay=".3s" data-wow-duration=".5s" style="text-align:left;">
                        <?php echo e(getTranslatedValue($theme1_tour_package, 'sub_title')); ?>

                    </p>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="tg-listing-menu-nav project__menu-nav mb-40 wow fadeInUp d-none" data-wow-delay=".5s"
                    data-wow-duration=".9s">

                    <button class="active" data-filter="*">
                        <span class="borders"></span>
                        <span class="icon">
                            <svg width="19px" height="12px" viewBox="-4 0 20 20" version="1.1"
                                xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                                <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                    <g id="Dribbble-Light-Preview" transform="translate(-304.000000, -7999.000000)"
                                        fill="#000000">
                                        <g id="icons" transform="translate(56.000000, 160.000000)">
                                            <path
                                                d="M256.162,7849.021 C253.481,7848.993 254.468,7848.994 251.837,7849.021 C250.981,7847.931 250,7845.79 250,7844.851 C250,7842.728 251.794,7841 254,7841 C256.205,7841 258,7842.728 258,7844.851 C258,7845.79 257.018,7847.931 256.162,7849.021 M254,7839 C250.686,7839 248,7841.62 248,7844.851 C248,7846.638 249.705,7849.956 251,7851.03 L253,7851.009 L253,7859 L255,7859 L255,7851.009 L257,7851.03 C258.294,7849.956 260,7846.638 260,7844.851 C260,7841.62 257.313,7839 254,7839"
                                                id="balloon-[#42]">
                                            </path>
                                        </g>
                                    </g>
                                </g>
                            </svg>
                        </span>
                        <span><?php echo e(__('translate.All')); ?></span>
                    </button>

                    <?php $__currentLoopData = $theme1_service; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $service_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <button data-filter=".type-<?php echo e($service_type->id); ?>">
                            <span class="borders"></span>
                            <span class="icon">
                                <?php if($service_type->image): ?>
                                    <img width="19" height="12" src="<?php echo e(asset($service_type->image)); ?>">
                                <?php elseif($service_type->icon): ?>
                                    <i class="<?php echo e($service_type->icon); ?>"></i>
                                <?php endif; ?>
                            </span>
                            <span><?php echo e($service_type?->name); ?></span>
                        </button>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
        </div>
        <div class="row project-active-two">
            <?php $__currentLoopData = $theme1_popular_services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xxl-3 col-xl-4 col-lg-4 col-md-6 grid-item grid-sizer type-<?php echo e($service->service_type_id); ?>">
                    <div class="package-card-modern mb-30">
                        <!-- Image Section with Overlay Content -->
                        <div class="package-image-container">
                            <a href="<?php echo e(route('front.tourbooking.services.show', ['slug' => $service?->slug])); ?>" class="package-image-link">
                                <img class="package-image"
                                    src="<?php echo e(asset($service?->thumbnail?->file_path)); ?>"
                                    alt="<?php echo e($service?->thumbnail?->caption ?? $service?->translation?->title); ?>">
                                <div class="package-overlay"></div>
                            </a>

                            <!-- Wishlist Icon -->
                            <div class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                'package-wishlist-icon',
                                'active' => $service?->my_wishlist_exists == 1,
                            ]); ?>" data-url="<?php echo e(route('user.wishlist.store')); ?>"
                                onclick="addToWishlist(<?php echo e($service->id); ?>, this, 'service')">
                                <a href="javascript:void(0)">
                                    <svg width="20" height="18" viewBox="0 0 20 18" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M10.5167 16.3416C10.2334 16.4416 9.76675 16.4416 9.48341 16.3416C7.06675 15.5166 1.66675 12.075 1.66675 6.24165C1.66675 3.66665 3.74175 1.58331 6.30008 1.58331C7.81675 1.58331 9.15841 2.31665 10.0001 3.44998C10.8417 2.31665 12.1917 1.58331 13.7001 1.58331C16.2584 1.58331 18.3334 3.66665 18.3334 6.24165C18.3334 12.075 12.9334 15.5166 10.5167 16.3416Z"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                    </svg>
                                </a>
                            </div>

                            <!-- Airplane Icon (Top Right) -->
                            <div class="package-airplane-icon">
                                <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M35 15L25 25L20 20L30 10L35 15Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M20 20L15 25L10 20" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M30 10L25 5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </div>

                            <!-- Content on Image (Bottom) -->
                            <div class="package-bottom-content">
                                <h3 class="package-title">
                                    <a href="<?php echo e(route('front.tourbooking.services.show', ['slug' => $service?->slug])); ?>">
                                        <?php echo e(Str::limit($service?->translation?->title, 45)); ?>

                                    </a>
                                </h3>
                                
                                <div class="package-footer-info">
                                    <div class="package-price-section">
                                        <span class="price-from">From</span>
                                        <span class="price-amount"><?php echo $service?->price_display; ?></span>
                                    </div>
                                    <a href="<?php echo e(route('front.tourbooking.services.show', ['slug' => $service?->slug])); ?>" class="package-explore-link">
                                        Explore
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M6 12L10 8L6 4" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        </svg>
                                    </a>
                                </div>
                            </div>

                            <!-- Badges -->
                            <?php if($service?->is_new == 1 || $service?->discount_price || $service?->is_featured == 1): ?>
                                <div class="package-badges-group">
                                    <?php if($service?->is_new == 1): ?>
                                        <span class="package-badge badge-new">New</span>
                                    <?php endif; ?>

                                    <?php if($service?->discount_price): ?>
                                        <span class="package-badge badge-sale">Sale</span>
                                    <?php endif; ?>

                                    <?php if($service?->is_featured == 1): ?>
                                        <span class="package-badge badge-featured">
                                            <svg width="12" height="14" viewBox="0 0 12 14" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M6.60156 1L0.601562 8.2H6.00156L5.40156 13L11.4016 5.8H6.00156L6.60156 1Z"
                                                    stroke="currentColor" stroke-width="0.857143" stroke-linecap="round"
                                                    stroke-linejoin="round"></path>
                                            </svg>
                                            Featured
                                        </span>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<!-- tg-listing-area-end -->

<?php $__env->startPush('style_section'); ?>
    <style>
        /* Package Card Modern */
        .package-card-modern {
            position: relative;
            border-radius: 28px;
            overflow: hidden;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            background: transparent;
        }

        .package-card-modern:hover {
            transform: translateY(-8px);
        }

        /* Image Container */
        .package-image-container {
            position: relative;
            width: 100%;
            height: 316px;
            border-radius: 28px;
            overflow: hidden;
        }

        .package-image-link {
            display: block;
            width: 100%;
            height: 100%;
        }

        .package-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.6s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .package-card-modern:hover .package-image {
            transform: scale(1.08);
        }

        /* Overlay Gradient */
        .package-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(
                to bottom,
                rgba(0, 0, 0, 0) 0%,
                rgba(0, 0, 0, 0.1) 40%,
                rgba(0, 0, 0, 0.7) 100%
            );
            z-index: 1;
        }

        /* Wishlist Icon (Top Left) */
        .package-wishlist-icon {
            position: absolute;
            top: 20px;
            left: 20px;
            width: 45px;
            height: 45px;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s ease;
            z-index: 3;
            color: #666;
        }

        .package-wishlist-icon:hover {
            background: #ffffff;
            transform: scale(1.1);
        }

        .package-wishlist-icon.active {
            color: #ff6b6b;
        }

        .package-wishlist-icon a {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 100%;
            height: 100%;
        }

        .package-wishlist-icon svg {
            width: 22px;
            height: 22px;
        }

        /* Airplane Icon (Top Right) */
        .package-airplane-icon {
            position: absolute;
            top: 20px;
            right: 20px;
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 3;
            opacity: 0.15;
            color: #ffffff;
        }

        .package-airplane-icon svg {
            width: 100%;
            height: 100%;
            stroke: currentColor;
        }

        /* Bottom Content on Image */
        .package-bottom-content {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            padding: 30px;
            z-index: 2;
            background: linear-gradient(to top, rgba(0, 0, 0, 0.4), transparent);
        }

        .package-title {
            margin: 0 0 8px 0;
            font-size: 19px;
            font-weight: 700;
            line-height: 1.3;
        }

        .package-title a {
            color: #ffffff;
            text-decoration: none;
            text-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
            transition: opacity 0.3s ease;
        }

        .package-title a:hover {
            opacity: 0.9;
        }

        /* Footer Info (Price + Explore) */
        .package-footer-info {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .package-price-section {
            display: flex;
            flex-direction: column;
            gap: 2px;
        }

        .price-from {
            font-size: 14px;
            color: rgba(255, 255, 255, 0.9);
            font-weight: 500;
            text-shadow: 0 1px 3px rgba(0, 0, 0, 0.2);
        }

        .price-amount {
            font-size: 22px;
            font-weight: 800;
            color: #ffffff;
            line-height: 1;
            text-shadow: 0 2px 8px rgba(0, 0, 0, 0.3);
        }

        .price-amount del {
            font-size: 18px;
            color: rgba(255, 255, 255, 0.7);
            font-weight: 500;
            margin-right: 8px;
        }

        /* Explore Link/Button */
        .package-explore-link {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px 28px;
            background: #007bff;
            color: #ffffff;
            border-radius: 30px;
            text-decoration: none;
            font-weight: 600;
            font-size: 15px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(0, 123, 255, 0.3);
            display:none;
        }

        .package-explore-link:hover {
            background: #0056b3;
            color: #ffffff;
            transform: translateX(4px);
            box-shadow: 0 6px 20px rgba(0, 123, 255, 0.4);
        }

        .package-explore-link svg {
            width: 14px;
            height: 14px;
            transition: transform 0.3s ease;
        }

        .package-explore-link:hover svg {
            transform: translateX(3px);
        }

        /* Badges Group */
        .package-badges-group {
            position: absolute;
            top: 20px;
            left: 50%;
            transform: translateX(-50%);
            display: flex;
            gap: 8px;
            z-index: 3;
            display:none;
        }

        .package-badge {
            display: inline-flex;
            align-items: center;
            gap: 4px;
            padding: 6px 14px;
            border-radius: 20px;
            font-size: 11px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            backdrop-filter: blur(10px);
            color: #ffffff;
        }

        .badge-new {
            background: rgba(76, 175, 80, 0.95);
        }

        .badge-sale {
            background: rgba(244, 67, 54, 0.95);
        }

        .badge-featured {
            background: rgba(255, 152, 0, 0.95);
        }

        .package-badge svg {
            width: 10px;
            height: 10px;
        }

        /* Responsive Design */
        @media (max-width: 1199px) {
            .package-image-container {
                height: 420px;
            }

            .package-title {
                font-size: 24px;
            }

            .price-amount {
                font-size: 26px;
            }
        }

        @media (max-width: 991px) {
            .package-image-container {
                height: 400px;
                border-radius: 24px;
            }

            .package-card-modern {
                border-radius: 24px;
            }

            .package-title {
                font-size: 22px;
            }

            .price-amount {
                font-size: 24px;
            }

            .package-bottom-content {
                padding: 25px;
            }
        }

        @media (max-width: 767px) {
            .package-image-container {
                height: 380px;
                border-radius: 22px;
            }

            .package-card-modern {
                border-radius: 22px;
            }

            .package-title {
                font-size: 20px;
            }

            .price-amount {
                font-size: 22px;
            }

            .package-bottom-content {
                padding: 22px;
            }

            .package-explore-link {
                padding: 10px 24px;
                font-size: 14px;
            }

            .package-airplane-icon {
                width: 50px;
                height: 50px;
            }
        }

        @media (max-width: 575px) {
            .package-image-container {
                height: 350px;
                border-radius: 20px;
            }

            .package-card-modern {
                border-radius: 20px;
                margin-bottom: 20px;
            }

            .package-title {
                font-size: 18px;
                margin-bottom: 16px;
            }

            .price-amount {
                font-size: 20px;
            }

            .package-bottom-content {
                padding: 20px;
            }

            .package-explore-link {
                padding: 9px 20px;
                font-size: 13px;
            }

            .package-wishlist-icon {
                width: 40px;
                height: 40px;
                top: 16px;
                left: 16px;
            }

            .package-airplane-icon {
                width: 45px;
                height: 45px;
                top: 16px;
                right: 16px;
            }

            .package-badges-group {
                top: 16px;
            }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js_section'); ?>
    <script src="<?php echo e(asset('frontend/assets/js/cart.js')); ?>"></script>
<?php $__env->stopPush(); ?><?php /**PATH C:\xampp\htdocs\slipinholidays\slipin\Cms/themes/theme1/views/components/package.blade.php ENDPATH**/ ?>