<?php $__env->startSection('title'); ?>
    <title><?php echo e($seo_setting->seo_title); ?></title>
    <meta name="title" content="<?php echo e($seo_setting->seo_title); ?>">
    <meta name="description" content="<?php echo strip_tags(clean($seo_setting->seo_description)); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('front-content'); ?>
    <?php echo $__env->make('breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- cart area -->
    <div class="cart-area pb-100 pt-105">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="tg-cart-table-content table-responsive mb-30">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('translate.Product')); ?></th>
                                    <th class="price"><?php echo e(__('translate.Price')); ?></th>
                                    <th><?php echo e(__('translate.Quantity')); ?></th>
                                    <th class="subtotal"><?php echo e(__('translate.Subtotal')); ?></th>
                                    <th><?php echo e(__('translate.Remove')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $subtotal = 0;
                                ?>
                                <?php $__currentLoopData = $carts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $itemTotal = $cart->product ? $cart->product->finalPrice * $cart->quantity : 0;
                                        $subtotal += $itemTotal;
                                    ?>
                                    <tr>
                                        <td class="product-thumbnail">
                                            <a class="thumb" href="<?php echo e(route('product.view', $cart->product->slug)); ?>">
                                                <img src="<?php echo e(getImageOrPlaceholder($cart->product->thumbnail_image, '125x135')); ?>"
                                                    alt="product">
                                            </a>
                                            <a class="texts" href="<?php echo e(route('product.view', $cart->product->slug)); ?>">
                                                <?php echo e(__(Str::limit($cart->product->translate?->name, 35))); ?>

                                            </a>
                                        </td>
                                        <td class="product-price2">
                                            <span class="amount price_display">
                                                <?php echo $cart->product->price_display; ?>

                                            </span>
                                        </td>
                                        <td class="product-quantity">
                                            <div class="tg-product-details-quantity">
                                                <div class="tg-booking-quantity-item">
                                                    <span class="optech-product-minus decrement"
                                                        data-id="<?php echo e($cart->id); ?>">
                                                        <svg width="14" height="2" viewBox="0 0 14 2" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M1 1H13" stroke="currentColor" stroke-width="1.5"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </span>
                                                    <input class="tg-quantity-input number" type="text"
                                                        id="quantity-<?php echo e($cart->id); ?>" value="<?php echo e($cart->quantity); ?>">
                                                    <span class="optech-product-plus" data-id="<?php echo e($cart->id); ?>">
                                                        <svg width="15" height="14" viewBox="0 0 15 14"
                                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M1.21924 7H13.3836" stroke="currentColor"
                                                                stroke-width="1.5" stroke-linecap="round"
                                                                stroke-linejoin="round" />
                                                            <path d="M7.30176 13V1" stroke="currentColor" stroke-width="1.5"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                    </span>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="product-subtotal price total-price" id="price-<?php echo e($cart->id); ?>"
                                            data-unit-price="<?php echo e($cart->product ? $cart->product->finalPrice : 0); ?>">
                                            <?php echo e(currency($itemTotal)); ?>

                                        </td>
                                        <td class="product-remove">
                                            <i class="fa fa-times delete-cart-item cp" data-id="<?php echo e($cart->id); ?>"
                                                data-url="<?php echo e(route('cart.delete', $cart->id)); ?>"></i>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="row">
                        <div class="col-xl-9 col-lg-8 col-md-7">

                        </div>
                        <div class="col-xl-3 col-lg-4 col-md-5">
                            <div class="tg-cart-page-total mb-20">
                                <ul class="mb-20">
                                    <li> <?php echo e(__('translate.Subtotal')); ?> <span
                                            class="sub_total"><?php echo e(currency($subtotal)); ?></span></li>
                                    <li> <?php echo e(__('translate.Total')); ?> <span
                                            class="total_sale"><?php echo e(currency($subtotal)); ?></span></li>
                                </ul>
                                <div class="d-flex justify-content-between">
                                    <?php if($carts->isNotEmpty()): ?>
                                        <a class="tg-btn mb-10 rt-mt-40" data-aos="fade-up"
                                            href="<?php echo e(route('checkout.index')); ?>"
                                            data-text="<?php echo e(__('translate.Proceed to Checkout')); ?>"><span class="btn-wraper">
                                                <?php echo e(__('translate.Proceed to Checkout')); ?>

                                            </span>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- cart area end-->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js_section'); ?>
    <script src="<?php echo e(asset('global/sweetalert/sweetalert2@11.js')); ?>"></script>
    <script>
        "use strict";

        function updateSubtotal() {
            let subtotal = 0;
            document.querySelectorAll('.total-price').forEach(priceElement => {
                const price = parseFloat(priceElement.innerText.replace(/[^0-9.-]+/g, ''));
                if (!isNaN(price)) {
                    subtotal += price;
                }
            });
            document.querySelector('.sub_total').innerHTML = currency(subtotal);
            document.querySelector('.total_sale').innerHTML = currency(subtotal);
        }

        // Cart Item Button
        document.addEventListener("DOMContentLoaded", function() {
            document.querySelectorAll(".optech-product-minus, .optech-product-plus").forEach(span => {
                span.addEventListener("click", function() {
                    const itemId = this.getAttribute("data-id");
                    const quantityElement = document.getElementById(`quantity-${itemId}`);
                    const priceElement = document.getElementById(`price-${itemId}`);
                    const unitPrice = parseFloat(priceElement.getAttribute('data-unit-price'));
                    let currentQuantity = parseInt(quantityElement.value);

                    if (this.classList.contains("optech-product-minus")) {
                        if (currentQuantity > 1) {
                            currentQuantity--;
                        } else {
                            toastr.error('Quantity must be at least 1');
                            return;
                        }
                    } else if (this.classList.contains("optech-product-plus")) {
                        currentQuantity++;
                    }

                    quantityElement.value = currentQuantity;

                    fetch(<?php echo json_encode(route('cart.update'), 15, 512) ?>, {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': document.querySelector(
                                    'meta[name="csrf-token"]').getAttribute('content')
                            },
                            body: JSON.stringify({
                                id: itemId,
                                quantity: currentQuantity
                            })
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                const newTotal = (unitPrice * currentQuantity).toFixed(2);
                                priceElement.innerHTML = currency(newTotal);
                                updateSubtotal();
                                toastr.success(data.notification.message);
                            } else {
                                if (data.notification) {
                                    toastr.error(data.notification.message);
                                }
                            }
                        })
                        .catch(error => {
                            console.error("Error:", error);
                        });
                });
            });
        });

        function currency(amount) {
            return new Intl.NumberFormat('<?php echo e(app()->getLocale()); ?>', {
                style: 'currency',
                currency: '<?php echo e(config('settings.currency_code', 'USD')); ?>'
            }).format(amount);
        }

        // Add click event listener to delete buttons
        document.querySelectorAll('.delete-cart-item').forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                const cartId = this.dataset.id;
                deleteCartItem(cartId);
            });
        });

        function deleteCartItem(id) {
            Swal.fire({
                title: "<?php echo e(__('translate.Are you really want to delete this item?')); ?>",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: "<?php echo e(__('translate.Yes, Delete It')); ?>",
                cancelButtonText: "<?php echo e(__('translate.Cancel')); ?>"
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire({
                        title: "<?php echo e(__('translate.Deleting..')); ?>",
                        allowOutsideClick: false,
                        showConfirmButton: false,
                        didOpen: () => {
                            Swal.showLoading();
                        }
                    });

                    fetch(`<?php echo e(url('cart/cart')); ?>/${id}`, {
                            method: 'DELETE',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                                'Accept': 'application/json',
                                'X-Requested-With': 'XMLHttpRequest'
                            }
                        })
                        .then(response => {
                            if (!response.ok) {
                                return response.json().then(json => Promise.reject(json));
                            }
                            return response.json();
                        })
                        .then(data => {
                            // Show the notification
                            Swal.close();

                            // Show success notification using toastr
                            if (data.success) {
                                toastr.success(data.notification.messege);
                                // Reload the page after successful deletion
                                setTimeout(() => {
                                    window.location.reload();
                                }, 1000);
                            } else {
                                toastr.error(data.notification.messege);
                            }
                        })
                        .catch(error => {
                            console.error('Error:', error);
                            // Close loading dialog
                            Swal.close();

                            // Show error notification using toastr
                            toastr.error(error.notification ? error.notification.messege :
                                "<?php echo e(__('translate.An error occurred while removing the item')); ?>");
                        });
                }
            });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout_inner_page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/slipinho/public_html/Modules/Ecommerce/Resources/views/frontend/cart.blade.php ENDPATH**/ ?>