<?php
$theme1_tour_package = getContent('theme1_tour_package.content', true);

$theme1_service = serviceTypeTab();
$theme1_popular_services = popularServices();

?>

<header class="tg-header-height">
    <div class="tg-header__area tg-header-lg-space z-index-999 tg-transparent" id="header-sticky">
        <div class="container container-1489">
            <div class="row align-items-center">
                <!-- Logo Column (Left) -->
                <div class="col-xl-2 col-lg-2 col-md-4 col-6">
                    <div class="logo">
                        <a class="logo-1" href="<?php echo e(route('home')); ?>">
                            <img src="<?php echo e(asset($general_setting->logo)); ?>" alt="Logo" class="header-logo">
                        </a>
                        <a class="logo-2 d-none" href="<?php echo e(route('home')); ?>">
                            <img src="<?php echo e(asset($general_setting->secondary_logo)); ?>" alt="Logo">
                        </a>
                    </div>
                </div>

                <!-- Navigation Column (Center) -->
                <div class="col-xl-8 col-lg-8 d-none d-xl-block">
                    <div class="tgmenu__wrap d-flex align-items-center justify-content-center">
                        <nav class="tgmenu__nav">
                            <div class="tgmenu__navbar-wrap tgmenu__main-menu">
                                <?php echo $__env->make('components.common_navitems', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </nav>
                    </div>
                </div>

                <!-- Action Column (Right: Login/Signup) -->
                <div class="col-xl-2 col-lg-2 col-md-8 col-6">
                    <div class="tg-menu-right-action d-flex align-items-center justify-content-end"
                        style="display: flex !important;">

                        <!-- Login/Dashboard Button -->
                        <div class="tg-header-btn ml-20 d-none d-md-block">
                            <?php if(auth()->guard('web')->guest()): ?>
                            <a class="tg-btn-header-login" href="<?php echo e(route('user.login')); ?>">
                                Login
                            </a>
                            <?php else: ?>
                            <a class="tg-btn-header-login"
                                href="<?php echo e(Auth::guard('web')->user()->is_seller == 1 ? route('agency.dashboard') : route('user.dashboard')); ?>">
                                Dashboard
                            </a>
                            <?php endif; ?>
                        </div>

                        <!-- Mobile Menu Toggle -->
                        <div class="tg-header-menu-bar lh-1 p-relative d-block d-xl-none" style="z-index: 9999;">
                            <button class="mobile-nav-toggler hamburger-btn ms-auto text-dark" type="button"
                                aria-label="Toggle Menu"
                                style="border: none; background: transparent; font-size: 24px;">
                                <i class="fa-solid fa-bars"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Menu  -->
    <?php echo $__env->make('components.common_mobile_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- End Mobile Menu -->

    <!-- offCanvas-menu -->
    <?php echo $__env->make('components.common_offcanvas', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- offCanvas-menu-end -->
</header>



<?php $__env->startPush('style_section'); ?>
<style>
    /* ===== Header Base Styles ===== */
    .tg-header__area {
        transition: all 0.3s ease-in-out;
    }

    /* Sticky Header Effect */
    .tg-header__area.sticky-active {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        background: #ffffff;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        padding: 5px 0;
        animation: slideDown 0.4s ease forwards;
        z-index: 9999;
    }

    @keyframes slideDown {
        from {
            transform: translateY(-100%);
            opacity: 0;
        }

        to {
            transform: translateY(0);
            opacity: 1;
        }
    }

    /* ===== Logo Styles ===== */
    .header-logo {
        max-width: 150px;
        height: auto;
        transition: transform 0.3s ease;
    }

    .logo:hover .header-logo {
        transform: scale(1.03);
    }

    /* Login / Signup Button Styles (EaseMyTrip Blue Pill) */
    .tg-btn-header-login {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        padding: 10px 24px;
        background-color: #2196f3;
        /* EaseMyTrip Blue */
        color: #ffffff !important;
        border-radius: 50px;
        font-weight: 700;
        font-size: 14px;
        text-decoration: none;
        transition: all 0.3s ease;
        box-shadow: 0 4px 10px rgba(33, 150, 243, 0.3);
        white-space: nowrap;
        line-height: normal;
    }

    .tg-btn-header-login:hover {
        background-color: #1976d2;
        transform: translateY(-2px);
        box-shadow: 0 6px 15px rgba(33, 150, 243, 0.4);
        color: #ffffff !important;
    }

    /* Hamburger Menu Button */
    .hamburger-btn {
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        width: 30px;
        height: 22px;
        background: transparent;
        border: none;
        cursor: pointer;
        padding: 0;
        z-index: 100;
    }

    .hamburger-line {
        display: block;
        width: 100%;
        height: 3px;
        background-color: #1e293b;
        /* Enforce dark color explicitly */
        border-radius: 3px;
        transition: all 0.3s ease;
    }

    .hamburger-btn:hover .hamburger-line {
        background-color: var(--tg-theme-primary, #0D6EFD);
    }

    .hamburger-btn.active .hamburger-line:nth-child(1) {
        transform: translateY(9px) rotate(45deg);
    }

    .hamburger-btn.active .hamburger-line:nth-child(2) {
        opacity: 0;
    }

    .hamburger-btn.active .hamburger-line:nth-child(3) {
        transform: translateY(-9px) rotate(-45deg);
    }

    /* Centered Navigation */
    .tgmenu__main-menu {
        justify-content: center;
    }

    .tgmenu__main-menu ul li {
        margin: 0 15px;
    }

    /* Responsive */
    @media (max-width: 767px) {
        .header-logo {
            max-width: 140px !important;
        }

        .tg-header-btn {
            margin-left: 10px !important;
        }

        .tg-btn-header-login {
            padding: 8px 16px;
            font-size: 13px;
        }
    }

    /* Package Card Modern */
    .package-card-modern {
        position: relative;
        border-radius: 28px;
        overflow: hidden;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        background: transparent;
    }

    .package-card-modern:hover {
        transform: translateY(-8px);
    }

    /* Image Container */
    .package-image-container {
        position: relative;
        width: 100%;
        height: 316px;
        border-radius: 28px;
        overflow: hidden;
    }

    .package-image-link {
        display: block;
        width: 100%;
        height: 100%;
    }

    .package-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.6s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .package-card-modern:hover .package-image {
        transform: scale(1.08);
    }

    /* Overlay Gradient */
    .package-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(to bottom,
                rgba(0, 0, 0, 0) 0%,
                rgba(0, 0, 0, 0.1) 40%,
                rgba(0, 0, 0, 0.7) 100%);
        z-index: 1;
    }

    /* Wishlist Icon (Top Left) */
    .package-wishlist-icon {
        position: absolute;
        top: 20px;
        left: 20px;
        width: 45px;
        height: 45px;
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(10px);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: all 0.3s ease;
        z-index: 3;
        color: #666;
    }

    .package-wishlist-icon:hover {
        background: #ffffff;
        transform: scale(1.1);
    }

    .package-wishlist-icon.active {
        color: #ff6b6b;
    }

    .package-wishlist-icon a {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 100%;
        height: 100%;
    }

    .package-wishlist-icon svg {
        width: 22px;
        height: 22px;
    }

    /* Airplane Icon (Top Right) */
    .package-airplane-icon {
        position: absolute;
        top: 20px;
        right: 20px;
        width: 60px;
        height: 60px;
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 3;
        opacity: 0.15;
        color: #ffffff;
    }

    .package-airplane-icon svg {
        width: 100%;
        height: 100%;
        stroke: currentColor;
    }

    /* Bottom Content on Image */
    .package-bottom-content {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        padding: 30px;
        z-index: 2;
        background: linear-gradient(to top, rgba(0, 0, 0, 0.4), transparent);
    }

    .package-title {
        margin: 0 0 8px 0;
        font-size: 19px;
        font-weight: 700;
        line-height: 1.3;
    }

    .package-title a {
        color: #ffffff;
        text-decoration: none;
        text-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
        transition: opacity 0.3s ease;
    }

    .package-title a:hover {
        opacity: 0.9;
    }

    /* Footer Info (Price + Explore) */
    .package-footer-info {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .package-price-section {
        display: flex;
        flex-direction: column;
        gap: 2px;
    }

    .price-from {
        font-size: 14px;
        color: rgba(255, 255, 255, 0.9);
        font-weight: 500;
        text-shadow: 0 1px 3px rgba(0, 0, 0, 0.2);
    }

    .price-amount {
        font-size: 22px;
        font-weight: 800;
        color: #ffffff;
        line-height: 1;
        text-shadow: 0 2px 8px rgba(0, 0, 0, 0.3);
    }

    .price-amount del {
        font-size: 18px;
        color: rgba(255, 255, 255, 0.7);
        font-weight: 500;
        margin-right: 8px;
    }

    /* Explore Link/Button */
    .package-explore-link {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 12px 28px;
        background: #007bff;
        color: #ffffff;
        border-radius: 30px;
        text-decoration: none;
        font-weight: 600;
        font-size: 15px;
        transition: all 0.3s ease;
        box-shadow: 0 4px 15px rgba(0, 123, 255, 0.3);
        display: none;
    }

    .package-explore-link:hover {
        background: #0056b3;
        color: #ffffff;
        transform: translateX(4px);
        box-shadow: 0 6px 20px rgba(0, 123, 255, 0.4);
    }

    .package-explore-link svg {
        width: 14px;
        height: 14px;
        transition: transform 0.3s ease;
    }

    .package-explore-link:hover svg {
        transform: translateX(3px);
    }

    /* Badges Group */
    .package-badges-group {
        position: absolute;
        top: 20px;
        left: 50%;
        transform: translateX(-50%);
        display: flex;
        gap: 8px;
        z-index: 3;
        display: none;
    }

    .package-badge {
        display: inline-flex;
        align-items: center;
        gap: 4px;
        padding: 6px 14px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        backdrop-filter: blur(10px);
        color: #ffffff;
    }

    .badge-new {
        background: rgba(76, 175, 80, 0.95);
    }

    .badge-sale {
        background: rgba(244, 67, 54, 0.95);
    }

    .badge-featured {
        background: rgba(255, 152, 0, 0.95);
    }

    .package-badge svg {
        width: 10px;
        height: 10px;
    }

    /* Responsive Design */
    @media (max-width: 1199px) {
        .package-image-container {
            height: 420px;
        }

        .package-title {
            font-size: 24px;
        }

        .price-amount {
            font-size: 26px;
        }
    }

    @media (max-width: 991px) {
        .package-image-container {
            height: 400px;
            border-radius: 24px;
        }

        .package-card-modern {
            border-radius: 24px;
        }

        .package-title {
            font-size: 22px;
        }

        .price-amount {
            font-size: 24px;
        }

        .package-bottom-content {
            padding: 25px;
        }
    }

    @media (max-width: 767px) {
        .package-image-container {
            height: 380px;
            border-radius: 22px;
        }

        .package-card-modern {
            border-radius: 22px;
        }

        .package-title {
            font-size: 20px;
        }

        .price-amount {
            font-size: 22px;
        }

        .package-bottom-content {
            padding: 22px;
        }

        .package-explore-link {
            padding: 10px 24px;
            font-size: 14px;
        }

        .package-airplane-icon {
            width: 50px;
            height: 50px;
        }
    }

    @media (max-width: 575px) {
        .package-image-container {
            height: 350px;
            border-radius: 20px;
        }

        .package-card-modern {
            border-radius: 20px;
            margin-bottom: 20px;
        }

        .package-title {
            font-size: 18px;
            margin-bottom: 16px;
        }

        .price-amount {
            font-size: 20px;
        }

        .package-bottom-content {
            padding: 20px;
        }

        .package-explore-link {
            padding: 9px 20px;
            font-size: 13px;
        }

        .package-wishlist-icon {
            width: 40px;
            height: 40px;
            top: 16px;
            left: 16px;
        }

        .package-airplane-icon {
            width: 45px;
            height: 45px;
            top: 16px;
            right: 16px;
        }

        .package-badges-group {
            top: 16px;
        }
    }

    @media (min-width: 1200px) {
        .d-xl-none {
            display: none !important;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js_section'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        var header = document.getElementById('header-sticky');
        if (header) {
            window.addEventListener('scroll', function () {
                if (window.scrollY > 50) {
                    header.classList.add('sticky-active');
                    header.classList.remove('tg-transparent');
                } else {
                    header.classList.remove('sticky-active');
                    header.classList.add('tg-transparent');
                }
            });
        }
        var hamburgerBtn = document.querySelector('.hamburger-btn');
        if (hamburgerBtn) {
            hamburgerBtn.addEventListener('click', function () {
                this.classList.toggle('active');
            });
        }
    });
</script>
<script src="<?php echo e(asset('frontend/assets/js/cart.js')); ?>"></script>
<?php $__env->stopPush(); ?><?php /**PATH /home/slipinho/public_html/Cms/themes/theme1/views/components/header.blade.php ENDPATH**/ ?>