

<?php $__env->startSection('title'); ?>
<title><?php echo e($seo_setting->seo_title); ?></title>
<meta name="title" content="<?php echo e($seo_setting->seo_title); ?>" />
<meta name="description" content="<?php echo strip_tags(clean($seo_setting->seo_description)); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('front-content'); ?>
<?php echo $__env->make('breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="tg-blog-grid-area pt-130 pb-100">
    <div class="container">
        <div class="row">
            <div class="col-xl-9 col-lg-8">
                <div class="tg-blog-grid-wrap tg-blog-lg-spacing mr-50">
                    <div class="row">
                        <?php $__empty_1 = true; $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="col-xl-6 col-lg-12 col-md-6">
                            <div class="blog-overlay-card mb-40">
                                <!-- Image Section -->
                                <div class="blog-img-wrapper">
                                    <a href="<?php echo e(route('blog', $blog->slug)); ?>">
                                        <img src="<?php echo e(asset($blog->image)); ?>" alt="<?php echo e($blog?->translate?->title); ?>">
                                    </a>
                                    <!-- Floating Badge -->
                                    <span class="category-badge">
                                        <?php echo e($blog?->category?->name ?? 'Activities'); ?>

                                    </span>
                                </div>

                                <!-- Content Section (Overlapping) -->
                                <div class="blog-content-wrapper">
                                    <!-- Meta Lines -->
                                    <div class="blog-meta-list">
                                        <span class="meta-item">
                                            <i class="fa-regular fa-calendar"></i>
                                            <?php echo e($blog->created_at->format('F d, Y')); ?>

                                        </span>
                                        <span class="meta-item">
                                            <i class="fa-regular fa-comment"></i>
                                            <?php echo e($blog->comments_count ?? 1); ?> Comment
                                        </span>
                                    </div>

                                    <!-- Title -->
                                    <h3 class="blog-title">
                                        <a href="<?php echo e(route('blog', $blog->slug)); ?>">
                                            <?php echo e(Str::limit($blog?->translate?->title, 60)); ?>

                                        </a>
                                    </h3>

                                    <!-- Footer: Author + Button -->
                                    <div class="blog-card-footer">
                         

                                        <a href="<?php echo e(route('blog', $blog->slug)); ?>" class="keep-reading-btn">
                                            Keep Reading
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="col-12">
                            <div class="courses_not_found_main">
                                <div class="courses_not_found_thumb">
                                    <img src="<?php echo e(asset($general_setting->not_found ?? '')); ?>" alt="thumb">
                                </div>
                                <div class="courses_not_found_text">
                                    <h3><?php echo e(__('translate.OOPS! Blog not Found')); ?></h3>
                                    <p><?php echo e(__('translate.Oops! this information is not available for a moment')); ?></p>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="tg-pagenation-wrap text-center pt-80 mb-30">
                        <nav>
                            <?php if($blogs->hasPages()): ?>
                            <?php echo e($blogs->links('custom_pagination')); ?>

                            <?php endif; ?>
                        </nav>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4">
                <?php echo $__env->make('components.common_blog_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style_section'); ?>
<style>
    /* =========================================
       OVERLAY BLOG CARD STYLES
       ========================================= */
    .blog-overlay-card {
        position: relative;
        /* No overall background, the parts have it */
    }

    /* Image Wrapper */
    .blog-img-wrapper {
        position: relative;
        border-radius: 20px;
        overflow: hidden;
        height: 250px;
        /* Base height */
        z-index: 1;
    }

    .blog-img-wrapper img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.5s ease;
    }

    .blog-overlay-card:hover .blog-img-wrapper img {
        transform: scale(1.05);
        /* Zoom effect */
    }

    /* Top Left Badge */
    .category-badge {
        position: absolute;
        top: 20px;
        left: 20px;
        background: #fff;
        padding: 5px 15px;
        border-radius: 30px;
        font-size: 13px;
        font-weight: 700;
        color: #1e293b;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        z-index: 2;
    }

    /* Content Wrapper (The Overlap) */
    .blog-content-wrapper {
        position: relative;
        background: #fff;
        margin: 0 15px;
        /* Inset from sides */
        margin-top: -50px;
        /* The Overlap Magic */
        padding: 25px;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
        z-index: 2;
        /* Sit on top of image */
        border: 1px solid rgba(0, 0, 0, 0.02);
    }

    /* Meta */
    .blog-meta-list {
        display: flex;
        gap: 15px;
        margin-bottom: 12px;
        font-size: 13px;
        color: #64748b;
    }

    .blog-meta-list .meta-item i {
        margin-right: 5px;
        color: #94a3b8;
    }

    /* Title */
    .blog-title {
        font-size: 18px;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 20px;
        line-height: 1.4;
    }

    .blog-title a {
        color: inherit;
        text-decoration: none;
        transition: color 0.3s;
    }

    .blog-title a:hover {
        color: var(--tg-theme-primary, #3b82f6);
    }

    /* Footer */
    .blog-card-footer {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding-top: 5px;
    }

    /* Author */
    .blog-author {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .blog-author img {
        width: 32px;
        height: 32px;
        border-radius: 50%;
        object-fit: cover;
    }

    .blog-author span {
        font-size: 14px;
        font-weight: 600;
        color: #1e293b;
    }

    /* Keep Reading Button */
    .keep-reading-btn {
        background: #f1f5f9;
        color: #1e293b;
        padding: 8px 16px;
        border-radius: 30px;
        font-size: 13px;
        font-weight: 600;
        text-decoration: none;
        transition: all 0.3s;
    }

    .keep-reading-btn:hover {
        background: #e2e8f0;
        color: #0f172a;
    }
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layout_inner_page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/slipinho/public_html/resources/views/blogs.blade.php ENDPATH**/ ?>