<?php
$home1_banner = getContent('theme1_banner.content', true);
?>


<?php if(!empty($home1_banner)): ?>
<!-- tg-banner-area-start -->
<style>
    .new-banner-area {
        position: relative;
        height: 272px;
        /* Fixed height as requested */
        padding: 0;
        /* Remove padding to fit fixed height */
        background: radial-gradient(circle at 30% 50%, #004e82 0%, #002e4d 100%);
        overflow: hidden;
        border-radius: 15px;
        margin: 20px 0;
        display: flex;
        align-items: center;
    }

    .new-banner-bg {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-size: cover;
        background-position: center;
        opacity: 0.1;
        z-index: 0;
    }

    .new-banner-content {
        position: relative;
        z-index: 2;
        padding-right: 10px;
        color: #fff;
    }

    .new-banner-subtitle {
        font-family: 'Brush Script MT', cursive;
        font-size: 1.8rem;
        /* Reduced from 3rem */
        color: #fff;
        margin-bottom: 5px;
        display: block;
    }

    .new-banner-title {
        font-size: 1.6rem;
        /* Reduced from 2.5rem */
        font-weight: 700;
        color: #fff;
        margin-bottom: 10px;
        line-height: 1.1;
    }

    .new-banner-desc {
        font-size: 0.9rem;
        /* Reduced from 1.1rem */
        color: rgba(255, 255, 255, 0.9);
        margin-bottom: 15px;
        max-width: 400px;
        line-height: 1.3;
    }

    .new-banner-btn {
        background-color: #e65c00;
        color: white;
        padding: 8px 20px;
        /* Reduced padding */
        border-radius: 50px;
        font-weight: 600;
        font-size: 0.9rem;
        /* Reduced font size */
        text-decoration: none;
        transition: transform 0.3s ease, background 0.3s ease;
        display: inline-block;
    }

    .new-banner-btn:hover {
        background-color: #ff6a00;
        transform: translateY(-2px);
        color: white;
    }

    /* Collage Styles */
    .banner-collage {
        position: relative;
        height: 272px;
        /* Match banner height */
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 2;
    }

    .collage-card {
        position: relative;
        border-radius: 10px;
        /* Smaller radius */
        overflow: hidden;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
        border: 2px solid rgba(255, 255, 255, 0.2);
        transition: transform 0.3s ease;
    }

    .collage-card img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    /* Left Card */
    .card-left {
        width: 100px;
        /* Reduced from 160 */
        height: 140px;
        /* Reduced from 220 */
        transform: rotate(-5deg) translateX(20px) scale(0.9);
        z-index: 1;
    }

    /* Center Card */
    .card-center {
        width: 130px;
        /* Reduced from 200 */
        height: 180px;
        /* Reduced from 280 */
        z-index: 3;
        transform: translateY(-5px);
        border: 3px solid #fff;
    }

    /* Right Card */
    .card-right {
        width: 110px;
        /* Reduced from 170 */
        height: 150px;
        /* Reduced from 240 */
        transform: rotate(5deg) translateX(-20px) scale(0.95);
        z-index: 2;
    }

    /* Decorations */
    .rating-badge {
        position: absolute;
        top: 30px;
        left: -10px;
        background: white;
        padding: 3px 10px;
        border-radius: 15px;
        box-shadow: 0 3px 10px rgba(0, 0, 0, 0.1);
        z-index: 4;
        display: flex;
        gap: 2px;
        font-size: 8px;
        /* Reduced size */
        color: #f4b400;
    }

    .heart-badge {
        position: absolute;
        bottom: 50px;
        left: 30px;
        background: #ff5a5f;
        width: 25px;
        /* Reduced size */
        height: 25px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        box-shadow: 0 3px 10px rgba(0, 0, 0, 0.2);
        z-index: 4;
        font-size: 12px;
    }

    /* Video Play Button on Center Card */
    .video-play-btn {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        width: 35px;
        /* Reduced size */
        height: 35px;
        background: rgba(255, 255, 255, 0.8);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s;
        cursor: pointer;
    }

    .video-play-btn:hover {
        background: #fff;
        transform: translate(-50%, -50%) scale(1.1);
    }

    .video-play-btn svg {
        fill: #004e82;
        width: 12px;
        height: 12px;
        margin-left: 2px;
    }
</style>

<div class="container">
    <div class="new-banner-area">
        <!-- Optional: Use dynamic background as a texture overlay -->
        <div class="new-banner-bg"
            style="background-image: url('<?php echo e(asset(getSingleImage($home1_banner, 'background_image'))); ?>');"></div>

        <div class="container h-100">
            <div class="row h-100 align-items-center">
                <!-- Left Column: Content -->
                <div class="col-lg-6 offset-lg-1">
                    <div class="new-banner-content">
                        <span class="new-banner-subtitle"><?php echo e(getTranslatedValue($home1_banner, 'sub_title')); ?></span>
                        <h2 class="new-banner-title"><?php echo e(getTranslatedValue($home1_banner, 'title')); ?></h2>

                        <!-- Static description as originally there was none in DB, but design has it -->
                        <p class="new-banner-desc">
                            Read stories from travellers who trusted us to craft their perfect journeys!
                        </p>

                        <a href="<?php echo e(getTranslatedValue($home1_banner, 'button_url')); ?>" class="new-banner-btn">
                            <?php echo e(getTranslatedValue($home1_banner, 'button_text')); ?>

                        </a>
                    </div>
                </div>

                <!-- Right Column: Image Collage -->
                <div class="col-lg-5">
                    <div class="banner-collage">
                        <div class="heart-badge">
                            <i class="fas fa-heart"></i>
                        </div>

                        <!-- Card 1: Placeholder (using a generic texture or duplicate bg for now) -->
                        <div class="collage-card card-left">
                            <img src="https://images.unsplash.com/photo-1542314831-068cd1dbfeeb?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80"
                                alt="Travel">
                        </div>

                        <!-- Card 2: Main Dynamic Image used here -->
                        <div class="collage-card card-center">
                            <img src="<?php echo e(asset(getSingleImage($home1_banner, 'background_image'))); ?>"
                                alt="Main Experience">

                            <!-- Video Button Overlay -->
                            <a class="video-play-btn popup-video"
                                href="<?php echo e(getTranslatedValue($home1_banner, 'youtube_video_link')); ?>">
                                <svg viewBox="0 0 448 512" xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z" />
                                </svg>
                            </a>
                        </div>

                        <!-- Card 3: Placeholder -->
                        <div class="collage-card card-right">
                            <img src="https://images.unsplash.com/photo-1507525428034-b723cf961d3e?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&q=80"
                                alt="Travel">
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<span class="tg-banner-transparent-bg"></span>
<!-- tg-banner-area-end -->
<?php endif; ?><?php /**PATH C:\xampp\htdocs\slipinholidays\slipin\Cms/themes/theme1/views/components/banner.blade.php ENDPATH**/ ?>