<!DOCTYPE html>
<html class="no-js" lang="en">

<head>
    <!-- Meta Tags -->
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- Favicon Icon -->
    <link rel="shortcut icon" href="<?php echo e(asset($general_setting->favicon)); ?>" type="image/x-icon">
    <!-- Site Title -->
    <?php echo $__env->yieldContent('title'); ?>

    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/animate.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/magnific-popup.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/fontawesome-all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/swiper-bundle.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/flatpicker.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/odometer.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/default.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/main.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/dev.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/cookie_consent.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('global/toastr/toastr.min.css')); ?>">

    <?php echo $__env->yieldPushContent('style_section'); ?>


    <?php if($general_setting->google_analytic_status == 1): ?>
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e($general_setting->google_analytic_id); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }

            gtag('js', new Date());
            gtag('config', '<?php echo e($general_setting->google_analytic_id); ?>');
        </script>
    <?php endif; ?>


    <?php if($general_setting->pixel_status == 1): ?>
        <script>
            ! function(f, b, e, v, n, t, s) {
                if (f.fbq) return;
                n = f.fbq = function() {
                    n.callMethod ?
                        n.callMethod.apply(n, arguments) : n.queue.push(arguments)
                };
                if (!f._fbq) f._fbq = n;
                n.push = n;
                n.loaded = !0;
                n.version = '2.0';
                n.queue = [];
                t = b.createElement(e);
                t.async = !0;
                t.src = v;
                s = b.getElementsByTagName(e)[0];
                s.parentNode.insertBefore(t, s)
            }(window, document, 'script',
                'https://connect.facebook.net/en_US/fbevents.js');
            fbq('init', '<?php echo e($general_setting->pixel_app_id); ?>');
            fbq('track', 'PageView');
        </script>
        <noscript><img height="1" width="1" style="display:none"
                src="https://www.facebook.com/tr?id=<?php echo e($general_setting->pixel_app_id); ?>&ev=PageView&noscript=1" /></noscript>
    <?php endif; ?>


</head>

<body class="td_theme_2">
    <?php if($general_setting->preloader_status == 'enable'): ?>
        <!-- Start Preloader -->
        <div id="loading">
            <div class="loader"></div>
        </div>
        <!-- End Preloader -->
    <?php endif; ?>

    <!-- Start Header Section -->
    <?php echo $__env->make('theme::components.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- End Header Section -->

    <?php echo $__env->yieldContent('front-content'); ?>

    <!-- Start Footer Section -->
    <?php echo $__env->make('theme::components.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- End Footer Section -->

    <!-- Start Scroll Up Button -->
    <button class="scroll__top scroll-to-target" data-target="html">
        <i class="fa-sharp fa-regular fa-arrow-up"></i>
    </button>
    <!-- End Scroll Up Button -->


    <?php if($general_setting->tawk_status == 1): ?>
        <script type="text/javascript">
            var Tawk_API = Tawk_API || {},
                Tawk_LoadStart = new Date();
            (function() {
                var s1 = document.createElement("script"),
                    s0 = document.getElementsByTagName("script")[0];
                s1.async = true;
                s1.src = '<?php echo e($general_setting->tawk_chat_link); ?>';
                s1.charset = 'UTF-8';
                s1.setAttribute('crossorigin', '*');
                s0.parentNode.insertBefore(s1, s0);
            })();
        </script>
    <?php endif; ?>



    <?php if($general_setting->cookie_consent_status == 1): ?>
        <!-- common-modal start  -->
        <div class="common-modal cookie_consent_modal d-none bg-white">
            <button type="button" class="btn-close cookie_consent_close_btn" aria-label="Close"></button>

            <h5><?php echo e(__('translate.Cookies')); ?></h5>
            <p><?php echo e($general_setting->cookie_consent_message); ?></p>


            <a href="javascript:;"
                class="td_btn td_style_1 td_type_3 td_radius_30 td_medium td_fs_14 report-modal-btn cookie_consent_accept_btn">
                <span class="td_btn_in td_accent_color">
                    <span><?php echo e(__('translate.Accept')); ?></span>
                </span>
            </a>

        </div>
        <!-- common-modal end  -->
    <?php endif; ?>


    <!-- Script -->
    <script src="<?php echo e(asset('global/js/jquery-3.7.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/isotope.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/imagesloaded.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/jquery.odometer.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/jquery.appear.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/swiper-bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/flatpickr.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/nice-select.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/ajax-form.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/wow.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/main.js')); ?>"></script>
    <script src="<?php echo e(asset('global/toastr/toastr.min.js')); ?>"></script>


    <script>
        (function($) {
            "use strict"
            $(document).ready(function() {

                const session_notify_message = <?php echo json_encode(Session::get('message'), 15, 512) ?>;
                const demo_mode_message = <?php echo json_encode(Session::get('demo_mode'), 15, 512) ?>;

                if (session_notify_message != null) {
                    const session_notify_type = <?php echo json_encode(Session::get('alert-type', 'info'), 512) ?>;
                    switch (session_notify_type) {
                        case 'info':
                            toastr.info(session_notify_message);
                            break;
                        case 'success':
                            toastr.success(session_notify_message);
                            break;
                        case 'warning':
                            toastr.warning(session_notify_message);
                            break;
                        case 'error':
                            toastr.error(session_notify_message);
                            break;
                    }
                }

                if (demo_mode_message != null) {
                    toastr.warning(
                        "<?php echo e(__('translate.All Language keywords are not implemented in the demo mode')); ?>");
                    toastr.info("<?php echo e(__('translate.Admin can translate every word from the admin panel')); ?>");
                }

                const validation_errors = <?php echo json_encode($errors->all(), 15, 512) ?>;

                if (validation_errors.length > 0) {
                    validation_errors.forEach(error => toastr.error(error));
                }


                if (localStorage.getItem('tourex-cookie') != '1') {
                    $('.cookie_consent_modal').removeClass('d-none');
                }

                $('.cookie_consent_close_btn').on('click', function() {
                    $('.cookie_consent_modal').addClass('d-none');
                });

                $('.cookie_consent_accept_btn').on('click', function() {
                    localStorage.setItem('tourex-cookie', '1');
                    $('.cookie_consent_modal').addClass('d-none');
                });

                $('.before_auth_wishlist').on("click", function() {
                    toastr.error("<?php echo e(__('translate.Please login first')); ?>")
                });

                $(".currency_code").on('change', function() {
                    var currency_code = $(this).val();

                    window.location.href = "<?php echo e(route('currency-switcher')); ?>" + "?currency_code=" +
                        currency_code;
                });

                $(".language_code").on('change', function() {
                    var language_code = $(this).val();

                    window.location.href = "<?php echo e(route('language-switcher')); ?>" + "?lang_code=" +
                        language_code;
                });

            });
        })(jQuery);
    </script>


    <?php echo $__env->yieldPushContent('js_section'); ?>


</body>

</html>
<?php /**PATH /home/slipinho/public_html/Cms/themes/theme4/views/layouts/app.blade.php ENDPATH**/ ?>