<?php $__env->startSection('title'); ?>
    <title><?php echo e($seo_setting->seo_title); ?></title>
    <meta name="title" content="<?php echo e($seo_setting->seo_title); ?>">
    <meta name="description" content="<?php echo strip_tags(clean($seo_setting->seo_description)); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('front-content'); ?>
    <?php echo $__env->make('breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- tg-team-area-start -->
    <div class="tg-team-area pt-130 pb-100 p-relative z-index-1">
        <img class="tg-team-shape d-none d-md-block" src="<?php echo e(asset('frontend/assets/img/shape/hill.png')); ?>" alt="">
        <img class="tg-team-shape-2 d-none d-md-block" src="<?php echo e(asset('frontend/assets/img/shape/tree.png')); ?>" alt="">
        <div class="container">
            <div class="row">
                <?php $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $team): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
                        <div class="tg-team-wrap text-center mb-30">
                            <div class="tg-team-thumb p-relative">
                                <img class="hover-img" src="<?php echo e(asset($team->image)); ?>" alt="team">
                                <div class="tg-listing-2-mask">
                                    <img class="w-100" src="assets/img/listing/listing-2/shape.png" alt="">
                                </div>
                            </div>
                            <div class="tg-team-content">
                                <h5><a href="<?php echo e(route('teamPerson', $team->slug)); ?>"><?php echo e($team->translate->name); ?></a></h5>
                                <span><?php echo e($team->translate->designation); ?></span>
                                <div class="tg-team-social">
                                    <a target="_blank" href="<?php echo e($team->facebook); ?>"><i
                                            class="fa-brands fa-facebook-f"></i></a>
                                    <a target="_blank" href="<?php echo e($team->twitter); ?>"><i class="fa-brands fa-twitter"></i></a>
                                    <a target="_blank" href="<?php echo e($team->instagram); ?>"><i
                                            class="fa-brands fa-instagram"></i></a>
                                    <a target="_blank" href="<?php echo e($team->pinterest); ?>"><i
                                            class="fa-brands fa-pinterest-p"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
    <!-- tg-team-area-end -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout_inner_page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/slipinho/public_html/resources/views/teams.blade.php ENDPATH**/ ?>