<!DOCTYPE html>
<html class="no-js" lang="en">

<head>
    <!-- Meta Tags -->
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Favicon Icon -->
    <link rel="shortcut icon" href="<?php echo e(asset($general_setting->favicon)); ?>" type="image/x-icon">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- Site Title -->
    <?php echo $__env->yieldContent('title'); ?>

    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/animate.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/magnific-popup.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/fontawesome-all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/swiper-bundle.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/flatpicker.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/odometer.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/default.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/main.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/dev.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/cookie_consent.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/custom.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('global/toastr/toastr.min.css')); ?>">

    <?php echo $__env->yieldPushContent('style_section'); ?>


    <?php if($general_setting->google_analytic_status == 1): ?>
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e($general_setting->google_analytic_id); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());
            gtag('config', '<?php echo e($general_setting->google_analytic_id); ?>');
        </script>
    <?php endif; ?>


    <?php if($general_setting->pixel_status == 1): ?>
        <script>
            ! function(f, b, e, v, n, t, s) {
                if (f.fbq) return;
                n = f.fbq = function() {
                    n.callMethod ?
                        n.callMethod.apply(n, arguments) : n.queue.push(arguments)
                };
                if (!f._fbq) f._fbq = n;
                n.push = n;
                n.loaded = !0;
                n.version = '2.0';
                n.queue = [];
                t = b.createElement(e);
                t.async = !0;
                t.src = v;
                s = b.getElementsByTagName(e)[0];
                s.parentNode.insertBefore(t, s)
            }(window, document, 'script',
                'https://connect.facebook.net/en_US/fbevents.js');
            fbq('init', '<?php echo e($general_setting->pixel_app_id); ?>');
            fbq('track', 'PageView');
        </script>
        <noscript>
            <img height="1" width="1" style="display:none"
                src="https://www.facebook.com/tr?id=<?php echo e($general_setting->pixel_app_id); ?>&ev=PageView&noscript=1" /></noscript>
    <?php endif; ?>

</head>

<body class="td_theme_2">

    <?php if($general_setting->preloader_status == 'enable'): ?>
        <!-- Start Preloader -->
        <div id="loading">
            <div class="loader"></div>
        </div>
        <!-- End Preloader -->
    <?php endif; ?>

    <?php if($general_setting->preloader_status == 'enable'): ?>
        <!-- Scroll-top -->
        <button class="scroll__top scroll-to-target" data-target="html">
            <i class="fa-sharp fa-regular fa-arrow-up"></i>
        </button>
        <!-- Scroll-top-end-->
    <?php endif; ?>


    <!-- header-area -->

<header class="tg-header-height">
    <div class="tg-header__area tg-header-lg-space z-index-999 tg-transparent" id="header-sticky">
        <div class="container container-1489">
            <div class="row align-items-center">
                <!-- Logo Column (Left) -->
                <div class="col-xl-2 col-lg-2 col-md-4 col-6">
                    <div class="logo">
                        <a class="logo-1" href="<?php echo e(route('home')); ?>">
                            <img src="<?php echo e(asset($general_setting->logo)); ?>" alt="Logo" class="header-logo">
                        </a>
                        <a class="logo-2 d-none" href="<?php echo e(route('home')); ?>">
                            <img src="<?php echo e(asset($general_setting->secondary_logo)); ?>" alt="Logo">
                        </a>
                    </div>
                </div>

                <!-- Navigation Column (Center) -->
                <div class="col-xl-8 col-lg-8 d-none d-xl-block">
                    <div class="tgmenu__wrap d-flex align-items-center justify-content-center">
                        <nav class="tgmenu__nav">
                            <div class="tgmenu__navbar-wrap tgmenu__main-menu">
                                <?php echo $__env->make('components.common_navitems', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </nav>
                    </div>
                </div>

                <!-- Action Column (Right: Login/Signup) -->
                <div class="col-xl-2 col-lg-2 col-md-8 col-6">
                    <div class="tg-menu-right-action d-flex align-items-center justify-content-end"
                        style="display: flex !important;">

                        <!-- Login/Dashboard Button -->
                        <div class="tg-header-btn ml-20 d-none d-md-block">
                            <?php if(auth()->guard('web')->guest()): ?>
                            <a class="tg-btn-header-login" href="<?php echo e(route('user.login')); ?>">
                                Login 
                            </a>
                            <?php else: ?>
                            <a class="tg-btn-header-login"
                                href="<?php echo e(Auth::guard('web')->user()->is_seller == 1 ? route('agency.dashboard') : route('user.dashboard')); ?>">
                                Dashboard
                            </a>
                            <?php endif; ?>
                        </div>

                        <!-- Mobile Menu Toggle -->
                        <div class="tg-header-menu-bar lh-1 p-relative d-block d-xl-none" style="z-index: 9999;">
                            <button class="mobile-nav-toggler hamburger-btn ms-auto text-dark" type="button"
                                aria-label="Toggle Menu"
                                style="border: none; background: transparent; font-size: 24px;">
                                <i class="fa-solid fa-bars"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Menu  -->
    <?php echo $__env->make('components.common_mobile_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- End Mobile Menu -->

    <!-- offCanvas-menu -->
    <?php echo $__env->make('components.common_offcanvas', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- offCanvas-menu-end -->
</header>



<?php $__env->startPush('style_section'); ?>
<style>
    /* ===== Header Base Styles ===== */
    .tg-header__area {
        transition: all 0.3s ease-in-out;
    }

    /* Sticky Header Effect */
    .tg-header__area.sticky-active {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        background: #ffffff;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        padding: 5px 0;
        animation: slideDown 0.4s ease forwards;
        z-index: 9999;
    }

    @keyframes slideDown {
        from {
            transform: translateY(-100%);
            opacity: 0;
        }

        to {
            transform: translateY(0);
            opacity: 1;
        }
    }

    /* ===== Logo Styles ===== */
    .header-logo {
        max-width: 150px;
        height: auto;
        transition: transform 0.3s ease;
    }

    .logo:hover .header-logo {
        transform: scale(1.03);
    }

    /* Login / Signup Button Styles (EaseMyTrip Blue Pill) */
    .tg-btn-header-login {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        padding: 10px 24px;
        background-color: #2196f3;
        /* EaseMyTrip Blue */
        color: #ffffff !important;
        border-radius: 50px;
        font-weight: 700;
        font-size: 14px;
        text-decoration: none;
        transition: all 0.3s ease;
        box-shadow: 0 4px 10px rgba(33, 150, 243, 0.3);
        white-space: nowrap;
        line-height: normal;
    }

    .tg-btn-header-login:hover {
        background-color: #1976d2;
        transform: translateY(-2px);
        box-shadow: 0 6px 15px rgba(33, 150, 243, 0.4);
        color: #ffffff !important;
    }

    /* Hamburger Menu Button */
    .hamburger-btn {
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        width: 30px;
        height: 22px;
        background: transparent;
        border: none;
        cursor: pointer;
        padding: 0;
        z-index: 100;
    }

    .hamburger-line {
        display: block;
        width: 100%;
        height: 3px;
        background-color: #1e293b;
        /* Enforce dark color explicitly */
        border-radius: 3px;
        transition: all 0.3s ease;
    }

    .hamburger-btn:hover .hamburger-line {
        background-color: var(--tg-theme-primary, #0D6EFD);
    }

    .hamburger-btn.active .hamburger-line:nth-child(1) {
        transform: translateY(9px) rotate(45deg);
    }

    .hamburger-btn.active .hamburger-line:nth-child(2) {
        opacity: 0;
    }

    .hamburger-btn.active .hamburger-line:nth-child(3) {
        transform: translateY(-9px) rotate(-45deg);
    }

    /* Centered Navigation */
    .tgmenu__main-menu {
        justify-content: center;
    }

    .tgmenu__main-menu ul li {
        margin: 0 15px;
    }

    /* Responsive */
    @media (max-width: 767px) {
        .header-logo {
            max-width: 140px !important;
        }

        .tg-header-btn {
            margin-left: 10px !important;
        }

        .tg-btn-header-login {
            padding: 8px 16px;
            font-size: 13px;
        }
    }

    /* Package Card Modern */
    .package-card-modern {
        position: relative;
        border-radius: 28px;
        overflow: hidden;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        background: transparent;
    }

    .package-card-modern:hover {
        transform: translateY(-8px);
    }

    /* Image Container */
    .package-image-container {
        position: relative;
        width: 100%;
        height: 316px;
        border-radius: 28px;
        overflow: hidden;
    }

    .package-image-link {
        display: block;
        width: 100%;
        height: 100%;
    }

    .package-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.6s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .package-card-modern:hover .package-image {
        transform: scale(1.08);
    }

    /* Overlay Gradient */
    .package-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(to bottom,
                rgba(0, 0, 0, 0) 0%,
                rgba(0, 0, 0, 0.1) 40%,
                rgba(0, 0, 0, 0.7) 100%);
        z-index: 1;
    }

    /* Wishlist Icon (Top Left) */
    .package-wishlist-icon {
        position: absolute;
        top: 20px;
        left: 20px;
        width: 45px;
        height: 45px;
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(10px);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: all 0.3s ease;
        z-index: 3;
        color: #666;
    }

    .package-wishlist-icon:hover {
        background: #ffffff;
        transform: scale(1.1);
    }

    .package-wishlist-icon.active {
        color: #ff6b6b;
    }

    .package-wishlist-icon a {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 100%;
        height: 100%;
    }

    .package-wishlist-icon svg {
        width: 22px;
        height: 22px;
    }

    /* Airplane Icon (Top Right) */
    .package-airplane-icon {
        position: absolute;
        top: 20px;
        right: 20px;
        width: 60px;
        height: 60px;
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 3;
        opacity: 0.15;
        color: #ffffff;
    }

    .package-airplane-icon svg {
        width: 100%;
        height: 100%;
        stroke: currentColor;
    }

    /* Bottom Content on Image */
    .package-bottom-content {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        padding: 30px;
        z-index: 2;
        background: linear-gradient(to top, rgba(0, 0, 0, 0.4), transparent);
    }

    .package-title {
        margin: 0 0 8px 0;
        font-size: 19px;
        font-weight: 700;
        line-height: 1.3;
    }

    .package-title a {
        color: #ffffff;
        text-decoration: none;
        text-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
        transition: opacity 0.3s ease;
    }

    .package-title a:hover {
        opacity: 0.9;
    }

    /* Footer Info (Price + Explore) */
    .package-footer-info {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .package-price-section {
        display: flex;
        flex-direction: column;
        gap: 2px;
    }

    .price-from {
        font-size: 14px;
        color: rgba(255, 255, 255, 0.9);
        font-weight: 500;
        text-shadow: 0 1px 3px rgba(0, 0, 0, 0.2);
    }

    .price-amount {
        font-size: 22px;
        font-weight: 800;
        color: #ffffff;
        line-height: 1;
        text-shadow: 0 2px 8px rgba(0, 0, 0, 0.3);
    }

    .price-amount del {
        font-size: 18px;
        color: rgba(255, 255, 255, 0.7);
        font-weight: 500;
        margin-right: 8px;
    }

    /* Explore Link/Button */
    .package-explore-link {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 12px 28px;
        background: #007bff;
        color: #ffffff;
        border-radius: 30px;
        text-decoration: none;
        font-weight: 600;
        font-size: 15px;
        transition: all 0.3s ease;
        box-shadow: 0 4px 15px rgba(0, 123, 255, 0.3);
        display: none;
    }

    .package-explore-link:hover {
        background: #0056b3;
        color: #ffffff;
        transform: translateX(4px);
        box-shadow: 0 6px 20px rgba(0, 123, 255, 0.4);
    }

    .package-explore-link svg {
        width: 14px;
        height: 14px;
        transition: transform 0.3s ease;
    }

    .package-explore-link:hover svg {
        transform: translateX(3px);
    }

    /* Badges Group */
    .package-badges-group {
        position: absolute;
        top: 20px;
        left: 50%;
        transform: translateX(-50%);
        display: flex;
        gap: 8px;
        z-index: 3;
        display: none;
    }

    .package-badge {
        display: inline-flex;
        align-items: center;
        gap: 4px;
        padding: 6px 14px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        backdrop-filter: blur(10px);
        color: #ffffff;
    }

    .badge-new {
        background: rgba(76, 175, 80, 0.95);
    }

    .badge-sale {
        background: rgba(244, 67, 54, 0.95);
    }

    .badge-featured {
        background: rgba(255, 152, 0, 0.95);
    }

    .package-badge svg {
        width: 10px;
        height: 10px;
    }

    /* Responsive Design */
    @media (max-width: 1199px) {
        .package-image-container {
            height: 420px;
        }

        .package-title {
            font-size: 24px;
        }

        .price-amount {
            font-size: 26px;
        }
    }

    @media (max-width: 991px) {
        .package-image-container {
            height: 400px;
            border-radius: 24px;
        }

        .package-card-modern {
            border-radius: 24px;
        }

        .package-title {
            font-size: 22px;
        }

        .price-amount {
            font-size: 24px;
        }

        .package-bottom-content {
            padding: 25px;
        }
    }

    @media (max-width: 767px) {
        .package-image-container {
            height: 380px;
            border-radius: 22px;
        }

        .package-card-modern {
            border-radius: 22px;
        }

        .package-title {
            font-size: 20px;
        }

        .price-amount {
            font-size: 22px;
        }

        .package-bottom-content {
            padding: 22px;
        }

        .package-explore-link {
            padding: 10px 24px;
            font-size: 14px;
        }

        .package-airplane-icon {
            width: 50px;
            height: 50px;
        }
    }

    @media (max-width: 575px) {
        .package-image-container {
            height: 350px;
            border-radius: 20px;
        }

        .package-card-modern {
            border-radius: 20px;
            margin-bottom: 20px;
        }

        .package-title {
            font-size: 18px;
            margin-bottom: 16px;
        }

        .price-amount {
            font-size: 20px;
        }

        .package-bottom-content {
            padding: 20px;
        }

        .package-explore-link {
            padding: 9px 20px;
            font-size: 13px;
        }

        .package-wishlist-icon {
            width: 40px;
            height: 40px;
            top: 16px;
            left: 16px;
        }

        .package-airplane-icon {
            width: 45px;
            height: 45px;
            top: 16px;
            right: 16px;
        }

        .package-badges-group {
            top: 16px;
        }
    }

    @media (min-width: 1200px) {
        .d-xl-none {
            display: none !important;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js_section'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        var header = document.getElementById('header-sticky');
        if (header) {
            window.addEventListener('scroll', function () {
                if (window.scrollY > 50) {
                    header.classList.add('sticky-active');
                    header.classList.remove('tg-transparent');
                } else {
                    header.classList.remove('sticky-active');
                    header.classList.add('tg-transparent');
                }
            });
        }
        var hamburgerBtn = document.querySelector('.hamburger-btn');
        if (hamburgerBtn) {
            hamburgerBtn.addEventListener('click', function () {
                this.classList.toggle('active');
            });
        }
    });
</script>
<script src="<?php echo e(asset('frontend/assets/js/cart.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<!-- Header Styles & Effects -->
<style>
    /* ===== Header Base Styles ===== */
    .tg-header__area {
        transition: all 0.3s ease-in-out;
    }

    /* Sticky Header Effect */
    .tg-header__area.sticky-active {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        background: #ffffff;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        padding: 10px 0;
        animation: slideDown 0.4s ease forwards;
        z-index: 9999;
    }

    @keyframes slideDown {
        from {
            transform: translateY(-100%);
            opacity: 0;
        }

        to {
            transform: translateY(0);
            opacity: 1;
        }
    }

    /* ===== Logo Styles ===== */
    .header-logo {
        max-width: 180px;
        height: auto;
        transition: transform 0.3s ease;
    }

    .logo:hover .header-logo {
        transform: scale(1.03);
    }

    /* Responsive logo sizing */
    @media (max-width: 767px) {
        .header-logo {
            max-width: 165px !important;
                    margin-top: 14px !important;
        }
        .tg-menu-right-action{margin-top: 15px !important;}
    }

    @media (max-width: 575px) {
        .header-logo {
            max-width: 100px;
        }
    }

    /* ===== Phone Link Hover ===== */
    .phone-link {
        transition: color 0.3s ease;
    }

    .phone-link:hover {
        color: var(--tg-theme-primary, #0D6EFD) !important;
    }

    /* ===== Header Button Effects ===== */


    /* ===== Hamburger Menu Button ===== */
    .hamburger-btn {
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        width: 30px;
        height: 22px;
        background: transparent;
        border: none;
        cursor: pointer;
        padding: 0;
        z-index: 100;
    }

    .hamburger-line {
        display: block;
        width: 100%;
        height: 3px;
        background-color: var(--tg-heading-color, #1e293b);
        border-radius: 3px;
        transition: all 0.3s ease;
    }

    .hamburger-btn:hover .hamburger-line {
        background-color: var(--tg-theme-primary, #0D6EFD);
    }

    /* Hamburger Animation on Active */
    .hamburger-btn.active .hamburger-line:nth-child(1) {
        transform: translateY(9px) rotate(45deg);
    }

    .hamburger-btn.active .hamburger-line:nth-child(2) {
        opacity: 0;
    }

    .hamburger-btn.active .hamburger-line:nth-child(3) {
        transform: translateY(-9px) rotate(-45deg);
    }

    /* ===== Navigation Link Effects ===== */


    .tgmenu__main-menu a:hover::after {
        width: 100%;
    }

    /* ===== Responsive Fixes ===== */
    @media (max-width: 1199px) {
        .tg-header-menu-bar {
            display: flex !important;
            align-items: center;
        }
    }

    @media (max-width: 991px) {
        .tg-header-btn {
            margin-left: 10px !important;
        }
    }

    @media (max-width: 767px) {
        .tg-header-btn .tg-btn-header {
            padding: 8px 12px;
            font-size: 14px;
        }

        .tg-header-btn .tg-btn-header span {
            display: none;
        }
    }
</style>

<!-- Sticky Header Script -->
<script>
    document.addEventListener('DOMContentLoaded', function () {
        var header = document.getElementById('header-sticky');

        // Sticky Header on Scroll
        if (header) {
            window.addEventListener('scroll', function () {
                if (window.scrollY > 100) {
                    header.classList.add('sticky-active');
                    header.classList.remove('tg-transparent');
                } else {
                    header.classList.remove('sticky-active');
                    header.classList.add('tg-transparent');
                }
            });
        }

        // Hamburger button toggle animation
        var hamburgerBtn = document.querySelector('.hamburger-btn');
        if (hamburgerBtn) {
            hamburgerBtn.addEventListener('click', function () {
                this.classList.toggle('active');
            });
        }
    });
</script>

    <!-- header-area-end -->
    <?php echo $__env->yieldContent('front-content'); ?>


    <!-- footer-area-start -->
   <style>
    .dark-footer {
        background-color: #0b1120;
        color: #e2e8f0;
        padding-top: 80px;
        font-family: 'Inter', sans-serif;
    }

    .footer-container {
        max-width: 1400px;
        margin: 0 auto;
        padding: 0 20px;
    }

    .footer-widget-title {
        color: #fff;
        font-size: 20px;
        font-weight: 700;
        margin-bottom: 25px;
        position: relative;
        display: inline-block;
        padding-bottom: 10px;
    }

    .footer-widget-title::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 100%;
        height: 2px;
        background-color: #31b8e6;
        /* Teal accent */
    }

    .footer-logo img {
        max-height: 50px;
        margin-bottom: 20px;
    }

    .footer-text {
        color: #94a3b8;
        line-height: 1.6;
        margin-bottom: 25px;
        font-size: 15px;
    }

    /* Form Styles */
    .newsletter-form {
        position: relative;
        margin-bottom: 25px;
    }

    .newsletter-input {
        width: 100%;
        padding: 12px 15px;
        background-color: rgba(255, 255, 255, 0.05);
        border: 1px solid #1e293b;
        border-radius: 6px;
        color: #fff;
        outline: none;
        transition: border-color 0.3s;
    }

    .newsletter-input:focus {
        border-color: #31b8e6;
    }

    .newsletter-btn {
        position: absolute;
        right: 5px;
        top: 5px;
        background-color: #31b8e6;
        border: none;
        width: 38px;
        height: 38px;
        border-radius: 4px;
        color: #0f172a;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: background 0.3s;
    }

    .newsletter-btn:hover {
        background-color: #14b8a6;
    }

    /* Social Icons */
    .social-links {
        display: flex;
        gap: 15px;
    }

    .social-icon {
        width: 36px;
        height: 36px;
        background-color: rgba(255, 255, 255, 0.1);
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 6px;
        color: #fff;
        transition: all 0.3s;
        text-decoration: none;
    }

    .social-icon:hover {
        background-color: #31b8e6;
        color: #0f172a;
        transform: translateY(-3px);
    }

    /* Links */
    .footer-menu ul {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .footer-menu li {
        margin-bottom: 12px;
    }

    .footer-menu a {
        color: #cbd5e1;
        text-decoration: none;
        transition: color 0.3s;
        display: block;
        font-size: 15px;
    }

    .footer-menu a:hover {
        color: #31b8e6;
        padding-left: 5px;
    }

    /* Contact Info */
    .contact-item {
        display: flex;
        gap: 15px;
        margin-bottom: 20px;
        color: #cbd5e1;
    }

    .contact-icon {
        color: #31b8e6;
        margin-top: 5px;
        flex-shrink: 0;
    }

    .contact-item a {
        color: #cbd5e1;
        text-decoration: none;
        transition: color 0.3s;
    }

    .contact-item a:hover {
        color: #31b8e6;
    }

    /* Footer Bottom */
    .footer-bottom {
        border-top: 1px solid #1e293b;
        padding: 30px 0;
        text-align: center;
        margin-top: 60px;
        background-color: #0f172a;
    }

    .copyright-text {
        font-size: 14px;
        color: #64748b;
    }

    .copyright-highlight {
        color: #31b8e6;
    }
</style>

<footer class="dark-footer">
    <div class="footer-container">
        <div class="row">
            <!-- Col 1: Logo, About, social -->
            <div class="col-lg-3 col-md-6 mb-5">
                <div class="footer-widget">
                    <div class="footer-logo">
                        <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset($general_setting->footer_logo)); ?>"
                                alt="Logo"></a>
                    </div>
                    <p class="footer-text"><?php echo e(Str::limit($footer->about_us, 150)); ?></p>

                    <div class="newsletter-form d-none">
                        <form action="<?php echo e(route('store-newsletter')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="email" class="newsletter-input" placeholder="Enter your mail" name="email">
                            <button class="newsletter-btn" type="submit">
                                <i class="fa-solid fa-paper-plane"></i>
                            </button>
                        </form>
                    </div>

                    <div class="social-links">
                        <?php if($footer->facebook): ?>
                        <a href="<?php echo e($footer->facebook); ?>" class="social-icon"><i
                                class="fa-brands fa-facebook-f"></i></a>
                        <?php endif; ?>
                        <?php if($footer->twitter): ?>
                        <a href="<?php echo e($footer->twitter); ?>" class="social-icon"><i class="fa-brands fa-twitter"></i></a>
                        <?php endif; ?>
                        <?php if($footer->instagram): ?>
                        <a href="<?php echo e($footer->instagram); ?>" class="social-icon"><i
                                class="fa-brands fa-instagram"></i></a>
                        <?php endif; ?>
                        <?php if($footer->linkedin): ?>
                        <a href="<?php echo e($footer->linkedin); ?>" class="social-icon"><i
                                class="fa-brands fa-linkedin-in"></i></a>
                        <?php endif; ?>
                        <?php if($footer->youtube): ?>
                        <a href="<?php echo e($footer->youtube); ?>" class="social-icon"><i class="fa-brands fa-youtube"></i></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Col 2: Services (Menu 1) -->
            <div class="col-lg-3 col-md-6 mb-5">
                <div class="footer-widget ml-lg-5">
                    <h3 class="footer-widget-title"><?php echo e(__('translate.Quick Links')); ?></h3>
                    <div class="footer-menu">
                        <?php echo wp_nav_menu([
                        'theme_location' => 'footer_menu_1',
                        'menu_class' => '',
                        'container' => false,
                        'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                        ]); ?>

                    </div>
                </div>
            </div>

            <!-- Col 3: Specialties (Menu 2) -->
            <div class="col-lg-3 col-md-6 mb-5">
                <div class="footer-widget">
                    <h3 class="footer-widget-title"><?php echo e(__('translate.Utility Pages')); ?></h3>
                    <div class="footer-menu">
                        <?php echo wp_nav_menu([
                        'theme_location' => 'footer_menu_2',
                        'menu_class' => '',
                        'container' => false,
                        'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                        ]); ?>

                    </div>
                </div>
            </div>

            <!-- Col 4: Contact Info -->
            <div class="col-lg-3 col-md-6 mb-5">
                <div class="footer-widget">
                    <h3 class="footer-widget-title"><?php echo e(__('translate.Information')); ?></h3>

                    <div class="contact-info">
                        <?php if($footer->address || $footer->address_url): ?>
                        <div class="contact-item">
                            <div class="contact-icon">
                                <i class="fa-solid fa-location-dot"></i>
                            </div>
                            <div>
                                <a href="<?php echo e($footer->address_url); ?>"><?php echo e($footer->address); ?></a>
                            </div>
                        </div>
                        <?php endif; ?>

                        <?php if($footer->phone): ?>
                        <div class="contact-item">
                            <div class="contact-icon">
                                <i class="fa-solid fa-phone"></i>
                            </div>
                            <div>
                                <a href="tel:<?php echo e($footer->phone); ?>"><?php echo e($footer->phone); ?></a>
                            </div>
                        </div>
                        <?php endif; ?>

                        <?php if($footer->working_days): ?>
                        <div class="contact-item">
                            <div class="contact-icon">
                                <i class="fa-solid fa-clock"></i>
                            </div>
                            <div>
                                <?php echo e($footer->working_days); ?>

                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="footer-bottom">
        <div class="container">
            <p class="copyright-text">
                <?php echo e($footer->copyright); ?>Developed By <a href="https://elyspace.com/web-design" class="elyspace">ElySpace</a>
                | <span class="copyright-highlight">Professional • Trusted • Travel</span>
            </p>
        </div>
    </div>
</footer>
    <!-- footer-area-end -->

    <?php if($general_setting->tawk_status == 1): ?>
        <script type="text/javascript">
            var Tawk_API = Tawk_API || {},
                Tawk_LoadStart = new Date();
            (function() {
                var s1 = document.createElement("script"),
                    s0 = document.getElementsByTagName("script")[0];
                s1.async = true;
                s1.src = '<?php echo e($general_setting->tawk_chat_link); ?>';
                s1.charset = 'UTF-8';
                s1.setAttribute('crossorigin', '*');
                s0.parentNode.insertBefore(s1, s0);
            })();
        </script>
    <?php endif; ?>



    <?php if($general_setting->cookie_consent_status == 1): ?>
        <!-- common-modal start  -->
        <div class="common-modal cookie_consent_modal d-none bg-white">
            <button type="button" class="btn-close cookie_consent_close_btn" aria-label="Close"></button>

            <h5><?php echo e(__('translate.Cookies')); ?></h5>
            <p><?php echo e($general_setting->cookie_consent_message); ?></p>


            <a href="javascript:;"
                class="td_btn td_style_1 td_type_3 td_radius_30 td_medium td_fs_14 report-modal-btn cookie_consent_accept_btn">
                <span class="td_btn_in td_accent_color">
                    <span><?php echo e(__('translate.Accept')); ?></span>
                </span>
            </a>

        </div>
        <!-- common-modal end  -->
    <?php endif; ?>


    <!-- Script -->
    <script src="<?php echo e(asset('global/js/jquery-3.7.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/isotope.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/imagesloaded.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/jquery.odometer.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/jquery.appear.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/swiper-bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/flatpickr.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/nice-select.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/ajax-form.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/wow.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/cart.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/main.js')); ?>"></script>
    <script src="<?php echo e(asset('global/toastr/toastr.min.js')); ?>"></script>

    <script>
        (function($) {
            "use strict"
            $(document).ready(function() {

                const session_notify_message = <?php echo json_encode(Session::get('message'), 15, 512) ?>;
                const demo_mode_message = <?php echo json_encode(Session::get('demo_mode'), 15, 512) ?>;

                if (session_notify_message != null) {
                    const session_notify_type = <?php echo json_encode(Session::get('alert-type', 'info'), 512) ?>;
                    switch (session_notify_type) {
                        case 'info':
                            toastr.info(session_notify_message);
                            break;
                        case 'success':
                            toastr.success(session_notify_message);
                            break;
                        case 'warning':
                            toastr.warning(session_notify_message);
                            break;
                        case 'error':
                            toastr.error(session_notify_message);
                            break;
                    }
                }

                if (demo_mode_message != null) {
                    toastr.warning(
                        "<?php echo e(__('translate.All Language keywords are not implemented in the demo mode')); ?>"
                    );
                    toastr.info("<?php echo e(__('translate.Admin can translate every word from the admin panel')); ?>");
                }

                const validation_errors = <?php echo json_encode($errors->all(), 15, 512) ?>;

                if (validation_errors.length > 0) {
                    validation_errors.forEach(error => toastr.error(error));
                }

                if (localStorage.getItem('tourex-cookie') != '1') {
                    $('.cookie_consent_modal').removeClass('d-none');
                }

                $('.cookie_consent_close_btn').on('click', function() {
                    $('.cookie_consent_modal').addClass('d-none');
                });

                $('.cookie_consent_accept_btn').on('click', function() {
                    localStorage.setItem('tourex-cookie', '1');
                    $('.cookie_consent_modal').addClass('d-none');
                });

                $('.before_auth_wishlist').on("click", function() {
                    toastr.error("<?php echo e(__('translate.Please login first')); ?>")
                });

                $(".currency_code").on('change', function() {
                    var currency_code = $(this).val();

                    window.location.href = "<?php echo e(route('currency-switcher')); ?>" + "?currency_code=" +
                        currency_code;
                });

                $(".language_code").on('change', function() {
                    var language_code = $(this).val();

                    window.location.href = "<?php echo e(route('language-switcher')); ?>" + "?lang_code=" +
                        language_code;
                });

            });
        })(jQuery);
    </script>


    <?php echo $__env->yieldPushContent('js_section'); ?>


</body>

</html>
<?php /**PATH /home/slipinho/public_html/resources/views/layout_inner_page.blade.php ENDPATH**/ ?>