
<?php $__env->startSection('title'); ?>
    <title><?php echo e($seo_setting->seo_title); ?></title>
    <meta name="title" content="<?php echo e($seo_setting->seo_title); ?>">
    <meta name="description" content="<?php echo strip_tags(clean($seo_setting->seo_description)); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('front-content'); ?>

<?php echo $__env->make('breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Terms & Conditions Section -->
<section class="terms-section">
    <div class="td_height_100 td_height_lg_50"></div>
    <div class="container">
        <div class="row td_gap_y_50">
            <div class="col-lg-12">

                <!-- Terms Card -->
                <div class="terms-card">
                    <!-- Terms Header -->
                    <div class="terms-header">
                        <div class="terms-icon">
                            <i class="fa-solid fa-file-contract"></i>
                        </div>
                        <h1 class="terms-title"><?php echo e($seo_setting->seo_title); ?></h1>
                        <p class="terms-updated">Last Updated: <?php echo e(now()->format('F d, Y')); ?></p>
                    </div>

                    <!-- Terms Content -->
                    <div class="terms-content">
                        <div class="td_blog_details">
                            <?php echo clean($terms_conditions->description); ?>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <div class="td_height_100 td_height_lg_50"></div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('style_section'); ?>
<style>
/* ========================================
   Terms & Conditions Page - Modern Design
   ======================================== */

/* Variables */
:root {
    --tc-primary: #059669;
    --tc-primary-light: #d1fae5;
    --tc-primary-dark: #047857;
    --tc-secondary: #10b981;
    --tc-accent: #34d399;
    --tc-text: #1e293b;
    --tc-text-light: #64748b;
    --tc-text-muted: #94a3b8;
    --tc-border: #e2e8f0;
    --tc-bg: #f8fafc;
    --tc-white: #ffffff;
    --tc-shadow: 0 1px 3px rgba(0, 0, 0, 0.08);
    --tc-shadow-md: 0 4px 20px rgba(0, 0, 0, 0.08);
    --tc-shadow-lg: 0 10px 40px rgba(0, 0, 0, 0.12);
    --tc-radius: 20px;
    --tc-radius-sm: 12px;
}

/* Page Section */
.terms-section {
    background: linear-gradient(180deg, var(--tc-bg) 0%, var(--tc-white) 50%);
    min-height: 60vh;
}

/* Terms Card */
.terms-card {
    background: var(--tc-white);
    border-radius: var(--tc-radius);
    box-shadow: var(--tc-shadow-lg);
    overflow: hidden;
    animation: fadeInUp 0.6s ease-out;
}

/* Terms Header */
.terms-header {
    text-align: center;
    padding: 50px 40px 40px;
    background: linear-gradient(135deg, #0066b0 0%, #0066b0 100%);
    position: relative;
    overflow: hidden;
}

.terms-header::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -20%;
    width: 400px;
    height: 400px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 50%;
}

.terms-header::after {
    content: '';
    position: absolute;
    bottom: -30%;
    left: -10%;
    width: 300px;
    height: 300px;
    background: rgba(255, 255, 255, 0.05);
    border-radius: 50%;
}

.terms-icon {
    width: 80px;
    height: 80px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 20px;
    position: relative;
    z-index: 1;
}

.terms-icon i {
    font-size: 36px;
    color: var(--tc-white);
}

.terms-title {
    font-size: 32px;
    font-weight: 700;
    color: var(--tc-white);
    margin: 0 0 12px 0;
    position: relative;
    z-index: 1;
}

.terms-updated {
    font-size: 14px;
    color: rgba(255, 255, 255, 0.8);
    margin: 0;
    position: relative;
    z-index: 1;
}

/* Terms Content */
.terms-content {
    padding: 50px 60px 60px;
}

/* Blog Details Styling */
.terms-content .td_blog_details {
    color: var(--tc-text);
    font-size: 16px;
    line-height: 1.85;
}

/* Typography */
.terms-content h1,
.terms-content h2,
.terms-content h3,
.terms-content h4,
.terms-content h5,
.terms-content h6 {
    color: var(--tc-text);
    font-weight: 600;
    margin-top: 36px;
    margin-bottom: 16px;
    line-height: 1.4;
}

.terms-content h1:first-child,
.terms-content h2:first-child,
.terms-content h3:first-child {
    margin-top: 0;
}

.terms-content h2 {
    font-size: 26px;
    padding-bottom: 14px;
    border-bottom: 2px solid var(--tc-primary-light);
    display: flex;
    align-items: center;
    gap: 12px;
}

.terms-content h2::before {
    content: '';
    width: 4px;
    height: 28px;
    background: var(--tc-primary);
    border-radius: 2px;
}

.terms-content h3 {
    font-size: 20px;
    color: var(--tc-primary-dark);
}

.terms-content h4 {
    font-size: 18px;
}

.terms-content p {
    margin-bottom: 18px;
    color: var(--tc-text);
}

.terms-content p:last-child {
    margin-bottom: 0;
}

/* Strong/Bold Text */
.terms-content strong,
.terms-content b {
    color: var(--tc-text);
    font-weight: 600;
}

/* Links */
.terms-content a {
    color: var(--tc-primary);
    text-decoration: none;
    font-weight: 500;
    transition: all 0.2s ease;
    border-bottom: 1px dashed var(--tc-primary);
}

.terms-content a:hover {
    color: var(--tc-secondary);
    border-bottom-style: solid;
}

/* Lists */
.terms-content ul,
.terms-content ol {
    margin: 24px 0;
    padding-left: 0;
    list-style: none;
}

.terms-content ul li,
.terms-content ol li {
    position: relative;
    padding: 12px 0 12px 36px;
    border-bottom: 1px solid var(--tc-border);
}

.terms-content ul li:last-child,
.terms-content ol li:last-child {
    border-bottom: none;
}

.terms-content ul li::before {
    content: '';
    position: absolute;
    left: 8px;
    top: 20px;
    width: 8px;
    height: 8px;
    background: var(--tc-primary);
    border-radius: 50%;
}

.terms-content ol {
    counter-reset: terms-item;
}

.terms-content ol li {
    padding-left: 44px;
}

.terms-content ol li::before {
    content: counter(terms-item);
    counter-increment: terms-item;
    position: absolute;
    left: 0;
    top: 10px;
    width: 28px;
    height: 28px;
    background: linear-gradient(135deg, var(--tc-primary) 0%, var(--tc-primary-dark) 100%);
    color: var(--tc-white);
    border-radius: 50%;
    font-size: 13px;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
}

/* Nested Lists */
.terms-content ul ul,
.terms-content ol ol,
.terms-content ul ol,
.terms-content ol ul {
    margin: 12px 0;
    padding-left: 20px;
}

/* Blockquote */
.terms-content blockquote {
    margin: 32px 0;
    padding: 24px 32px;
    background: linear-gradient(135deg, var(--tc-primary-light) 0%, var(--tc-white) 100%);
    border-left: 4px solid var(--tc-primary);
    border-radius: 0 var(--tc-radius-sm) var(--tc-radius-sm) 0;
    font-style: italic;
    color: var(--tc-text);
}

.terms-content blockquote p {
    margin: 0;
}

/* Tables */
.terms-content table {
    width: 100%;
    margin: 28px 0;
    border-collapse: collapse;
    border-radius: var(--tc-radius-sm);
    overflow: hidden;
    box-shadow: var(--tc-shadow);
}

.terms-content table thead {
    background: linear-gradient(135deg, var(--tc-primary) 0%, var(--tc-primary-dark) 100%);
    color: var(--tc-white);
}

.terms-content table th {
    padding: 16px 20px;
    text-align: left;
    font-weight: 600;
    font-size: 14px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.terms-content table td {
    padding: 16px 20px;
    border-bottom: 1px solid var(--tc-border);
}

.terms-content table tbody tr:nth-child(even) {
    background: var(--tc-bg);
}

.terms-content table tbody tr:hover {
    background: var(--tc-primary-light);
}

/* Highlighted Sections */
.terms-content .highlight,
.terms-content .important,
.terms-content .note {
    padding: 20px 24px;
    border-radius: var(--tc-radius-sm);
    margin: 24px 0;
    background: var(--tc-primary-light);
    border-left: 4px solid var(--tc-primary);
}

/* Horizontal Rule */
.terms-content hr {
    border: none;
    height: 2px;
    background: linear-gradient(90deg, transparent, var(--tc-border), transparent);
    margin: 40px 0;
}

/* Animation */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Responsive Styles */
@media (max-width: 992px) {
    .terms-header {
        padding: 40px 30px 35px;
    }

    .terms-title {
        font-size: 28px;
    }

    .terms-icon {
        width: 70px;
        height: 70px;
    }

    .terms-icon i {
        font-size: 30px;
    }

    .terms-content {
        padding: 40px 40px 50px;
    }
}

@media (max-width: 768px) {
    .terms-header {
        padding: 35px 24px 30px;
    }

    .terms-title {
        font-size: 24px;
    }

    .terms-icon {
        width: 60px;
        height: 60px;
    }

    .terms-icon i {
        font-size: 26px;
    }

    .terms-updated {
        font-size: 13px;
    }

    .terms-content {
        padding: 32px 28px 40px;
    }

    .terms-content .td_blog_details {
        font-size: 15px;
    }

    .terms-content h2 {
        font-size: 22px;
    }

    .terms-content h2::before {
        height: 24px;
    }

    .terms-content h3 {
        font-size: 18px;
    }

    .terms-content blockquote {
        padding: 20px 24px;
    }
}

@media (max-width: 480px) {
    .terms-card {
        border-radius: var(--tc-radius-sm);
    }

    .terms-header {
        padding: 30px 20px 25px;
    }

    .terms-title {
        font-size: 20px;
    }

    .terms-icon {
        width: 56px;
        height: 56px;
    }

    .terms-icon i {
        font-size: 24px;
    }

    .terms-content {
        padding: 28px 20px 36px;
    }

    .terms-content .td_blog_details {
        font-size: 14px;
        line-height: 1.75;
    }

    .terms-content h2 {
        font-size: 18px;
        padding-bottom: 10px;
    }

    .terms-content h2::before {
        width: 3px;
        height: 20px;
    }

    .terms-content ul li,
    .terms-content ol li {
        padding-left: 30px;
    }

    .terms-content ol li {
        padding-left: 38px;
    }

    .terms-content ol li::before {
        width: 24px;
        height: 24px;
        font-size: 11px;
    }

    .terms-content table th,
    .terms-content table td {
        padding: 12px 14px;
        font-size: 13px;
    }
}

/* Print Styles */
@media print {
    .terms-section {
        background: white;
    }

    .terms-card {
        box-shadow: none;
        border: 1px solid #ddd;
    }

    .terms-header {
        background: #f5f5f5;
        color: #333;
    }

    .terms-icon,
    .terms-header::before,
    .terms-header::after {
        display: none;
    }

    .terms-title {
        color: #333;
    }

    .terms-updated {
        color: #666;
    }
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layout_inner_page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/slipinho/public_html/resources/views/terms_conditions.blade.php ENDPATH**/ ?>