<?php $__env->startSection('title'); ?>
    <title><?php echo e($seo_setting->seo_title); ?></title>
    <meta name="title" content="<?php echo e($seo_setting->seo_title); ?>">
    <meta name="description" content="<?php echo strip_tags(clean($seo_setting->seo_description)); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('front-content'); ?>
    <?php echo $__env->make('breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- tg-team-details-area-start -->
    <div class="tg-team-details-area pt-130 p-relative z-index-1 pb-90">
        <img class="tg-team-shape-2 d-none d-md-block" src="assets/img/banner/banner-2/shape.png" alt="">
        <div class="container">
            <div class="row">
                <div class="col-lg-5">
                    <div class="tg-team-details-thumb mb-30">
                        <img class="w-100" src="<?php echo e(asset($team->image_details ?? $team->image)); ?>" alt="<?php echo e($team->translate->name); ?>">
                    </div>
                </div>
                <div class="col-lg-7">
                    <div class="tg-team-details-contant-wrap ml-40 mr-80 mb-30">
                        <div class="tg-team-content tg-team-details-head mb-30">
                            <h5><?php echo e($team->translate->name); ?></h5>
                            <span><?php echo e($team->translate->designation); ?></span>
                            <div class="tg-team-social">
                                <a target="_blank" href="<?php echo e($team->facebook); ?>"><i class="fa-brands fa-facebook-f"></i></a>
                                <a target="_blank" href="<?php echo e($team->twitter); ?>"><i class="fa-brands fa-twitter"></i></a>
                                <a target="_blank" href="<?php echo e($team->instagram); ?>"><i class="fa-brands fa-instagram"></i></a>
                                <a target="_blank" href="<?php echo e($team->pinterest); ?>"><i
                                        class="fa-brands fa-pinterest-p"></i></a>
                            </div>
                        </div>
                        <div class="tg-team-details-contant">
                            <h6 class="mb-15"><?php echo e(__('translate.About Me')); ?>:</h6>
                            <p>
                                <?php echo strip_tags(clean($team->translate->description)); ?>

                            </p>

                            <h6 class="mb-15"><?php echo e(__('translate.Professional Skills')); ?> : </h6>
                            <p class="mb-30">
                                <?php echo strip_tags(clean($team->translate->skill_short_description)); ?>

                            </p>

                            <?php if($team->translate->skill_list && count($team->translate->skill_list) > 0): ?>
                                <div class="tg-team-progress-wrap fix mb-15">
                                    <?php $__currentLoopData = $team->translate->skill_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="tg-team-single-progress mb-20">
                                            <h5 class="tg-team-progress-title"><?php echo e($skill['title']); ?></h5>
                                            <div class="tg-team-progress">
                                                <div class="progress-bar wow slideInLeft" data-wow-duration="2s"
                                                    data-wow-delay=".1s" role="progressbar"
                                                    data-width="<?php echo e($skill['percentage'] ?? 0); ?>%"
                                                    aria-valuenow="<?php echo e($skill['percentage']); ?>" aria-valuemin="0"
                                                    aria-valuemax="100">
                                                    <span><?php echo e($skill['percentage']); ?>%</span>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>

                            <h6 class="mb-15"><?php echo e(__('translate.Information')); ?>:</h6>
                            <p class="mb-25">
                                <?php echo strip_tags(clean($team->translate->information)); ?>

                            </p>
                            <div class="tg-team-details-contact-info">
                                <div class="row row-cols-sm-2 row-cols-1">
                                    <div class="col">
                                        <div class="tg-team-details-contact">
                                            <span><?php echo e(__('translate.Phone')); ?> :</span>
                                            <a href="tel:<?php echo e($team->phone_number); ?>"><?php echo e($team->phone_number); ?></a>
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="tg-team-details-contact">
                                            <span><?php echo e(__('translate.Website')); ?> : </span>
                                            <a href="<?php echo e(getLink($team->website)); ?>"><?php echo e($team->website); ?></a>
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="tg-team-details-contact">
                                            <span><?php echo e(__('translate.E-mail')); ?> : </span>
                                            <a href="mailto:<?php echo e($team->mail); ?>"><?php echo e($team->mail); ?></a>
                                        </div>
                                    </div>
                                    <div class="col">
                                        <div class="tg-team-details-contact">
                                            <span><?php echo e(__('translate.Address')); ?> :</span>
                                            <a href="#"> <?php echo e($team->address); ?> </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- tg-team-details-area-end -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style_section'); ?>
    <style>
        .tg-team-details-thumb.mb-30 {
            background: #efefef;
            border-radius: 15px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout_inner_page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/slipinho/public_html/resources/views/team_single.blade.php ENDPATH**/ ?>