
<style>
    /* Modern Package Card Styles */
    .package-grid-area {
        padding: 60px 0;
        font-family: 'Inter', sans-serif;
    }

    .package-card {
        background: #fff;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.06);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        height: 100%;
        border: 1px solid #e2e8f0;
        display: flex;
        flex-direction: column;
    }

    .package-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
    }

    /* Thumb */
    .package-thumb-wrapper {
        position: relative;
        height: 220px;
        overflow: hidden;
    }

    .package-thumb {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.5s ease;
    }

    .package-card:hover .package-thumb {
        transform: scale(1.05);
    }

    /* Badges */
    .badge-container {
        position: absolute;
        top: 15px;
        left: 15px;
        display: flex;
        flex-direction: column;
        gap: 8px;
        z-index: 2;
    }

    .package-badge {
        display: inline-block;
        padding: 5px 12px;
        border-radius: 4px;
        font-size: 12px;
        font-weight: 700;
        text-transform: uppercase;
        color: #fff;
        box-shadow: 0 2px 4px rgba(0,0,0,0.2);
    }

    .badge-new {
        background-color: #10b981; /* Green */
    }

    .badge-sale {
        background-color: #ef4444; /* Red */
    }

    .badge-featured {
        background-color: #3b82f6; /* Blue */
    }

    .wishlist-btn {
        position: absolute;
        top: 15px;
        right: 15px;
        width: 36px;
        height: 36px;
        background: rgba(255, 255, 255, 0.9);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        z-index: 3;
        transition: all 0.3s;
        border: none;
    }

    .wishlist-btn:hover {
        background: #fff;
        transform: scale(1.1);
    }

    .wishlist-btn svg {
        width: 18px;
        height: 18px;
        stroke: #64748b;
        fill: none;
    }

    .wishlist-btn.active svg {
        fill: #ef4444;
        stroke: #ef4444;
    }

    /* Content */
    .package-content {
        padding: 20px;
        flex: 1;
        display: flex;
        flex-direction: column;
    }

    .package-title {
        font-size: 18px;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 8px;
        line-height: 1.4;
    }

    .package-title a {
        text-decoration: none;
        color: inherit;
        transition: color 0.2s;
    }

    .package-title a:hover {
        color: #3b82f6;
    }

    .package-location {
        font-size: 14px;
        color: #64748b;
        margin-bottom: 15px;
        display: flex;
        align-items: center;
        gap: 6px;
    }

    /* Metadata Info Row */
    .package-meta-row {
        display: flex;
        align-items: center;
        gap: 15px;
        font-size: 13px;
        font-weight: 500;
        color: #475569;
        margin-bottom: 20px;
    }

    .meta-data {
        display: flex;
        align-items: center;
        gap: 6px;
    }

    .meta-data i {
        color: #64748b;
    }
    
    .rating-badge {
        background-color: #0f172a;
        color: #fff;
        padding: 2px 6px;
        border-radius: 4px;
        font-weight: 700;
        font-size: 12px;
    }

    /* Price Section */
    .package-price-section {
        margin-top: auto;
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        border-top: 1px dashed #e2e8f0;
        padding-top: 15px;
    }

    .discount-tag {
        background-color: #15803d; /* Dark Green */
        color: #fff;
        padding: 4px 10px;
        border-radius: 4px;
        font-size: 12px;
        font-weight: 600;
        margin-bottom: 5px;
    }

    .price-final {
        font-size: 20px;
        font-weight: 800;
        color: #0f172a;
        line-height: 1;
    }

    .price-original {
        font-size: 14px;
        color: #94a3b8;
        text-decoration: line-through;
        margin-left: 5px;
    }

    .price-label {
        font-size: 12px;
        color: #64748b;
        margin-top: 2px;
    }

    .time-info {
        font-size: 12px;
        color: #64748b;
        margin-top: 10px;
        align-self: flex-start;
    }
</style>


<?php if($allServices->count() > 0): ?>
    <div class="package-grid-area">
        <div class="container">
            <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['row', 'list-card-open' => $isListView == 'true']); ?>">
                <?php $__currentLoopData = $allServices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xxl-4 col-xl-4 col-lg-6 col-md-6 mb-4">
                        <div class="package-card">
                            <!-- Image & Badges -->
                            <div class="package-thumb-wrapper">
                                <a href="<?php echo e(route('front.tourbooking.services.show', ['slug' => $service?->slug])); ?>">
                                    <img class="package-thumb"
                                        src="<?php echo e(asset($service?->thumbnail?->file_path)); ?>"
                                        alt="<?php echo e($service?->thumbnail?->caption ?? $service?->translation?->title); ?>">
                                </a>

                                <div class="badge-container">
                                    <?php if($service?->is_new == 1): ?>
                                        <span class="package-badge badge-new">New</span>
                                    <?php endif; ?>
                                    <?php if($service?->discount_price): ?>
                                        <span class="package-badge badge-sale">Sale Offer</span>
                                    <?php endif; ?>
                                    <?php if($service?->is_featured == 1): ?>
                                        <span class="package-badge badge-featured">Featured</span>
                                    <?php endif; ?>
                                </div>

                                <!-- Wishlist -->
                                <div class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                    'wishlist-btn',
                                    'active' => $service?->my_wishlist_exists == 1,
                                ]); ?>" data-url="<?php echo e(route('user.wishlist.store')); ?>"
                                    onclick="addToWishlist(<?php echo e($service->id); ?>, this, 'service')">
                                    <svg viewBox="0 0 20 18">
                                        <path
                                            d="M10.5167 16.3416C10.2334 16.4416 9.76675 16.4416 9.48341 16.3416C7.06675 15.5166 1.66675 12.075 1.66675 6.24165C1.66675 3.66665 3.74175 1.58331 6.30008 1.58331C7.81675 1.58331 9.15841 2.31665 10.0001 3.44998C10.8417 2.31665 12.1917 1.58331 13.7001 1.58331C16.2584 1.58331 18.3334 3.66665 18.3334 6.24165C18.3334 12.075 12.9334 15.5166 10.5167 16.3416Z"
                                            stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                </div>
                            </div>

                            <!-- Body -->
                            <div class="package-content">
                                <h4 class="package-title">
                                    <a href="<?php echo e(route('front.tourbooking.services.show', ['slug' => $service?->slug])); ?>">
                                        <?php echo e(Str::limit($service?->translation?->title, 50)); ?>

                                    </a>
                                </h4>

                                <!-- Location -->
                                <div class="package-location">
                                    <i class="fa-solid fa-location-dot"></i>
                                    <?php echo e($service?->location ?? 'Unknown Location'); ?>

                                </div>

                                <!-- Meta: Rating & Duration -->
                                <div class="package-meta-row">
                                    <div class="meta-data">
                                        <span class="rating-badge">
                                            <?php echo e($service?->active_reviews_avg_rating > 0 ? number_format($service->active_reviews_avg_rating, 1) : 'NEW'); ?>

                                        </span>
                                        <span>
                                            <?php echo e($service?->active_reviews_avg_rating >= 4 ? 'Very Good' : ($service?->active_reviews_avg_rating > 0 ? 'Good' : 'No Reviews')); ?>

                                        </span>
                                        <span style="color:#94a3b8">(<?php echo e($service?->active_reviews_count); ?>)</span>
                                    </div>
                                    
                                    <?php if($service?->duration): ?>
                                    <div class="meta-data">
                                        <i class="fa-regular fa-clock"></i>
                                        <?php echo e($service->duration); ?>

                                    </div>
                                    <?php endif; ?>
                                </div>

                                <!-- Footer / Price -->
                                <div class="package-price-section">
                                    <?php if($service?->discount_price): ?>
                                        <span class="discount-tag">Limited Time Offer</span>
                                    <?php endif; ?>
                                    
                                    <div>
                                        <span class="price-final"><?php echo $service->price_display; ?></span>
                                        
                                    </div>
                                    <span class="price-label">per traveller</span>
                                    
                                    <!-- Dynamic Time/Info -->
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            
            <div class="text-center mt-50 mb-30">
                <?php echo $__env->make('components.front.custom-pagination', ['items' => $allServices], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
<?php else: ?>
    <div class="container py-5 text-center">
        <h4 class="text-muted">No packages found at the moment.</h4>
    </div>
<?php endif; ?><?php /**PATH /home/slipinho/public_html/Modules/TourBooking/resources/views/front/services/services-item2.blade.php ENDPATH**/ ?>