<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('translate.Service Availability')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-header'); ?>
    <h3 class="crancy-header__title m-0"><?php echo e(__('translate.Service Availability Management')); ?></h3>
    <p class="crancy-header__text">
        <?php echo e(__('translate.Manage Availability')); ?> >> <?php echo e($service->title); ?>

    </p>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style_section'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('global/select2/select2.min.css')); ?>">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <style>
        .availability-calendar {
            margin-top: 20px;
        }

        .fc-day-grid-event {
            cursor: pointer;
        }

        .availability-legend {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
        }

        .legend-item {
            display: flex;
            align-items: center;
            margin-right: 20px;
        }

        .legend-color {
            width: 20px;
            height: 20px;
            margin-right: 5px;
            border-radius: 3px;
        }

        .legend-available {
            background-color: #4caf50;
        }

        .legend-unavailable {
            background-color: #f44336;
        }

        .legend-limited {
            background-color: #ff9800;
        }

        .date-range-select {
            margin-bottom: 20px;
            padding: 15px;
            background-color: #f9f9f9;
            border-radius: 5px;
            border: 1px solid #e0e0e0;
        }

        .date-range-title {
            font-weight: 600;
            margin-bottom: 10px;
        }

        .date-picker-container {
            margin-bottom: 15px;
        }

        .availability-actions {
            margin-top: 10px;
        }

        .selected-dates {
            margin-top: 15px;
            padding: 10px;
            background-color: #f0f7ff;
            border: 1px dashed #c0d6f9;
            border-radius: 5px;
            display: none;
        }

        #selectedDatesCount {
            font-weight: 600;
            color: #2563eb;
        }

        .flatpickr-day.selected.available {
            background-color: #4caf50;
        }

        .flatpickr-day.selected.unavailable {
            background-color: #f44336;
        }

        .modal-lg {
            max-width: 800px;
        }
        .availability-flex {
            display: flex;
            align-items: center;
            gap: 5px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('body-content'); ?>
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <div class="crancy-dsinner">
                            <div class="row">
                                <div class="col-12 mg-top-30">
                                    <div class="crancy-product-card">
                                        <div class="create_new_btn_inline_box">
                                            <h4 class="crancy-product-card__title">
                                                <?php echo e(__('translate.Service Availability')); ?></h4>
                                            <div>
                                                <a href="<?php echo e(route('admin.tourbooking.services.edit', $service)); ?>"
                                                    class="crancy-btn"><i class="fa fa-edit"></i>
                                                    <?php echo e(__('translate.Edit Service')); ?></a>
                                                <a href="<?php echo e(route('admin.tourbooking.services.index')); ?>"
                                                    class="crancy-btn"><i class="fa fa-list"></i>
                                                    <?php echo e(__('translate.Service List')); ?></a>
                                            </div>
                                        </div>

                                        <div class="row mg-top-30">
                                            <div class="col-12">
                                                <div class="card">
                                                    <div class="card-body">
                                                        <div class="availability-legend">
                                                            <div class="legend-item">
                                                                <div class="legend-color legend-available"></div>
                                                                <span><?php echo e(__('translate.Available')); ?></span>
                                                            </div>
                                                            <div class="legend-item">
                                                                <div class="legend-color legend-unavailable"></div>
                                                                <span><?php echo e(__('translate.Unavailable')); ?></span>
                                                            </div>
                                                            <div class="legend-item">
                                                                <div class="legend-color legend-limited"></div>
                                                                <span><?php echo e(__('translate.Limited Spots')); ?></span>
                                                            </div>
                                                        </div>

                                                        <!-- Date Range Selection -->
                                                        <div class="date-range-select">
                                                            <h5 class="date-range-title">
                                                                <?php echo e(__('translate.Bulk Date Selection')); ?></h5>
                                                                    <div class="row">
                                                                <div class="col-md-6">
                                                                    <div class="date-picker-container">
                                                                        <label><?php echo e(__('translate.Start Date')); ?></label>
                                                                        <input type="text" id="startDate" 
                                                                            class="crancy__item-input" 
                                                                            placeholder="<?php echo e(__('translate.Select start date')); ?>">
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="date-picker-container">
                                                                        <label><?php echo e(__('translate.End Date')); ?></label>
                                                                        <input type="text" id="endDate" 
                                                                            class="crancy__item-input" 
                                                                            placeholder="<?php echo e(__('translate.Select end date')); ?>">
                                                                    </div>
                                                                            </div>
                                                                        </div>

                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label><?php echo e(__('translate.Days of Week')); ?></label>
                                                                        <div class="mt-2">
                                                                            <div class="form-check form-check-inline">
                                                                                <input class="form-check-input" type="checkbox"
                                                                                    id="day-sun" value="0" checked>
                                                                                <label class="form-check-label"
                                                                                    for="day-sun"><?php echo e(__('translate.Sun')); ?></label>
                                                                            </div>
                                                                            <div class="form-check form-check-inline">
                                                                                <input class="form-check-input" type="checkbox"
                                                                                    id="day-mon" value="1" checked>
                                                                                <label class="form-check-label"
                                                                                    for="day-mon"><?php echo e(__('translate.Mon')); ?></label>
                                                                        </div>
                                                                            <div class="form-check form-check-inline">
                                                                                <input class="form-check-input" type="checkbox"
                                                                                    id="day-tue" value="2" checked>
                                                                                <label class="form-check-label"
                                                                                    for="day-tue"><?php echo e(__('translate.Tue')); ?></label>
                                                                            </div>
                                                                            <div class="form-check form-check-inline">
                                                                                <input class="form-check-input" type="checkbox"
                                                                                    id="day-wed" value="3" checked>
                                                                                <label class="form-check-label"
                                                                                    for="day-wed"><?php echo e(__('translate.Wed')); ?></label>
                                                                            </div>
                                                                            <div class="form-check form-check-inline">
                                                                                <input class="form-check-input" type="checkbox"
                                                                                    id="day-thu" value="4" checked>
                                                                                <label class="form-check-label"
                                                                                    for="day-thu"><?php echo e(__('translate.Thu')); ?></label>
                                                                            </div>
                                                                            <div class="form-check form-check-inline">
                                                                                <input class="form-check-input" type="checkbox"
                                                                                    id="day-fri" value="5" checked>
                                                                                <label class="form-check-label"
                                                                                    for="day-fri"><?php echo e(__('translate.Fri')); ?></label>
                                                                            </div>
                                                                            <div class="form-check form-check-inline">
                                                                                <input class="form-check-input" type="checkbox"
                                                                                    id="day-sat" value="6" checked>
                                                                                <label class="form-check-label"
                                                                                    for="day-sat"><?php echo e(__('translate.Sat')); ?></label>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                        </div>
                                                                <div class="col-md-6">
                                                                    <div class="availability-actions mt-4">
                                                                        <button id="generateDatesBtn"
                                                                            class="crancy-btn"><?php echo e(__('translate.Generate Dates')); ?></button>
                                                                        <button id="clearSelectionBtn" class="crancy-btn crancy-btn-danger"
                                                                            style="display: none;"><?php echo e(__('translate.Clear Selection')); ?></button>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="selected-dates" id="selectedDatesContainer">
                                                                <p><?php echo e(__('translate.Selected')); ?>: <span
                                                                        id="selectedDatesCount">0</span> <?php echo e(__('translate.dates')); ?>

                                                                </p>
                                                                <button id="bulkManageBtn" class="crancy-btn"
                                                                    data-bs-toggle="modal" data-bs-target="#bulkManageModal"
                                                                    disabled><?php echo e(__('translate.Manage Selected Dates')); ?></button>
                                                            </div>
                                                        </div>

                                                        <!-- Calendar View -->
                                                        <div id="availabilityCalendar" class="availability-calendar"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Existing Availabilities Table -->
                                        <div class="row mg-top-30">
                                            <div class="col-12">
                                                <h5><?php echo e(__('translate.Configured Availabilities')); ?></h5>
                                                <div class="table-responsive">
                                                    <table class="table table-bordered table-hover">
                                                        <thead>
                                                            <tr>
                                                                <th><?php echo e(__('translate.Date')); ?></th>
                                                                <th><?php echo e(__('translate.Start Time')); ?></th>
                                                                <th><?php echo e(__('translate.End Time')); ?></th>
                                                                <th><?php echo e(__('translate.Status')); ?></th>
                                                                <th><?php echo e(__('translate.Available Spots')); ?></th>
                                                                <th><?php echo e(__('translate.Special Price')); ?></th>
                                                                <th><?php echo e(__('translate.Notes')); ?></th>
                                                                <th><?php echo e(__('translate.Action')); ?></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php if(count($service->availabilities) > 0): ?>
                                                                <?php $__currentLoopData = $service->availabilities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $availability): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <tr>
                                                                        <td><?php echo e(date('d M Y', strtotime($availability->date))); ?></td>
                                                                        <td><?php echo e($availability->start_time ? date('H:i', strtotime($availability->start_time)) : 'N/A'); ?></td>
                                                                        <td><?php echo e($availability->end_time ? date('H:i', strtotime($availability->end_time)) : 'N/A'); ?></td>
                                                                        <td>
                                                                            <?php if($availability->is_available): ?>
                                                                                <span class="badge bg-success"><?php echo e(__('translate.Available')); ?></span>
                                                                        <?php else: ?>
                                                                                <span class="badge bg-danger"><?php echo e(__('translate.Unavailable')); ?></span>
                                                                        <?php endif; ?>
                                                                    </td>
                                                                    <td>
                                                                            <?php if($availability->available_spots !== null): ?>
                                                                            <?php echo e($availability->available_spots); ?>

                                                                        <?php else: ?>
                                                                                <span class="text-muted"><?php echo e(__('translate.Unlimited')); ?></span>
                                                                        <?php endif; ?>
                                                                    </td>
                                                                    <td>
                                                                            <?php if($availability->special_price !== null): ?>
                                                                                <?php echo e(currency($availability->special_price)); ?>

                                                                        <?php else: ?>
                                                                                <span class="text-muted"><?php echo e(__('translate.Standard')); ?></span>
                                                                        <?php endif; ?>
                                                                    </td>
                                                                    <td>
                                                                            <?php if($availability->notes): ?>
                                                                                <?php echo e(Str::limit($availability->notes, 30)); ?>

                                                                        <?php else: ?>
                                                                            <span class="text-muted">-</span>
                                                                        <?php endif; ?>
                                                                    </td>
                                                                    <td class="availability-flex">
                                                                            <button type="button" class="btn btn-sm btn-primary edit-availability"
                                                                                data-id="<?php echo e($availability->id); ?>"
                                                                                data-date="<?php echo e($availability->date); ?>"
                                                                                data-start-time="<?php echo e($availability->start_time ? date('H:i', strtotime($availability->start_time)) : ''); ?>"
                                                                                data-end-time="<?php echo e($availability->end_time ? date('H:i', strtotime($availability->end_time)) : ''); ?>"
                                                                                data-is-available="<?php echo e($availability->is_available ? '1' : '0'); ?>"
                                                                                data-available-spots="<?php echo e($availability->available_spots); ?>"
                                                                                data-special-price="<?php echo e($availability->special_price); ?>"
                                                                                data-notes="<?php echo e($availability->notes); ?>"
                                                                                data-bs-toggle="modal" data-bs-target="#editAvailabilityModal">
                                                                            <i class="fa fa-edit"></i>
                                                                        </button>
                                                                            <button type="button" class="btn btn-sm btn-danger delete-availability"
                                                                                data-id="<?php echo e($availability->id); ?>"
                                                                                data-date="<?php echo e(date('d M Y', strtotime($availability->date))); ?>">
                                                                            <i class="fa fa-trash"></i>
                                                                        </button>
                                                                    </td>
                                                                    </tr>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php else: ?>
                                                                <tr>
                                                                    <td colspan="8" class="text-center"><?php echo e(__('translate.No availabilities configured')); ?></td>
                                                                </tr>
                                                            <?php endif; ?>
                                                        </tbody>
                                                    </table>
                                                                            </div>
                                                                                            </div>
                                                                                        </div>

                                        <!-- Add Single Availability -->
                                        <div class="row mg-top-30">
                                            <div class="col-12">
                                                <div class="card">
                                                    <div class="card-header">
                                                        <h5><?php echo e(__('translate.Add Single Date Availability')); ?></h5>
                                                                                            </div>
                                                    <div class="card-body">
                                                        <form action="<?php echo e(route('admin.tourbooking.services.availability.store', $service)); ?>" method="POST">
                                                            <?php echo csrf_field(); ?>
                                                            <div class="row">
                                                                <div class="col-md-4">
                                                                    <div class="form-group">
                                                                        <label><?php echo e(__('translate.Date')); ?> *</label>
                                                                        <input type="text" name="date" class="crancy__item-input datepicker"
                                                                            required>
                                                                                            </div>
                                                                                        </div>
                                                                <div class="col-md-4">
                                                                    <div class="form-group">
                                                                        <label><?php echo e(__('translate.Start Time')); ?></label>
                                                                        <input type="text" name="start_time"
                                                                            class="crancy__item-input timepicker">
                                                                                            </div>
                                                                                        </div>
                                                                <div class="col-md-4">
                                                                    <div class="form-group">
                                                                        <label><?php echo e(__('translate.End Time')); ?></label>
                                                                        <input type="text" name="end_time"
                                                                            class="crancy__item-input timepicker">
                                                                                                </div>
                                                                                            </div>
                                                                                        </div>

                                                            <div class="row mt-3">
                                                                <div class="col-md-4">
                                                                    <div class="form-group">
                                                                        <label><?php echo e(__('translate.Available Spots')); ?></label>
                                                                        <input type="number" name="available_spots"
                                                                            class="crancy__item-input" min="1" placeholder="Leave empty for unlimited">
                                                                                            </div>
                                                                                        </div>
                                                                <div class="col-md-4">
                                                                    <div class="form-group">
                                                                        <label><?php echo e(__('translate.Special Price')); ?></label>
                                                                        <input type="number" step="0.01" name="special_price"
                                                                            class="crancy__item-input" placeholder="Leave empty for standard price">
                                                                                                </div>
                                                                                            </div>
                                                                <div class="col-md-4">
                                                                    <div class="form-group">
                                                                        <label><?php echo e(__('translate.Status')); ?></label>
                                                                        <div class="form-check form-switch mt-2">
                                                                            <input class="form-check-input" type="checkbox"
                                                                                name="is_available" id="is_available" value="1" checked>
                                                                            <label class="form-check-label"
                                                                                for="is_available"><?php echo e(__('translate.Available')); ?></label>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                            </div>

                                                            <div class="row mt-3">
                                                                <div class="col-12">
                                                                    <div class="form-group">
                                                                        <label><?php echo e(__('translate.Notes')); ?></label>
                                                                        <textarea name="notes" class="crancy__item-input"
                                                                            rows="3"></textarea>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="row mt-3">
                                                                <div class="col-12">
                                                                    <button type="submit"
                                                                        class="crancy-btn"><?php echo e(__('translate.Add Availability')); ?></button>
                                                                </div>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Edit Availability Modal -->
    <div class="modal fade" id="editAvailabilityModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('translate.Edit Availability')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="editAvailabilityForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="modal-body">
                        <div class="form-group mb-3">
                            <label><?php echo e(__('translate.Date')); ?></label>
                            <input type="text" id="edit_date" class="crancy__item-input datepicker" disabled>
                        </div>
                        <div class="form-group mb-3">
                            <label><?php echo e(__('translate.Start Time')); ?></label>
                            <input type="text" name="start_time" id="edit_start_time" class="crancy__item-input timepicker">
                        </div>
                        <div class="form-group mb-3">
                            <label><?php echo e(__('translate.End Time')); ?></label>
                            <input type="text" name="end_time" id="edit_end_time" class="crancy__item-input timepicker">
                        </div>
                        <div class="form-group mb-3">
                            <label><?php echo e(__('translate.Available Spots')); ?></label>
                            <input type="number" name="available_spots" id="edit_available_spots" class="crancy__item-input"
                                min="1" placeholder="Leave empty for unlimited">
                        </div>
                        <div class="form-group mb-3">
                            <label><?php echo e(__('translate.Special Price')); ?></label>
                            <input type="number" step="0.01" name="special_price" id="edit_special_price"
                                class="crancy__item-input" placeholder="Leave empty for standard price">
                        </div>
                        <div class="form-group mb-3">
                            <label><?php echo e(__('translate.Status')); ?></label>
                                                                <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" name="is_available" id="edit_is_available" value="1">
                                        <label class="form-check-label" for="edit_is_available"><?php echo e(__('translate.Available')); ?></label>
                                    </div>
                        </div>
                        <div class="form-group mb-3">
                            <label><?php echo e(__('translate.Notes')); ?></label>
                            <textarea name="notes" id="edit_notes" class="crancy__item-input" rows="3"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                            data-bs-dismiss="modal"><?php echo e(__('translate.Cancel')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('translate.Update')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Bulk Manage Modal -->
    <div class="modal fade" id="bulkManageModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('translate.Bulk Manage Availability')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="bulkManageForm" action="<?php echo e(route('admin.tourbooking.services.availability.store', $service)); ?>"
                    method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="bulk" value="1">
                    <input type="hidden" name="dates[]" id="bulk_dates">
                    <div class="modal-body">
                        <div class="alert alert-info">
                            <p><?php echo e(__('translate.You are about to configure availability for')); ?>

                                <strong id="bulkDateCount">0</strong> <?php echo e(__('translate.dates')); ?>.
                            </p>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label><?php echo e(__('translate.Start Time')); ?></label>
                                    <input type="text" name="start_time" id="bulk_start_time"
                                        class="crancy__item-input timepicker">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label><?php echo e(__('translate.End Time')); ?></label>
                                    <input type="text" name="end_time" id="bulk_end_time" class="crancy__item-input timepicker">
                                    </div>
                                </div>
                            </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label><?php echo e(__('translate.Available Spots')); ?></label>
                                    <input type="number" name="available_spots" id="bulk_available_spots"
                                        class="crancy__item-input" min="1" placeholder="Leave empty for unlimited">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label><?php echo e(__('translate.Special Price')); ?></label>
                                    <input type="number" step="0.01" name="special_price" id="bulk_special_price"
                                        class="crancy__item-input" placeholder="Leave empty for standard price">
                                    </div>
                                </div>
                            </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label><?php echo e(__('translate.Status')); ?></label>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" name="is_available"
                                            id="bulk_is_available" value="1" checked>
                                        <label class="form-check-label"
                                            for="bulk_is_available"><?php echo e(__('translate.Available')); ?></label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label><?php echo e(__('translate.Notes')); ?></label>
                                    <textarea name="notes" id="bulk_notes" class="crancy__item-input" rows="3"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                            data-bs-dismiss="modal"><?php echo e(__('translate.Cancel')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('translate.Apply to All Selected Dates')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteAvailabilityModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('translate.Delete Availability')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><?php echo e(__('translate.Are you sure you want to delete availability for')); ?> <span id="deleteDate"></span>?</p>
                </div>
                <div class="modal-footer">
                    <form id="deleteAvailabilityForm" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="button" class="btn btn-secondary"
                            data-bs-dismiss="modal"><?php echo e(__('translate.Cancel')); ?></button>
                        <button type="submit" class="btn btn-danger"><?php echo e(__('translate.Delete')); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js_section'); ?>
    <script src="<?php echo e(asset('global/select2/select2.min.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.10/index.global.min.js'></script>
    <script>
        (function($) {
            "use strict"
            $(document).ready(function() {

                // Initialize date and time pickers
                $(".datepicker").flatpickr({
                    dateFormat: "Y-m-d",
                    minDate: "today",
                });

                $(".timepicker").flatpickr({
                    enableTime: true,
                    noCalendar: true,
                    dateFormat: "H:i",
                    time_24hr: true
                });

                // Selected dates array
                let selectedDates = [];

                // Date range selectors
                const startDatePicker = flatpickr("#startDate", {
                    dateFormat: "Y-m-d",
                    minDate: "today",
                });

                const endDatePicker = flatpickr("#endDate", {
                    dateFormat: "Y-m-d",
                    minDate: "today",
                });

                // Generate dates based on selection
                $("#generateDatesBtn").click(function() {
                    const startDate = startDatePicker.selectedDates[0];
                    const endDate = endDatePicker.selectedDates[0];

                    if (!startDate || !endDate) {
                        alert("<?php echo e(__('translate.Please select both start and end dates')); ?>");
                        return;
                    }

                    // Get selected days of week
                    const selectedDays = [];
                    for (let i = 0; i <= 6; i++) {
                        if ($(`#day-${['sun', 'mon', 'tue', 'wed', 'thu', 'fri', 'sat'][i]}`).is(':checked')) {
                            selectedDays.push(i);
                        }
                    }

                    if (selectedDays.length === 0) {
                        alert("<?php echo e(__('translate.Please select at least one day of week')); ?>");
                        return;
                    }

                    // Generate dates
                    selectedDates = [];
                    const current = new Date(startDate);
                    while (current <= endDate) {
                        if (selectedDays.includes(current.getDay())) {
                            const dateStr = current.toISOString().split('T')[0];
                            selectedDates.push(dateStr);
                        }
                        current.setDate(current.getDate() + 1);
                    }

                    updateSelectedDatesUI();
                });

                // Clear selection
                $("#clearSelectionBtn").click(function() {
                    selectedDates = [];
                    updateSelectedDatesUI();
                    calendar.unselect();
                });

                // Update UI with selected dates
                function updateSelectedDatesUI() {
                    const count = selectedDates.length;
                    $("#selectedDatesCount").text(count);

                    if (count > 0) {
                        $("#selectedDatesContainer").show();
                        $("#clearSelectionBtn").show();
                        $("#bulkManageBtn").prop("disabled", false);
                        $("#bulkDateCount").text(count);
                        
                        // Clear previous hidden inputs for dates
                        $('input[name="dates[]"]').remove();
                        
                        // Create hidden inputs for each date
                        selectedDates.forEach(function(date) {
                            $('#bulkManageForm').append('<input type="hidden" name="dates[]" value="' + date + '">');
                        });
                    } else {
                        $("#selectedDatesContainer").hide();
                        $("#clearSelectionBtn").hide();
                        $("#bulkManageBtn").prop("disabled", true);
                    }
                }

                // Edit Availability Modal
                $('.edit-availability').click(function() {
                    const id = $(this).data('id');
                    const date = $(this).data('date');
                    const startTime = $(this).data('start-time');
                    const endTime = $(this).data('end-time');
                    const isAvailable = $(this).data('is-available');
                    const availableSpots = $(this).data('available-spots');
                    const specialPrice = $(this).data('special-price');
                    const notes = $(this).data('notes');

                    $('#edit_date').val(date);
                    $('#edit_start_time').val(startTime);
                    $('#edit_end_time').val(endTime);
                    $('#edit_available_spots').val(availableSpots);
                    $('#edit_special_price').val(specialPrice);
                    $('#edit_is_available').prop('checked', isAvailable == 1);
                    $('#edit_notes').val(notes);

                    const url = "<?php echo e(route('admin.tourbooking.services.availability.update', ['service' => $service->id, 'availability' => ':id'])); ?>";
                    $('#editAvailabilityForm').attr('action', url.replace(':id', id));
                });

                // Delete Availability
                $('.delete-availability').click(function() {
                    const id = $(this).data('id');
                    const date = $(this).data('date');
                    $('#deleteDate').text(date);

                    const url = "<?php echo e(route('admin.tourbooking.services.availability.destroy', ['service' => $service->id, 'availability' => ':id'])); ?>";
                    $('#deleteAvailabilityForm').attr('action', url.replace(':id', id));

                    $('#deleteAvailabilityModal').modal('show');
                });

                // Initialize calendar
                const calendarEl = document.getElementById('availabilityCalendar');
                const calendar = new FullCalendar.Calendar(calendarEl, {
                    initialView: 'dayGridMonth',
                    headerToolbar: {
                        left: 'prev,next today',
                        center: 'title',
                        right: 'dayGridMonth,dayGridWeek'
                    },
                    events: [
                        <?php $__currentLoopData = $service->availabilities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $availability): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        {
                            title: '<?php echo e($availability->is_available ? 
                                ($availability->available_spots !== null ? $availability->available_spots." spots" : "Available") : 
                                "Not Available"); ?>',
                            start: '<?php echo e($availability->date); ?>',
                            color: '<?php echo e($availability->is_available ? 
                                ($availability->available_spots !== null && $availability->available_spots > 0 ? "#ff9800" : "#4caf50") : 
                                "#f44336"); ?>',
                            extendedProps: {
                                availabilityId: <?php echo e($availability->id); ?>,
                                isAvailable: <?php echo e($availability->is_available ? 'true' : 'false'); ?>,
                                availableSpots: <?php echo e($availability->available_spots ?? 'null'); ?>,
                                specialPrice: <?php echo e($availability->special_price ?? 'null'); ?>,
                                notes: '<?php echo e($availability->notes ?? ""); ?>'
                            }
                        },
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    eventClick: function(info) {
                        const id = info.event.extendedProps.availabilityId;
                        const url = "<?php echo e(route('admin.tourbooking.services.availability.update', ['service' => $service->id, 'availability' => ':id'])); ?>";
                        const editUrl = url.replace(':id', id);
                        
                        // Find the existing edit data in the table
                        const editBtn = $(`.edit-availability[data-id="${id}"]`);
                        if (editBtn.length) {
                            editBtn.trigger('click');
                        }
                    }
                });
                calendar.render();
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/slipinho/public_html/Modules/TourBooking/resources/views/admin/services/availability.blade.php ENDPATH**/ ?>