<?php
use Modules\Blog\App\Models\Blog;
use Illuminate\Support\Str;

$home1_blog = getContent('theme1_blog.content', true);
$blogs = Blog::with('translate:id,blog_id,lang_code,title,reading_time')
->where('status', true)
->latest()
->take(3)
->get();
?>

<!-- blog-area-start -->
<!-- blog-area-start -->
<div class="modern-blog-section">
    <div class="container">
        <!-- Section Header -->
        <div class="section-header">
            <!-- No badge/subtitle in the new design image, but keeping code if needed. Will hide or style subtly. -->
            <h2 class="section-title wow fadeInUp" data-wow-delay=".3s">
                <?php echo e(getTranslatedValue($home1_blog, 'title')); ?>

            </h2>
            <p class="section-description wow fadeInUp" data-wow-delay=".4s">
                <?php echo strip_tags(clean(getTranslatedValue($home1_blog, 'description')), '<br>'); ?>

            </p>
        </div>

        <?php if($blogs->count() > 0): ?>
        
        <div class="row">
            <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="blog-card wow fadeInUp" data-wow-delay=".<?php echo e(2 + $i); ?>s">
                    <!-- Image Area -->
                    <div class="blog-image-wrapper">
                        <img src="<?php echo e(asset($blog->image)); ?>" class="blog-img" alt="<?php echo e($blog?->translate?->title); ?>">
                        
                        <!-- Floating Category Badge -->
                        <span class="category-badge">
                            <?php echo e($blog?->category?->name ?? 'Travel'); ?>

                        </span>
                        
                        <div class="image-overlay"></div>
                    </div>

                    <!-- Content Body -->
                    <div class="blog-body">
                        <!-- Date & Comments/Time -->
                         <div class="blog-meta-top">
                            <span class="meta-date">
                                <i class="far fa-calendar-alt"></i> 
                                <?php echo e($blog->created_at->format('F d, Y')); ?>

                            </span>
                            
                            <?php if($blog?->translate?->reading_time): ?>
                            <span class="meta-comments">
                                <i class="far fa-clock"></i>
                                <?php echo e($blog?->translate?->reading_time); ?>

                            </span>
                            <?php endif; ?>
                        </div>

                        <!-- Title -->
                        <h3 class="blog-title">
                            <a href="<?php echo e(route('blog', ['slug' => $blog->slug])); ?>">
                                <?php echo e(Str::limit($blog?->translate?->title, 60)); ?>

                            </a>
                        </h3>
                        
                        <!-- Footer: Author & Button -->
                        <div class="blog-card-footer">
                            <a href="<?php echo e(route('blog', ['slug' => $blog->slug])); ?>" class="keep-reading-btn">
                                Keep Reading
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php endif; ?>

        <!-- View More Section (Optional, kept from previous code) -->
        <div class="blog-footer-link wow fadeInUp" data-wow-delay=".8s">
            <a href="<?php echo e(route('blogs')); ?>" class="view-all-btn">
                <?php echo e(__('View All Posts')); ?>

                <i class="fas fa-arrow-right"></i>
            </a>
        </div>
    </div>
</div>
<!-- blog-area-end -->
<!-- blog-area-end -->

<?php $__env->startPush('style_section'); ?>
<style>
    .modern-blog-section {
        padding: 80px 0;
        background-color: #f8f9fa; /* Light grey background */
    }

    /* Section Header */
    .section-header {
        text-align: center;
        margin-bottom: 50px;
    }

    .section-title {
        font-size: 36px;
        font-weight: 700;
        color: #1e293b;
        margin-bottom: 10px;
        text-align: left;
    }

    .section-description {
        font-size: 16px;
        color: #64748b;
        max-width: 600px;
        text-align:left;
    }

    /* Card Design */
    .blog-card {
        background: #fff;
        border-radius: 20px;
        overflow: hidden;
        box-shadow: 0 10px 30px rgba(0,0,0,0.05);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        height: 100%;
        display: flex;
        flex-direction: column;
    }

    .blog-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 35px rgba(0,0,0,0.1);
    }

    /* Image Wrapper */
    .blog-image-wrapper {
        position: relative;
        height: 220px;
        overflow: hidden;
    }

    .blog-img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.5s ease;
    }

    .blog-card:hover .blog-img {
        transform: scale(1.05);
    }

    /* Category Badge */
    .category-badge {
        position: absolute;
        top: 20px;
        left: 20px;
        background: #fff;
        color: #1e293b;
        padding: 6px 16px;
        border-radius: 30px;
        font-size: 13px;
        font-weight: 600;
         /* Optional: Add a slight shadow to pop off the image */
        box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        z-index: 2;
    }

    .image-overlay {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(to bottom, transparent 60%, rgba(0,0,0,0.2));
        z-index: 1;
    }

    /* Card Body */
    .blog-body {
        padding: 25px;
        flex: 1;
        display: flex;
        flex-direction: column;
    }

    /* Meta Info (Date / Time) */
    .blog-meta-top {
        display: flex;
        align-items: center;
        gap: 15px;
        font-size: 13px;
        color: #64748b;
        margin-bottom: 15px;
    }

    .blog-meta-top i {
        margin-right: 5px;
        color: #94a3b8;
    }

    /* Title */
    .blog-title {
        font-size: 20px;
        font-weight: 700;
        line-height: 1.4;
        margin-bottom: 20px;
        flex-grow: 1;
    }

    .blog-title a {
        color: #1e293b;
        text-decoration: none;
        transition: color 0.3s;
    }

    .blog-title a:hover {
        color: #3b82f6;
    }

    /* Footer: Author & Button */
    .blog-card-footer {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding-top: 20px;
        border-top: 1px solid #f1f5f9;
        margin-top: auto;
    }

    .blog-author {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .blog-author img {
        width: 35px;
        height: 35px;
        border-radius: 50%;
        object-fit: cover;
    }

    .blog-author span {
        font-size: 14px;
        font-weight: 600;
        color: #334155;
    }

    .keep-reading-btn {
        background-color: #f1f5f9;
        color: #334155;
        padding: 8px 18px;
        border-radius: 30px;
        font-size: 13px;
        font-weight: 600;
        text-decoration: none;
        transition: all 0.3s ease;
    }

    .keep-reading-btn:hover {
        background-color: #e2e8f0;
        color: #1e293b;
    }
    
    /* View All Button (Bottom of section) */
    .blog-footer-link {
        text-align: center;
        margin-top: 40px;
    }
    
    .view-all-btn {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        color: #3b82f6;
        font-weight: 600;
        text-decoration: none;
        font-size: 16px;
    }
    
    .view-all-btn:hover {
        text-decoration: underline;
    }

</style>
<?php $__env->stopPush(); ?><?php /**PATH C:\xampp\htdocs\slipinholidays\slipin\Cms/themes/theme1/views/components/blog.blade.php ENDPATH**/ ?>