<?php if($allServices->count() > 0): ?>
    <div class="tg-listing-grid-item">
        <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['row list-card', 'list-card-open'=> $isListView == 'true']); ?>">
            <?php $__currentLoopData = $allServices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-xxl-4 col-xl-6 col-lg-6 col-md-6 tg-grid-full">
                <div class="package-card">
                     <!-- Image & Badges -->
                     <div class="package-thumb-wrapper">
                        <a href="<?php echo e(route('front.tourbooking.services.show', ['slug' => $service?->slug])); ?>">
                            <img class="package-thumb"
                                src="<?php echo e(asset($service?->thumbnail?->file_path)); ?>"
                                alt="<?php echo e($service?->thumbnail?->caption ?? $service?->translation?->title); ?>">
                        </a>

                        <div class="badge-container">
                            <?php if($service?->is_new == 1): ?>
                                <span class="package-badge badge-new">New</span>
                            <?php endif; ?>
                            <?php if($service?->discount_price): ?>
                                <span class="package-badge badge-sale">Sale Offer</span>
                            <?php endif; ?>
                            <?php if($service?->is_featured == 1): ?>
                                <span class="package-badge badge-featured">Featured</span>
                            <?php endif; ?>
                        </div>

                        <!-- Wishlist -->
                        <div class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                            'wishlist-btn',
                            'active' => $service?->my_wishlist_exists == 1,
                        ]); ?>" data-url="<?php echo e(route('user.wishlist.store')); ?>"
                            onclick="addToWishlist(<?php echo e($service->id); ?>, this, 'service')">
                            <svg viewBox="0 0 20 18">
                                <path
                                    d="M10.5167 16.3416C10.2334 16.4416 9.76675 16.4416 9.48341 16.3416C7.06675 15.5166 1.66675 12.075 1.66675 6.24165C1.66675 3.66665 3.74175 1.58331 6.30008 1.58331C7.81675 1.58331 9.15841 2.31665 10.0001 3.44998C10.8417 2.31665 12.1917 1.58331 13.7001 1.58331C16.2584 1.58331 18.3334 3.66665 18.3334 6.24165C18.3334 12.075 12.9334 15.5166 10.5167 16.3416Z"
                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </div>
                    </div>

                    <!-- Body -->
                    <div class="package-content">
                        <!-- Location -->
                        <div class="package-location">
                            <i class="fa-solid fa-location-dot"></i>
                            <?php echo e($service?->location ?? 'Unknown Location'); ?>

                        </div>

                        <h4 class="package-title">
                            <a href="<?php echo e(route('front.tourbooking.services.show', ['slug' => $service?->slug])); ?>">
                                <?php echo e(Str::limit($service?->translation?->title, 50)); ?>

                            </a>
                        </h4>

                         <!-- Ratings (Using User's Reference Code) -->
                        <div class="mb-15">
                            <?php echo $__env->make('tourbooking::front.services.ratting', [
                                'avgRating' => $service?->active_reviews_avg_rating ?? 0,
                                'ratingCount' => $service?->active_reviews_count ?? 0
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <!-- Footer / Price / Availability -->
                        <div class="package-price-section">
                            <div class="justify-content-between align-items-end w-100 ">
                                <div>
                                    <span class="price-label">Starting From</span>
                                    <div class="d-flex align-items-center">
                                         <span class="price-final"><?php echo $service->price_display; ?></span>
                                    </div>
                                </div>
                                <a class="check-avail-btn"
                                    href="<?php echo e(route('front.tourbooking.services.show', ['slug' => $service?->slug])); ?>">
                                    Check Availability
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="text-center mt-50 mb-30">
            <?php echo $__env->make('components.front.custom-pagination', ['items' => $allServices], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
<?php else: ?>
    <div class="col-12">
        <div class="alert alert-warning">No packages found.</div>
    </div>
<?php endif; ?>

<style>
    /* =========================================
       PREMIUM PACKAGE CARD STYLES
       ========================================= */
     .package-card {
        background: #fff;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.06);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        border: 1px solid #e2e8f0;
        display: flex;
        flex-direction: column;
        margin-bottom: 30px; /* Grid spacing */
    }

    .package-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
    }

    /* Image Area */
    .package-thumb-wrapper {
        position: relative;
        height: 240px; /* Slightly taller for impact */
        overflow: hidden;
    }

    .package-thumb {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.5s ease;
    }

    .package-card:hover .package-thumb {
        transform: scale(1.05);
    }

    /* Badges */
     .badge-container {
        position: absolute;
        top: 15px;
        left: 15px;
        display: flex;
        flex-direction: column;
        gap: 8px;
        z-index: 2;
    }

    .package-badge {
        display: inline-block;
        padding: 4px 12px;
        border-radius: 4px;
        font-size: 11px;
        font-weight: 700;
        text-transform: uppercase;
        color: #fff;
        box-shadow: 0 2px 4px rgba(0,0,0,0.2);
    }

    .badge-new { background-color: #10b981; display:none;}
    .badge-sale { background-color: #ef4444;display:none; }
    .badge-featured { background-color: #3b82f6; display:none;}

    /* Wishlist */
    .wishlist-btn {
        position: absolute;
        top: 15px;
        right: 15px;
        width: 36px;
        height: 36px;
        background: rgba(255, 255, 255, 0.95);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        z-index: 3;
        transition: all 0.3s;
        border: none;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }

    .wishlist-btn:hover {
        transform: scale(1.1);
        background: #fff;
    }

    .wishlist-btn svg {
        width: 18px;
        height: 18px;
        stroke: #64748b;
        fill: none;
    }

    .wishlist-btn.active svg {
        fill: #ef4444;
        stroke: #ef4444;
    }

    /* Content Area */
    .package-content {
        padding: 20px;
        flex: 1;
        flex-direction: column;
        justify-content:space-between;
    }

    .package-location {
        font-size: 13px;
        color: #64748b;
        margin-bottom: 8px;
        display: flex;
        align-items: center;
        gap: 6px;
        font-weight: 500;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .package-location i { color: #3b82f6; }

    .package-title {
        font-size: 18px;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 15px;
        line-height: 1.4;
    }

    .package-title a {
        text-decoration: none;
        color: inherit;
        transition: color 0.2s;
    }

    .package-title a:hover {
        color: #3b82f6;
    }

    /* Footer Section */
    .package-price-section {
   
        border-top: 1px dashed #e2e8f0;
    }

    .price-label {
        font-size: 11px;
        text-transform: uppercase;
        color: #94a3b8;
        font-weight: 600;
        display: block;
        margin-bottom: 2px;
    }

    .price-final {
        font-size: 22px;
        font-weight: 800;
        color: #0f172a;
        margin-bottom:23px;
    }
    
    .price-final del{display:none;}

    /* Check Availability Button */
    .check-avail-btn {
        background-color: var(--tg-theme-primary, #3b82f6);
        color: #fff;
        padding: 10px 18px;
        border-radius: 50px; /* Pill shape */
        font-size: 13px;
        font-weight: 600;
        text-decoration: none;
        transition: all 0.3s;
        box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
        display:flex;
        width:100%;
        justify-content:center;
    }

    .check-avail-btn:hover {
        background-color: #1d4ed8;
        transform: translateY(-2px);
        box-shadow: 0 6px 16px rgba(59, 130, 246, 0.4);
        color: #fff;
    }
</style><?php /**PATH /home/slipinho/public_html/Modules/TourBooking/resources/views/front/services/services-item.blade.php ENDPATH**/ ?>