<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps([
    'name',
    'label',
    'value' => null,
    'placeholder' => null,
    'required' => false,
    'help' => null,
    'rows' => 4,
    'maxlength' => null,
]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps([
    'name',
    'label',
    'value' => null,
    'placeholder' => null,
    'required' => false,
    'help' => null,
    'rows' => 4,
    'maxlength' => null,
]); ?>
<?php foreach (array_filter(([
    'name',
    'label',
    'value' => null,
    'placeholder' => null,
    'required' => false,
    'help' => null,
    'rows' => 4,
    'maxlength' => null,
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<div class="crancy__item-form--group">
    <label for="<?php echo e($name); ?>" class="crancy__item-label">
        <?php echo e($label); ?>

        <?php if($required): ?>
            <span class="text-danger">*</span>
        <?php endif; ?>
        <?php if($help): ?>
            <span data-toggle="tooltip" data-placement="top" class="fa fa-info-circle text--primary"
                title="<?php echo e($help); ?>"></span>
        <?php endif; ?>
    </label>

    <div class="position-relative">
        <textarea id="<?php echo e($name); ?>" name="<?php echo e($name); ?>"
            class="crancy__item-input crancy__item-textarea <?php $__errorArgs = [$name];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
            placeholder="<?php echo e($placeholder ?? $label); ?>" rows="<?php echo e($rows); ?>" <?php echo e($maxlength ? "maxlength=$maxlength" : ''); ?>

            <?php echo e($required ? 'required' : ''); ?>><?php echo e(old($name, $value)); ?></textarea>

        <?php if($maxlength): ?>
            <small class="character-count position-absolute bottom-0 end-0 pe-2 pb-1 text-muted">
                <span class="current"><?php echo e(strlen(old($name, $value) ?? '')); ?></span>/<?php echo e($maxlength); ?>

            </small>
        <?php endif; ?>
    </div>

    <?php $__errorArgs = [$name];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <div class="invalid-feedback"><?php echo e($message); ?></div>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
</div>


<style>
    .crancy__item-textarea {
        min-height: 100px;
        resize: vertical;
    }

    .character-count {
        font-size: 12px;
        pointer-events: none;
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('textarea[maxlength]').forEach(function(textarea) {
            const counter = textarea.parentElement.querySelector('.character-count .current');
            if (counter) {
                textarea.addEventListener('input', function() {
                    counter.textContent = this.value.length;
                });
            }
        });
    });
</script>
<?php /**PATH /home/slipinho/public_html/resources/views/admin/frontend-management/fields/textarea.blade.php ENDPATH**/ ?>