<div class="tg-shop-sidebar top-sticky mb-50">
    <form action="<?php echo e(route('product.shop')); ?>" method="GET">
        <div class="tg-blog-sidebar-search tg-blog-sidebar-box mb-40">
            <h5 class="tg-blog-sidebar-title mb-15"><?php echo e(__('translate.Search')); ?></h5>
            <div class="tg-blog-sidebar-form">
                <input type="text" name="search" value="<?php echo e(request()->get('search')); ?>"
                    placeholder="<?php echo e(__('translate.Type here . . .')); ?>">
                <button type="submit" class="product_search_btn">
                    <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_497_1336)">
                            <path
                                d="M17 17L13.5247 13.5247M15.681 8.3405C15.681 12.3945 12.3945 15.681 8.3405 15.681C4.28645 15.681 1 12.3945 1 8.3405C1 4.28645 4.28645 1 8.3405 1C12.3945 1 15.681 4.28645 15.681 8.3405Z"
                                stroke="#560CE3" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        </g>
                        <defs>
                            <clipPath id="clip0_497_1336">
                                <rect width="18" height="18" fill="white" />
                            </clipPath>
                        </defs>
                    </svg>
                </button>
            </div>
        </div>
        <div class="tg-blog-categories tg-blog-sidebar-box mb-40">
            <h5 class="tg-blog-sidebar-title mb-5"><?php echo e(__('translate.Categories')); ?></h5>
            <div class="tg-blog-categories-list mt-15">
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="shop_sidebar_item_box mb-10 border-bottom pb-2">
                        <input class="form-check-input" type="checkbox" name="categories[]" value="<?php echo e($category->id); ?>"
                            id="category_<?php echo e($category->id); ?>"
                            <?php echo e(in_array($category->id, (array) request('categories', [])) ? 'checked' : ''); ?>>

                        <label class="form-check-label ms-2" for="category_<?php echo e($category->id); ?>">
                            <?php echo e($category->translate->name); ?> (<?php echo e($category->products_count); ?>)
                        </label>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <div class="tg-blog-categories tg-blog-sidebar-box mb-40">
            <h5 class="tg-blog-sidebar-title mb-5"><?php echo e(__('translate.Brands')); ?></h5>
            <div class="tg-blog-categories-list mt-15">
                <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="shop_sidebar_item_box mb-10 border-bottom pb-2">
                        <input class="form-check-input" type="checkbox" name="brands[]" value="<?php echo e($brand->id); ?>"
                            id="brand_<?php echo e($brand->id); ?>"
                            <?php echo e(in_array($brand->id, (array) request('brands', [])) ? 'checked' : ''); ?>>

                        <label class="form-check-label ms-2" for="brand_<?php echo e($brand->id); ?>">
                            <?php echo e($brand->translate->name); ?> (<?php echo e($brand->products_count); ?>)
                        </label>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <div class="tg-blog-post tg-blog-sidebar-box tg-shop-product-list-widget mb-40">
            <h5 class="tg-blog-sidebar-title mb-25"><?php echo e(__('translate.Best Selling Products')); ?></h5>

            <?php $__currentLoopData = $bestSellingProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="tg-blog-post-item d-flex align-items-center mb-20">
                    <div class="tg-blog-post-thumb mr-15">
                        <a href="shop-details.html"><img src="<?php echo e(asset($bp->thumbnail_image)); ?>" alt="product"></a>
                    </div>
                    <div class="tg-blog-post-content w-100">
                        <h4 class="tg-blog-post-title mb-5">
                            <a href="<?php echo e(route('product.view', $bp->slug)); ?>">
                                <?php echo e(__(Str::limit($bp->translate->name, 15))); ?>

                            </a>
                        </h4>
                        <?php echo $__env->make('ecommerce::frontend.partials.avg_ratting', [
                            'rating' => $bp->reviews_avg_rating,
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <span class="price">
                            <?php echo e(currency($bp->price)); ?>

                        </span>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <button type="submit" class="tg-btn d-block w-100" data-text="Apply Now">
            <span class="btn-wraper"><?php echo e(__('translate.Apply Now')); ?></span>
        </button>
    </form>
</div>
<?php /**PATH /home/slipinho/public_html/Modules/Ecommerce/Resources/views/frontend/partials/product_sidebar.blade.php ENDPATH**/ ?>