import {
  isRemoteAllowed,
  matchHostname,
  matchPathname,
  matchPattern,
  matchPort,
  matchProtocol
} from "@astrojs/internal-helpers/remote";
import { isESMImportedImage, isRemoteImage, resolveSrc } from "./imageKind.js";
import { imageMetadata } from "./metadata.js";
import {
  emitESMImage,
  emitImageMetadata
} from "./node/emitAsset.js";
import { getOrigQueryParams } from "./queryParams.js";
import { inferRemoteSize } from "./remoteProbe.js";
import { hashTransform, propsToFilename } from "./transformToPath.js";
export {
  emitESMImage,
  emitImageMetadata,
  getOrigQueryParams,
  hashTransform,
  imageMetadata,
  inferRemoteSize,
  isESMImportedImage,
  isRemoteAllowed,
  isRemoteImage,
  matchHostname,
  matchPathname,
  matchPattern,
  matchPort,
  matchProtocol,
  propsToFilename,
  resolveSrc
};
