// Mock Data for Development

import type { Destination, PromoCard, ServiceTab, NavItem } from '../types';

export const serviceTabs: ServiceTab[] = [
    { id: 'bus', name: 'Bus Booking', icon: 'bus', isActive: false },
    { id: 'flight', name: 'Flight Ticket', icon: 'plane', isActive: false },
    { id: 'local', name: 'Local Tour', icon: 'map', isActive: false },
    { id: 'overseas', name: 'Overseas Tour', icon: 'globe', isActive: true },
    { id: 'visa', name: 'Visa Application', icon: 'passport', isActive: false },
];

export const navItems: NavItem[] = [
    { id: 'explore', label: 'Explore Destination', href: '/destinations', icon: 'menu', hasDropdown: true },
    { id: 'bus', label: 'Bus Booking', href: '/bus-booking', hasDropdown: false },
    { id: 'flights', label: 'Flights', href: '/flights', hasDropdown: false },
    { id: 'local-tour', label: 'Local Tour', href: '/local-tours', hasDropdown: false },
    { id: 'hotel', label: 'Hotel Booking', href: '/hotels', hasDropdown: false },
    { id: 'car', label: 'Car rentals', href: '/car-rentals', hasDropdown: false },
];

export const promoCards: PromoCard[] = [
    {
        id: '1',
        title: 'Your long-awaited',
        subtitle: 'Japan trip!',
        destination: 'Japan',
        image: 'https://images.unsplash.com/photo-1493976040374-85c8e12f0c0e?w=600&q=80',
        discount: 'Enjoy 15% Off',
        link: '/tours/japan',
    },
    {
        id: '2',
        title: 'Your long-awaited',
        subtitle: 'Taiwan trip!',
        destination: 'Taiwan',
        image: 'https://images.unsplash.com/photo-1470004914212-05527e49370b?w=600&q=80',
        discount: 'Enjoy 15% Off',
        link: '/tours/taiwan',
    },
    {
        id: '3',
        title: 'Celebrate with a',
        subtitle: 'trip to Korea!',
        destination: 'Korea',
        image: 'https://images.unsplash.com/photo-1538485399081-7191377e8241?w=600&q=80',
        code: 'Use Code "KOREA50"',
        link: '/tours/korea',
    },
];

export const destinations: Destination[] = [
    {
        id: '1',
        name: 'Kuala Lumpur',
        country: 'Malaysia',
        image: 'https://images.unsplash.com/photo-1596422846543-75c6fc197f07?w=400&q=80',
        rating: 4.8,
        totalReviews: 2543,
    },
    {
        id: '2',
        name: 'Gunung Mulu National Park',
        country: 'Malaysia',
        image: 'https://images.unsplash.com/photo-1506905925346-21bda4d32df4?w=400&q=80',
        rating: 4.9,
        totalReviews: 1876,
    },
    {
        id: '3',
        name: 'Georgetown',
        country: 'Malaysia',
        image: 'https://images.unsplash.com/photo-1558005137-d9619a5c539f?w=400&q=80',
        rating: 4.7,
        totalReviews: 3421,
    },
    {
        id: '4',
        name: 'Malacca',
        country: 'Malaysia',
        image: 'https://images.unsplash.com/photo-1595435934249-5df7ed86e1c0?w=400&q=80',
        rating: 4.6,
        totalReviews: 2187,
    },
    {
        id: '5',
        name: 'Langkawi',
        country: 'Malaysia',
        image: 'https://images.unsplash.com/photo-1586015555751-63bb77f4322a?w=400&q=80',
        rating: 4.8,
        totalReviews: 4532,
    },
    {
        id: '6',
        name: 'Penang',
        country: 'Malaysia',
        image: 'https://images.unsplash.com/photo-1506665531195-3566af2b4dfa?w=400&q=80',
        rating: 4.7,
        totalReviews: 2890,
    },
];

export const heroBackgroundImage = 'https://images.unsplash.com/photo-1506929562872-bb421503ef21?w=1920&q=80';
