export const API_URL = 'http://127.0.0.1:8000/api';

export async function fetchFromApi<T>(endpoint: string): Promise<T | null> {
    try {
        const response = await fetch(`${API_URL}${endpoint}`);
        if (!response.ok) {
            console.error(`API Error: ${response.statusText}`);
            return null;
        }
        const json = await response.json();
        return json.data ? json.data : json; // Handle wrapped and unwrapped responses
    } catch (error) {
        console.error('Fetch Error:', error);
        return null;
    }
}
