// Travel Booking Website - TypeScript Interfaces

export interface Destination {
    id: string;
    name: string;
    slug: string;
    country: string;
    image: string;
    description?: string;
    rating?: number;
    totalReviews?: number;
}

export interface Tour {
    id: string;
    title: string;
    destinationId: string;
    destination: string;
    image: string;
    price: number;
    originalPrice?: number;
    currency: string;
    duration: string;
    rating: number;
    totalReviews: number;
    description?: string;
    highlights?: string[];
    included?: string[];
    excluded?: string[];
}

export interface Hotel {
    id: string;
    name: string;
    location: string;
    image: string;
    price: number;
    originalPrice?: number;
    currency: string;
    rating: number;
    totalReviews: number;
    stars: number;
    amenities: string[];
    description?: string;
}

export interface Flight {
    id: string;
    airline: string;
    airlineLogo: string;
    departureCity: string;
    departureCode: string;
    departureTime: string;
    arrivalCity: string;
    arrivalCode: string;
    arrivalTime: string;
    duration: string;
    price: number;
    currency: string;
    stops: number;
    class: 'economy' | 'business' | 'first';
}

export interface PromoCard {
    id: string;
    title: string;
    subtitle: string;
    destination: string;
    image: string;
    discount?: string;
    code?: string;
    link: string;
}

export interface ServiceTab {
    id: string;
    name: string;
    icon: string;
    isActive: boolean;
}

export interface NavItem {
    id: string;
    label: string;
    href: string;
    icon?: string;
    hasDropdown?: boolean;
}

export interface SearchFormData {
    destination: string;
    departureDate: string;
    returnDate: string;
    serviceType: string;
    travelers?: number;
}

export interface Booking {
    id: string;
    userId: string;
    type: 'tour' | 'hotel' | 'flight' | 'visa';
    itemId: string;
    status: 'pending' | 'confirmed' | 'cancelled' | 'completed';
    totalPrice: number;
    currency: string;
    travelers: number;
    createdAt: string;
    updatedAt: string;
}

export interface User {
    id: string;
    name: string;
    email: string;
    avatar?: string;
    phone?: string;
    country?: string;
    currency?: string;
    language?: string;
}
